/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academicextensions.services.registrationhistory;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseServices;
import org.fenixedu.academic.domain.degreeStructure.CurricularPeriodServices;
import org.fenixedu.academic.domain.enrolment.EnrolmentServices;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class EnrolmentReport {
    private Enrolment enrolment;
    private ExecutionInterval executionInterval;
    private EnrolmentEvaluation finalEvaluation;

    public EnrolmentReport(Enrolment enrolment) {
        this(enrolment, enrolment.getExecutionInterval());
    }

    public EnrolmentReport(Enrolment enrolment, ExecutionInterval executionInterval) {
        this.enrolment = Objects.requireNonNull(enrolment);
        this.executionInterval = Objects.requireNonNull(executionInterval);
        this.finalEvaluation = enrolment.getFinalEnrolmentEvaluation();
    }

    public Enrolment getEnrolment() {
        return this.enrolment;
    }

    public boolean isImprovementOnly() {
        return this.executionInterval != this.enrolment.getExecutionInterval();
    }

    public Collection<Shift> getShifts() {
        return EnrolmentServices.getShiftsFor(this.enrolment, this.executionInterval);
    }

    public String getShiftsAsString() {
        return this.getShifts().stream().map(s -> s.getName()).collect(Collectors.joining(", "));
    }

    public Shift getTheoreticalShift() {
        return this.getShiftByLoadType("THEORETICAL");
    }

    public Shift getLaboratorialShift() {
        return this.getShiftByLoadType("PRACTICAL_LABORATORY");
    }

    public Shift getProblemsShift() {
        return this.getShiftByLoadType("THEORETICAL_PRACTICAL");
    }

    public Shift getSeminaryShift() {
        return this.getShiftByLoadType("SEMINAR");
    }

    public Shift getFieldWorkShift() {
        return this.getShiftByLoadType("FIELD_WORK");
    }

    public Shift getTrainingPeriodShift() {
        return this.getShiftByLoadType("INTERNSHIP");
    }

    public Shift getTutorialOrientationShift() {
        return this.getShiftByLoadType("TUTORIAL_ORIENTATION");
    }

    public Shift getOtherShift() {
        return this.getShiftByLoadType("OTHER");
    }

    private Shift getShiftByLoadType(String loadTypeCode) {
        return this.getShifts().stream().filter(s -> s.getCourseLoadType().getCode().equals(loadTypeCode)).findAny().orElse(null);
    }

    public Collection<SchoolClass> getSchoolClasses() {
        return this.enrolment.getRegistration().getSchoolClassesSet().stream().filter(sc -> sc.getExecutionPeriod() == this.executionInterval).collect(Collectors.toSet());
    }

    public String getSchoolClassesAsString() {
        return this.getSchoolClasses().stream().map(sc -> sc.getName()).collect(Collectors.joining(", "));
    }

    public CurricularPeriod getCurricularPeriod() {
        return CurricularPeriodServices.getCurricularPeriod((CurriculumLine)this.enrolment);
    }

    public AcademicPeriod getAcademicPeriod() {
        return Optional.ofNullable(this.enrolment.getCurricularCourse().getCompetenceCourse()).map(cc -> cc.getAcademicPeriod(this.executionInterval)).orElse(null);
    }

    public BigDecimal getCredits() {
        return this.enrolment.getEctsCreditsForCurriculum();
    }

    public Grade getFinalEvaluationGrade() {
        return Optional.ofNullable(this.finalEvaluation).map(ev -> ev.getGrade()).orElse(null);
    }

    public EvaluationSeason getFinalEvaluationSeason() {
        return Optional.ofNullable(this.finalEvaluation).map(ev -> ev.getEvaluationSeason()).orElse(null);
    }

    public ExecutionInterval getExecutionInterval() {
        return this.executionInterval;
    }

    public DateTime getEnrolmentDate() {
        return this.enrolment.getCreationDateDateTime();
    }

    public LocalDate getEvaluationDate() {
        return Optional.ofNullable(this.finalEvaluation).map(ev -> this.finalEvaluation.getExamDateYearMonthDay().toLocalDate()).orElse(null);
    }

    public CurriculumGroup getCurriculumGroup() {
        return this.enrolment.getCurriculumGroup();
    }

    public Integer getEnrolmentsCount() {
        return CompetenceCourseServices.countEnrolmentsUntil(this.enrolment.getStudentCurricularPlan(), this.enrolment.getCurricularCourse(), this.enrolment.getExecutionYear());
    }

    public Registration getRegistration() {
        return this.enrolment.getRegistration();
    }

    public Degree getDegree() {
        return this.enrolment.getRegistration().getDegree();
    }

    public Person getPerson() {
        return this.getRegistration().getPerson();
    }

    public Integer getRegistrationCurricularYear() {
        return RegistrationServices.getCurricularYear(this.getRegistration(), this.getExecutionInterval().getExecutionYear()).getResult();
    }
}

