/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.enrolment.period;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EnrolmentType;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.enrolment.period.AcademicEnrolmentPeriod$callable$create;
import org.fenixedu.academic.domain.enrolment.period.AcademicEnrolmentPeriod$callable$delete;
import org.fenixedu.academic.domain.enrolment.period.AcademicEnrolmentPeriod$callable$edit;
import org.fenixedu.academic.domain.enrolment.period.AcademicEnrolmentPeriodType;
import org.fenixedu.academic.domain.enrolment.period.AcademicEnrolmentPeriod_Base;
import org.fenixedu.academic.domain.enrolment.period.AutomaticEnrolment;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.curriculum.CurriculumConfigurationInitializer;
import org.fenixedu.academic.domain.student.services.StatuteServices;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;
import pt.ist.fenixframework.core.AbstractDomainObject;

public class AcademicEnrolmentPeriod
extends AcademicEnrolmentPeriod_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected AcademicEnrolmentPeriod() {
        this.setBennu(Bennu.getInstance());
    }

    protected AcademicEnrolmentPeriod(DateTime startDate, DateTime endDate, Boolean firstTimeRegistration, Boolean restrictToSelectedStatutes, Boolean restrictToSelectedIngressionTypes, Integer minStudentNumber, Integer maxStudentNumber, Integer curricularYear, Boolean schoolClassSelectionMandatory, AcademicEnrolmentPeriodType enrolmentPeriodType, Boolean allowEnrolWithDebts, AutomaticEnrolment automaticEnrolment, ExecutionInterval executionInterval) {
        this();
        this.setStartDate(startDate);
        this.setEndDate(endDate);
        this.setFirstTimeRegistration(firstTimeRegistration);
        this.setRestrictToSelectedStatutes(restrictToSelectedStatutes);
        this.setRestrictToSelectedIngressionTypes(restrictToSelectedIngressionTypes);
        this.setMinStudentNumber(minStudentNumber);
        this.setMaxStudentNumber(maxStudentNumber);
        this.setCurricularYear(curricularYear);
        this.setSchoolClassSelectionMandatory(schoolClassSelectionMandatory);
        this.setEnrolmentPeriodType(enrolmentPeriodType);
        this.setAllowEnrolWithDebts(allowEnrolWithDebts);
        this.setAutomaticEnrolment(automaticEnrolment);
        this.setExecutionSemester(executionInterval);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getStartDate() == null) {
            throw new AcademicExtensionsDomainException("error.AcademicEnrolmentPeriod.startDate.required", new String[0]);
        }
        if (this.getEndDate() == null) {
            throw new AcademicExtensionsDomainException("error.AcademicEnrolmentPeriod.endDate.required", new String[0]);
        }
        if (this.getEnrolmentPeriodType() == null) {
            throw new AcademicExtensionsDomainException("error.AcademicEnrolmentPeriod.enrolmentPeriodType.required", new String[0]);
        }
        if (this.getExecutionInterval() == null) {
            throw new AcademicExtensionsDomainException("error.AcademicEnrolmentPeriod.executionSemester.required", new String[0]);
        }
        if (this.getStartDate().isAfter((ReadableInstant)this.getEndDate())) {
            throw new AcademicExtensionsDomainException("error.AcademicEnrolmentPeriod.startDate.before.endDate", new String[0]);
        }
        if (this.getMaxStudentNumber() != null && this.getMinStudentNumber() != null && this.getMinStudentNumber() > this.getMaxStudentNumber()) {
            throw new AcademicExtensionsDomainException("error.AcademicEnrolmentPeriod.minNumber.must.be.lower.maxNumber", new String[0]);
        }
    }

    public void edit(DateTime dateTime, DateTime dateTime2, Boolean bl, Boolean bl2, Boolean bl3, Integer n, Integer n2, Integer n3, Boolean bl4, AcademicEnrolmentPeriodType academicEnrolmentPeriodType, AutomaticEnrolment automaticEnrolment, Boolean bl5, ExecutionInterval executionInterval) {
        Object object = advice$edit.perform((Callable)new AcademicEnrolmentPeriod$callable$edit(this, dateTime, dateTime2, bl, bl2, bl3, n, n2, n3, bl4, academicEnrolmentPeriodType, automaticEnrolment, bl5, executionInterval));
    }

    static /* synthetic */ void advised$edit(AcademicEnrolmentPeriod this_, DateTime startDate, DateTime endDate, Boolean firstTimeRegistration, Boolean restrictToSelectedStatutes, Boolean restrictToSelectedIngressionTypes, Integer minStudentNumber, Integer maxStudentNumber, Integer curricularYear, Boolean schoolClassSelectionMandatory, AcademicEnrolmentPeriodType enrolmentPeriodType, AutomaticEnrolment automaticEnrolment, Boolean allowEnrolWithDebts, ExecutionInterval executionInterval) {
        this_.setStartDate(startDate);
        this_.setEndDate(endDate);
        this_.setFirstTimeRegistration(firstTimeRegistration);
        this_.setRestrictToSelectedStatutes(restrictToSelectedStatutes);
        this_.setRestrictToSelectedIngressionTypes(restrictToSelectedIngressionTypes);
        this_.setMinStudentNumber(minStudentNumber);
        this_.setMaxStudentNumber(maxStudentNumber);
        this_.setCurricularYear(curricularYear);
        this_.setSchoolClassSelectionMandatory(schoolClassSelectionMandatory);
        this_.setEnrolmentPeriodType(enrolmentPeriodType);
        this_.setAutomaticEnrolment(automaticEnrolment);
        this_.setAllowEnrolWithDebts(allowEnrolWithDebts);
        this_.setExecutionSemester(executionInterval);
        this_.checkRules();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new AcademicEnrolmentPeriod$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(AcademicEnrolmentPeriod this_) {
        AcademicExtensionsDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        this_.setBennu(null);
        this_.setExecutionSemester(null);
        this_.getDegreeCurricularPlansSet().clear();
        this_.getStatuteTypesSet().clear();
        this_.getIngressionTypesSet().clear();
        this_.getEnrolmentTypesSet().clear();
        this_.deleteDomainObject();
    }

    public static Stream<AcademicEnrolmentPeriod> readAll() {
        return Bennu.getInstance().getAcademicEnrolmentPeriodsSet().stream();
    }

    public static Stream<AcademicEnrolmentPeriod> findByType(AcademicEnrolmentPeriodType type) {
        return AcademicEnrolmentPeriod.readAll().filter(p -> p.getEnrolmentPeriodType() == type);
    }

    public static AcademicEnrolmentPeriod create(DateTime dateTime, DateTime dateTime2, Boolean bl, Boolean bl2, Boolean bl3, Integer n, Integer n2, Integer n3, Boolean bl4, AcademicEnrolmentPeriodType academicEnrolmentPeriodType, Boolean bl5, AutomaticEnrolment automaticEnrolment, ExecutionInterval executionInterval) {
        return (AcademicEnrolmentPeriod)((Object)advice$create.perform((Callable)new AcademicEnrolmentPeriod$callable$create(dateTime, dateTime2, bl, bl2, bl3, n, n2, n3, bl4, academicEnrolmentPeriodType, bl5, automaticEnrolment, executionInterval)));
    }

    static /* synthetic */ AcademicEnrolmentPeriod advised$create(DateTime startDate, DateTime endDate, Boolean firstTimeRegistration, Boolean restrictToSelectedStatutes, Boolean restrictToSelectedIngressionTypes, Integer minStudentNumber, Integer maxStudentNumber, Integer curricularYear, Boolean schoolClassSelectionMandatory, AcademicEnrolmentPeriodType enrolmentPeriodType, Boolean allowEnrolWithDebts, AutomaticEnrolment automaticEnrolment, ExecutionInterval executionInterval) {
        AcademicEnrolmentPeriod period = new AcademicEnrolmentPeriod(startDate, endDate, firstTimeRegistration, restrictToSelectedStatutes, restrictToSelectedIngressionTypes, minStudentNumber, maxStudentNumber, curricularYear, schoolClassSelectionMandatory, enrolmentPeriodType, allowEnrolWithDebts, automaticEnrolment, executionInterval);
        return period;
    }

    public Boolean getSchoolClassSelectionMandatory() {
        return super.getSchoolClassSelectionMandatory() != null && super.getSchoolClassSelectionMandatory() != false;
    }

    @Deprecated
    public ExecutionInterval getExecutionSemester() {
        return super.getExecutionSemester();
    }

    public ExecutionInterval getExecutionInterval() {
        return super.getExecutionSemester();
    }

    public ExecutionYear getExecutionYear() {
        return this.getExecutionInterval().getExecutionYear();
    }

    public boolean isForCurricularCourses() {
        return this.getEnrolmentPeriodType() == AcademicEnrolmentPeriodType.CURRICULAR_COURSE;
    }

    public boolean isForClasses() {
        return this.getEnrolmentPeriodType() == AcademicEnrolmentPeriodType.SCHOOL_CLASS;
    }

    public boolean isForShift() {
        return this.getEnrolmentPeriodType() == AcademicEnrolmentPeriodType.SHIFT;
    }

    public boolean isOpen() {
        return this.containsDate(new DateTime());
    }

    public boolean isUpcoming() {
        return this.getStartDate().isAfterNow();
    }

    public boolean isAutomatic() {
        return this.getAutomaticEnrolment() != null && this.getAutomaticEnrolment().isAutomatic();
    }

    public boolean isEditable() {
        return this.getAutomaticEnrolment() == null || this.getAutomaticEnrolment().isEditable();
    }

    private boolean containsDate(DateTime date) {
        return !this.getStartDate().isAfter((ReadableInstant)date) && !this.getEndDate().isBefore((ReadableInstant)date);
    }

    private boolean isValidRegistration(Registration input, boolean skipRegistrationState) {
        return skipRegistrationState || input.hasActiveLastState(this.getExecutionInterval());
    }

    private boolean isValidStudentNumber(Registration input) {
        Integer number = input.getNumber();
        return !(this.getMinStudentNumber() != null && number < this.getMinStudentNumber() || this.getMaxStudentNumber() != null && number > this.getMaxStudentNumber());
    }

    private boolean isValidStatuteTypes(Set<StatuteType> input) {
        Set configured = this.getStatuteTypesSet();
        if (configured.isEmpty()) {
            return true;
        }
        if (this.getRestrictToSelectedStatutes().booleanValue()) {
            return !Sets.intersection(input, (Set)configured).isEmpty();
        }
        return input.isEmpty() || Sets.intersection(input, (Set)configured).isEmpty();
    }

    private boolean isValidIngressionTypes(IngressionType input) {
        Set configured = this.getIngressionTypesSet();
        if (configured.isEmpty()) {
            return true;
        }
        if (this.getRestrictToSelectedIngressionTypes() != null && this.getRestrictToSelectedIngressionTypes().booleanValue()) {
            return configured.contains(input);
        }
        return input == null || !configured.contains(input);
    }

    private boolean isValidEnrolmentTypes(Registration input) {
        Set configured = this.getEnrolmentTypesSet();
        if (configured.isEmpty()) {
            return true;
        }
        if (this.isForClasses()) {
            for (EnrolmentType enrolmentType : configured) {
                boolean flunked = RegistrationServices.isFlunkedUsingCurricularYear(input, this.getExecutionYear());
                if (enrolmentType.isFlunked() && flunked) {
                    return true;
                }
                if (!enrolmentType.isNormal() || flunked) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isValidCurricularYear(int input) {
        return this.getCurricularYear() == null || this.getCurricularYear().equals(input);
    }

    private boolean isValidFirstTimeStatus(StudentCurricularPlan input) {
        return this.getFirstTimeRegistration() == null || this.getFirstTimeRegistration().equals(input.getRegistration().isFirstTime(this.getExecutionYear()));
    }

    public boolean isForFirstTimeRegistration() {
        return super.getFirstTimeRegistration() != null && super.getFirstTimeRegistration() != false;
    }

    private boolean isValidStudentCurricularPlan(StudentCurricularPlan input) {
        return this.getDegreeCurricularPlansSet().contains(input.getDegreeCurricularPlan());
    }

    public static List<AcademicEnrolmentPeriod> getEnrolmentPeriodsOpenOrUpcoming(Student student) {
        ArrayList<AcademicEnrolmentPeriod> result = new ArrayList<AcademicEnrolmentPeriod>();
        for (Registration registration : student.getRegistrationsSet()) {
            DegreeCurricularPlan degreeCurricularPlan = registration.getLastDegreeCurricularPlan();
            for (AcademicEnrolmentPeriod period : degreeCurricularPlan.getAcademicEnrolmentPeriodsSet()) {
                if (!period.isOpen() && !period.isUpcoming() || !period.isValidFor(registration, false)) continue;
                result.add(period);
            }
        }
        result.sort(Comparator.comparing(AcademicEnrolmentPeriod_Base::getStartDate).thenComparing(AcademicEnrolmentPeriod_Base::getEnrolmentPeriodType).thenComparing(AbstractDomainObject::getExternalId));
        return result;
    }

    public boolean isValidFor(Registration input, boolean skipRegistrationState) {
        int studentCurricularYear;
        if (!this.isValidRegistration(input, skipRegistrationState)) {
            return false;
        }
        if (!this.isValidStudentNumber(input)) {
            return false;
        }
        HashSet studentStatutes = Sets.newHashSet(StatuteServices.findStatuteTypes(input, this.getExecutionInterval()));
        if (!this.isValidStatuteTypes(studentStatutes)) {
            return false;
        }
        if (!this.isValidIngressionTypes(input.getIngressionType())) {
            return false;
        }
        if (!this.isValidEnrolmentTypes(input)) {
            return false;
        }
        CurriculumConfigurationInitializer.CurricularYearResult curricularYearResult = RegistrationServices.getCurricularYear(input, this.getExecutionYear());
        int n = studentCurricularYear = curricularYearResult == null ? 0 : curricularYearResult.getResult();
        if (!this.isValidCurricularYear(studentCurricularYear)) {
            return false;
        }
        StudentCurricularPlan studentCurricularPlan = input.getLastStudentCurricularPlan();
        if (!this.isValidFirstTimeStatus(studentCurricularPlan)) {
            return false;
        }
        return this.isValidStudentCurricularPlan(studentCurricularPlan);
    }
}

