/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.enrolment;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.FenixEduAcademicExtensionsConfiguration;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.accessControl.AcademicAuthorizationGroup;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.curricularRules.EnrolmentInSpecialSeasonEvaluation;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.enrolment.EnroledCurriculumModuleWrapper;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.bennu.core.security.Authenticate;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class StudentCurricularPlanEnrolmentInSpecialSeasonEvaluationManager
extends org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanEnrolmentInSpecialSeasonEvaluationManager {
    public StudentCurricularPlanEnrolmentInSpecialSeasonEvaluationManager(EnrolmentContext enrolmentContext) {
        super(enrolmentContext);
    }

    protected void checkDebts() {
        if (!AcademicAuthorizationGroup.get((AcademicOperationType)AcademicOperationType.STUDENT_ENROLMENTS).isMember(Authenticate.getUser()) && FenixEduAcademicExtensionsConfiguration.getConfiguration().getEnrolmentsInEvaluationsDependOnAcademicalActsBlocked().booleanValue() && TreasuryBridgeAPIFactory.implementation().isAcademicalActsBlocked(this.getPerson(), this.getExecutionYear().getEndLocalDate().isBefore((ReadablePartial)new LocalDate()) ? this.getExecutionYear().getEndLocalDate() : new LocalDate())) {
            throw new DomainException("error.StudentCurricularPlan.cannot.enrol.with.debts.for.previous.execution.years", new String[0]);
        }
    }

    protected Map<IDegreeModuleToEvaluate, Set<ICurricularRule>> getRulesToEvaluate() {
        HashMap<IDegreeModuleToEvaluate, Set<ICurricularRule>> result = new HashMap<IDegreeModuleToEvaluate, Set<ICurricularRule>>();
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : this.enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!degreeModuleToEvaluate.isEnroled() || !degreeModuleToEvaluate.canCollectRules()) continue;
            EnroledCurriculumModuleWrapper moduleEnroledWrapper = (EnroledCurriculumModuleWrapper)degreeModuleToEvaluate;
            if (moduleEnroledWrapper.getCurriculumModule() instanceof Enrolment) {
                Enrolment enrolment = (Enrolment)moduleEnroledWrapper.getCurriculumModule();
                HashSet<EnrolmentInSpecialSeasonEvaluation> curricularRules = new HashSet<EnrolmentInSpecialSeasonEvaluation>();
                if (!enrolment.hasSpecialSeason()) {
                    curricularRules.add(new EnrolmentInSpecialSeasonEvaluation(enrolment, this.getEvaluationSeason()));
                }
                result.put(degreeModuleToEvaluate, curricularRules);
                continue;
            }
            throw new DomainException("StudentCurricularPlanEnrolmentInSpecialSeasonEvaluationManager.can.only.manage.enrolment.evaluations.of.enrolments", new String[0]);
        }
        return result;
    }
}

