/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.service.AcademicPermissionService;
import org.fenixedu.academic.util.CurricularRuleLabelFormatter;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;
import org.fenixedu.bennu.core.domain.User;

public class ConditionedRouteExecutor
extends CurricularRuleExecutor {
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }

    @Deprecated
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return this.executeEnrolmentVerificationWithRules(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
    }

    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        if (!this.canApplyRule(enrolmentContext, curricularRule)) {
            return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        if (this.isPersonAuthorized(enrolmentContext)) {
            return RuleResult.createTrue((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        IDegreeModuleToEvaluate degreeModuleToEvaluate = this.searchDegreeModuleToEvaluate(enrolmentContext, curricularRule);
        if (degreeModuleToEvaluate.isEnroled()) {
            return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        return this.createFalseResult(sourceDegreeModuleToEvaluate, degreeModuleToEvaluate);
    }

    protected RuleResult executeEnrolmentPrefilter(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        if (this.isPersonAuthorized(enrolmentContext)) {
            return RuleResult.createTrue((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        if (sourceDegreeModuleToEvaluate.getDegreeModule() != curricularRule.getDegreeModuleToApplyRule()) {
            return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        return RuleResult.createImpossibleWithLiteralMessage((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule(), (String)CurricularRuleLabelFormatter.getLabel((ICurricularRule)curricularRule));
    }

    private RuleResult createFalseResult(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, IDegreeModuleToEvaluate degreeModuleToEvaluate) {
        return RuleResult.createFalseWithLiteralMessage((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule(), (String)AcademicExtensionsUtil.bundle("curricularRules.ruleExecutors.ConditionedRouteExecutor.route.choice.must.be.performed.by.academic.office", degreeModuleToEvaluate.getDegreeModule().getName()));
    }

    private boolean isPersonAuthorized(EnrolmentContext enrolmentContext) {
        return AcademicAccessRule.isProgramAccessibleToFunction((AcademicOperationType)AcademicOperationType.STUDENT_ENROLMENTS, (AcademicProgram)enrolmentContext.getStudentCurricularPlan().getDegree(), (User)enrolmentContext.getResponsiblePerson().getUser()) || AcademicPermissionService.hasAccess((String)"ACADEMIC_OFFICE_ENROLMENTS", (Degree)enrolmentContext.getStudentCurricularPlan().getDegree());
    }
}

