/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;

public class BlockEnrolmentInAdvancedCurricularCoursesExecutor
extends CurricularRuleExecutor {
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return this.executeEnrolmentVerificationWithRules(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
    }

    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate degreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        if (!this.canApplyRule(enrolmentContext, curricularRule) || !degreeModuleToEvaluate.isLeaf()) {
            return RuleResult.createNA((DegreeModule)degreeModuleToEvaluate.getDegreeModule());
        }
        int curricularYear = RegistrationServices.getCurricularYear(enrolmentContext.getRegistration(), enrolmentContext.getExecutionYear()).getResult();
        if (degreeModuleToEvaluate.getContext() != null && degreeModuleToEvaluate.getContext().getCurricularYear() <= curricularYear) {
            return RuleResult.createTrue((DegreeModule)degreeModuleToEvaluate.getDegreeModule());
        }
        String message = AcademicExtensionsUtil.bundle("curricularRules.ruleExecutors.BlockEnrolmentInAdvancedCurricularCoursesExecutor.error.cannot.enrol.in.advanced.curricular.courses", degreeModuleToEvaluate.getName());
        return degreeModuleToEvaluate.isEnroled() ? RuleResult.createImpossibleWithLiteralMessage((DegreeModule)degreeModuleToEvaluate.getDegreeModule(), (String)message) : RuleResult.createFalseWithLiteralMessage((DegreeModule)degreeModuleToEvaluate.getDegreeModule(), (String)message);
    }

    protected RuleResult executeEnrolmentPrefilter(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        if (!this.canApplyRule(enrolmentContext, curricularRule) || !sourceDegreeModuleToEvaluate.isLeaf()) {
            return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        int curricularYear = RegistrationServices.getCurricularYear(enrolmentContext.getRegistration(), enrolmentContext.getExecutionYear()).getResult();
        return sourceDegreeModuleToEvaluate.getContext() != null && sourceDegreeModuleToEvaluate.getContext().getCurricularYear() <= curricularYear ? RuleResult.createTrue((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule()) : RuleResult.createFalse((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }
}

