/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.concurrent.Callable;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.FenixEduAcademicExtensionsConfiguration;
import org.fenixedu.academic.FenixeduAcademicExtensionsInitializer$callable$contextInitialized;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.DegreeInfo;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EvaluationConfiguration;
import org.fenixedu.academic.domain.Qualification;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.AnyCurricularCourseExceptionsInitializer;
import org.fenixedu.academic.domain.curricularRules.EnrolmentPeriodRestrictionsInitializer;
import org.fenixedu.academic.domain.curricularRules.StudentScheduleListeners;
import org.fenixedu.academic.domain.curricularRules.UnavailableForEnrolmentRule;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleConfigurationInitializer;
import org.fenixedu.academic.domain.degree.ExtendedDegreeInfo;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformation;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.OptionalCurricularCourse;
import org.fenixedu.academic.domain.enrolment.EnrolmentManagerFactoryInitializer;
import org.fenixedu.academic.domain.enrolment.EnrolmentPredicateInitializer;
import org.fenixedu.academic.domain.evaluation.EnrolmentEvaluationExtendedInformation;
import org.fenixedu.academic.domain.evaluation.EvaluationComparator;
import org.fenixedu.academic.domain.evaluation.config.MarkSheetSettings;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonServices;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionYearExtendedInformation;
import org.fenixedu.academic.domain.student.RegistrationExtendedInformation;
import org.fenixedu.academic.domain.student.RegistrationObservations;
import org.fenixedu.academic.domain.student.RegistrationRegimeVerifierInitializer;
import org.fenixedu.academic.domain.student.curriculum.CurriculumConfigurationInitializer;
import org.fenixedu.academic.domain.student.curriculum.CurriculumLineExtendedInformation;
import org.fenixedu.academic.domain.student.curriculum.EctsAndWeightProviders;
import org.fenixedu.academic.domain.student.curriculum.conclusion.ConclusionProcessListenersInitializer;
import org.fenixedu.academic.domain.studentCurriculum.Credits;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;
import pt.ist.fenixframework.dml.DeletionListener;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

@WebListener
public class FenixeduAcademicExtensionsInitializer
implements ServletContextListener {
    private static final Logger logger;
    public static final Advice advice$contextInitialized;

    public void contextDestroyed(ServletContextEvent event) {
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        Object object = advice$contextInitialized.perform((Callable)new FenixeduAcademicExtensionsInitializer$callable$contextInitialized(this, servletContextEvent));
    }

    static /* synthetic */ void advised$contextInitialized(FenixeduAcademicExtensionsInitializer this_, ServletContextEvent event) {
        CurricularRuleConfigurationInitializer.init();
        AnyCurricularCourseExceptionsInitializer.init();
        ConclusionProcessListenersInitializer.init();
        CurriculumConfigurationInitializer.init();
        EnrolmentPredicateInitializer.init();
        RegistrationRegimeVerifierInitializer.init();
        RegistrationExtendedInformation.setupDeleteListener();
        RegistrationDataByExecutionYearExtendedInformation.setupDeleteListener();
        EctsAndWeightProviders.init();
        EnrolmentManagerFactoryInitializer.init();
        this_.setupListenersForStudentSchedule();
        CurriculumLineExtendedInformation.setupDeleteListener();
        RegistrationObservations.setupDeleteListener();
        ExtendedDegreeInfo.setupDeleteListener();
        ExtendedDegreeInfo.setupCreationListener();
        EnrolmentEvaluationExtendedInformation.setupDeleteListener();
        MarkSheetSettings.init();
        EnrolmentPeriodRestrictionsInitializer.init();
        EvaluationSeasonServices.initialize();
        EvaluationSeasonServices.setEnrolmentsInEvaluationsDependOnAcademicalActsBlocked(FenixEduAcademicExtensionsConfiguration.getConfiguration().getEnrolmentsInEvaluationsDependOnAcademicalActsBlocked());
        EvaluationConfiguration.setEnrolmentEvaluationOrder((Comparator)new EvaluationComparator());
        this_.setupListenerForCurricularPeriodDelete();
        this_.setupListenerForEnrolmentDelete();
        this_.setupListenerForSchoolClassDelete();
        this_.setupListenerForInvalidEquivalences();
        this_.registerDeletionListenerOnCurriculumLineForCourseGradingTable();
        this_.registerDeletionListenerOnDegreeModuleForCurriculumLineLogs();
        this_.registerDeletionListenerOnQualification();
        this_.registerDeletionListenerOnUnit();
        this_.registerDeletionListenersForDynamicFields();
        UnavailableForEnrolmentRule.initializeDomainListenersAndExtensions();
    }

    private void setupListenersForStudentSchedule() {
        Signal.register((String)"fenixedu.academic.enrolment.created", StudentScheduleListeners.SHIFTS_ENROLLER);
    }

    private void setupListenerForCurricularPeriodDelete() {
        FenixFramework.getDomainModel().registerDeletionListener(CurricularPeriod.class, curricularPeriod -> {
            if (curricularPeriod.getConfiguration() != null) {
                curricularPeriod.getConfiguration().delete();
            }
        });
    }

    private void setupListenerForEnrolmentDelete() {
        Attends.getRelationAttendsEnrolment().addListener((RelationListener)new RelationAdapter<Enrolment, Attends>(){

            public void beforeRemove(Enrolment enrolment, Attends attends) {
                Registration registration = attends.getRegistration();
                if (registration != null) {
                    registration.getShiftsFor(attends.getExecutionCourse()).forEach(s -> s.unenrol(registration));
                }
            }
        });
    }

    private void setupListenerForSchoolClassDelete() {
        FenixFramework.getDomainModel().registerDeletionListener(SchoolClass.class, (DeletionListener)new DeletionListener<SchoolClass>(){

            public void deleting(SchoolClass schoolClass) {
                schoolClass.getRegistrationsSet().clear();
                schoolClass.setNextSchoolClass(null);
                schoolClass.getPreviousSchoolClassesSet().clear();
            }
        });
    }

    private void setupListenerForInvalidEquivalences() {
        Dismissal.getRelationCreditsDismissalEquivalence().addListener((RelationListener)new RelationAdapter<Dismissal, Credits>(){

            public void beforeAdd(Dismissal dismissal, Credits credits) {
                if (credits != null && dismissal != null && (dismissal.isCreditsDismissal() || dismissal.isOptional()) && credits.isEquivalence() && FenixEduAcademicExtensionsConfiguration.getConfiguration().getRestrictEquivalencesToCurricularCourses().booleanValue()) {
                    throw new DomainException("error.Equivalence.can.only.be.applied.to.curricular.courses", new String[0]);
                }
            }
        });
    }

    private void registerDeletionListenerOnCurriculumLineForCourseGradingTable() {
        FenixFramework.getDomainModel().registerDeletionListener(CurriculumLine.class, (DeletionListener)new DeletionListener<CurriculumLine>(){

            public void deleting(CurriculumLine line) {
                if (line.getCourseGradingTable() != null) {
                    line.getCourseGradingTable().delete();
                }
            }
        });
    }

    private void registerDeletionListenerOnDegreeModuleForCurriculumLineLogs() {
        FenixFramework.getDomainModel().registerDeletionListener(DegreeModule.class, dm -> {
            dm.getCurriculumLineLogsSet().forEach(log -> log.delete());
            if (dm instanceof OptionalCurricularCourse) {
                OptionalCurricularCourse optionalCurricularCourse = (OptionalCurricularCourse)dm;
                optionalCurricularCourse.getOptionalEnrolmentLogsSet().forEach(log -> log.delete());
            }
        });
    }

    private void registerDeletionListenerOnQualification() {
        FenixFramework.getDomainModel().registerDeletionListener(Qualification.class, q -> {
            q.getAcademicAreasSet().clear();
            q.getQualificationTypesSet().clear();
            q.setDegreeUnit(null);
            q.setInstitutionUnit(null);
            q.setLevel(null);
        });
    }

    private void registerDeletionListenerOnUnit() {
        FenixFramework.getDomainModel().registerDeletionListener(Unit.class, u -> u.getAcademicAreasSet().clear());
    }

    private void registerDeletionListenersForDynamicFields() {
        FenixFramework.getDomainModel().registerDeletionListener(CompetenceCourseInformation.class, cci -> cci.getDynamicFieldSet().forEach(df -> {
            df.setCompetenceCourseInformation(null);
            df.delete();
        }));
        FenixFramework.getDomainModel().registerDeletionListener(DegreeInfo.class, di -> di.getDynamicFieldSet().forEach(df -> {
            df.setDegreeInfo(null);
            df.delete();
        }));
        FenixFramework.getDomainModel().registerDeletionListener(Party.class, p -> p.getDynamicFieldSet().forEach(df -> {
            df.setParty(null);
            df.delete();
        }));
    }

    public static <T> T loadClass(String key, String value) {
        Object result;
        block5: {
            result = null;
            try {
                if (StringUtils.isNotBlank((String)value)) {
                    result = Class.forName(value).newInstance();
                    break block5;
                }
                String message = "Property [" + key + "] must be defined in configuration file";
                if (CoreConfiguration.getConfiguration().developmentMode().booleanValue()) {
                    logger.error("{}. Empty value may lead to wrong system behaviour", (Object)message);
                    break block5;
                }
                throw new RuntimeException(message);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("An error occured loading class: " + value, e);
            }
        }
        if (result != null) {
            logger.debug("Using " + result.getClass().getSimpleName());
        }
        return (T)result;
    }

    static {
        advice$contextInitialized = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(FenixeduAcademicExtensionsInitializer.class);
    }
}

