/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum.creditstransfer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitUtils;
import org.fenixedu.academic.domain.student.curriculum.CreditsReasonType;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.student.curriculum.creditstransfer.CreditsTransferRemarkEntry;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;
import org.fenixedu.commons.i18n.LocalizedString;

class EquivalenceRemarkEntry
extends CreditsTransferRemarkEntry {
    private ListMultimap<Unit, IEnrolment> sourcesByUnit = ArrayListMultimap.create();

    public EquivalenceRemarkEntry(CreditsReasonType reasonType, Class<?> creditsType, Dismissal dismissal) {
        super(reasonType, creditsType, (ICurriculumEntry)dismissal);
        this.getDismissal().getCredits().getIEnrolments().stream().sorted(ICurriculumEntry.COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME_AND_ID).forEach(i -> this.sourcesByUnit.put((Object)i.getAcademicUnit(), i));
    }

    private Dismissal getDismissal() {
        return (Dismissal)this.getEntry();
    }

    public Multimap<Unit, IEnrolment> getSourcesByUnit() {
        return this.sourcesByUnit;
    }

    public static EquivalenceRemarkEntry build(Dismissal dismissal) {
        return new EquivalenceRemarkEntry(dismissal.getCredits().getReason(), dismissal.getCredits().getClass(), dismissal);
    }

    @Override
    public boolean matches(CreditsTransferRemarkEntry entry) {
        return this.toLocalizedString().compareTo(entry.toLocalizedString()) == 0;
    }

    @Override
    public void merge(CreditsTransferRemarkEntry entry) {
        this.getMergedEntries().add(entry);
    }

    @Override
    protected String toString(Locale locale) {
        String remarkIdPrefix = this.getFormattedRemarkId() + (StringUtils.isNotBlank((CharSequence)this.getFormattedRemarkId()) ? " " : "");
        if (this.getReasonType() == null) {
            return remarkIdPrefix + AcademicExtensionsUtil.bundleI18N("label.creditsTransfer", new String[0]).getContent(locale);
        }
        if (this.getReasonType().getInfoHidden()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(remarkIdPrefix);
        result.append(this.getReasonType().getInfoText().getContent(locale));
        if (this.getReasonType().getInfoExplained()) {
            String prefix = AcademicExtensionsUtil.bundleI18N("info.CreditsReasonType.explained.Equivalence", new String[0]).getContent(locale);
            result.append(" - ").append(prefix).append(": ");
            Map sourcesByUnitMap = this.sourcesByUnit.asMap();
            String institutionSources = sourcesByUnitMap.keySet().stream().sorted((x, y) -> {
                if (x == UnitUtils.readInstitutionUnit()) {
                    return -1;
                }
                String leftInstitutionName = Optional.ofNullable(x.getNameI18n().getContent(locale)).orElse(x.getNameI18n().getContent(Locale.getDefault()));
                String rightInstitutionName = Optional.ofNullable(y.getNameI18n().getContent(locale)).orElse(y.getNameI18n().getContent(Locale.getDefault()));
                return x == UnitUtils.readInstitutionUnit() ? -1 : leftInstitutionName.compareTo(rightInstitutionName);
            }).map(k -> {
                StringBuilder sourcesBlock = new StringBuilder();
                if (k != UnitUtils.readInstitutionUnit()) {
                    sourcesBlock.append(this.getFormattedUnit((Unit)k, locale, this.getReasonType().getInfoExplainedWithCountry(), this.getReasonType().getInfoExplainedWithInstitution())).append(": ");
                }
                sourcesBlock.append(((Collection)sourcesByUnitMap.get(k)).stream().map(d -> {
                    String formattedEcts = this.getFormattedEcts((ICurriculumEntry)d, locale);
                    return this.getFormattedName((IEnrolment)d).getContent(locale) + (String)(StringUtils.isNotBlank((CharSequence)formattedEcts) ? " " + formattedEcts : "");
                }).collect(Collectors.joining(", ")));
                return sourcesBlock.toString();
            }).collect(Collectors.joining("; "));
            result.append(institutionSources);
        }
        return result.toString();
    }

    private LocalizedString getFormattedName(IEnrolment entry) {
        return entry instanceof Enrolment ? ((Enrolment)entry).getCurricularCourse().getNameI18N(entry.getExecutionInterval()) : entry.getName();
    }
}

