/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.person.qualifications;

import java.util.Collection;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.person.qualifications.QualificationLevelTypeFamily_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixframework.core.AbstractDomainObject;

public class QualificationLevelTypeFamily
extends QualificationLevelTypeFamily_Base
implements Comparable<QualificationLevelTypeFamily> {
    public QualificationLevelTypeFamily() {
        this.setRoot(Bennu.getInstance());
    }

    public void setName(LocalizedString name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("error.QualificationLevelTypeFamily.name.cannotBeEmpty");
        }
        super.setName(name);
    }

    public void setCode(String code) {
        if (StringUtils.isNotBlank((String)code) && Bennu.getInstance().getQualificationLevelTypeFamiliesSet().stream().anyMatch(f -> code.equals(f.getCode()) && f != this)) {
            throw new IllegalArgumentException("error.QualificationLevelTypeFamily.code.alreadyExists");
        }
        super.setCode(code);
    }

    public static QualificationLevelTypeFamily findByCode(String code) {
        return StringUtils.isNotBlank((String)code) ? (QualificationLevelTypeFamily)Bennu.getInstance().getQualificationLevelTypeFamiliesSet().stream().filter(f -> code.equals(f.getCode())).findFirst().orElse(null) : null;
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getTypesSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.QualificationLevelTypeFamily.delete.typesNotEmpty", (String[])new String[0]));
        }
    }

    @Override
    public int compareTo(QualificationLevelTypeFamily otherFamily) {
        Comparator nullSafeStringComparator = Comparator.nullsLast(String::compareToIgnoreCase);
        Comparator<QualificationLevelTypeFamily> familyComparator = Comparator.comparing(QualificationLevelTypeFamily_Base::getCode, nullSafeStringComparator).thenComparing(QualificationLevelTypeFamily_Base::getName).thenComparing(AbstractDomainObject::getExternalId);
        return familyComparator.compare(this, otherFamily);
    }

    public void delete() {
        super.setRoot(null);
        this.getTypesSet().forEach(t -> t.delete());
        super.deleteDomainObject();
    }
}

