/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.OptionalEnrolment;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodRule;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.RuleEnrolment;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnroledEnrolmentWrapper;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.student.curriculum.CurriculumLineServices;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.dto.CurricularPeriodInfoDTO;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurricularPeriodServices {
    private static final Logger logger = LoggerFactory.getLogger(CurricularPeriodServices.class);
    private static final Cache<String, Integer> CACHE_DEGREE_MODULE_CURRICULAR_YEAR = CacheBuilder.newBuilder().concurrencyLevel(8).maximumSize(3000L).expireAfterWrite(1L, TimeUnit.DAYS).build();

    @Deprecated
    public static CurricularPeriod getCurricularPeriod(DegreeCurricularPlan dcp, int year, Integer semester) {
        CurricularPeriod result;
        if (semester == null) {
            result = CurricularPeriodServices.getCurricularPeriod(dcp, year);
        } else {
            result = dcp.getCurricularPeriodFor(year, semester.intValue());
            if (result == null) {
                logger.debug("Unsupported Curricular Period [Y{},S{}], DCP [{}] ", new Object[]{year, semester, dcp.getPresentationName()});
            }
        }
        return result;
    }

    public static CurricularPeriod getCurricularPeriod(DegreeCurricularPlan dcp, int year) {
        CurricularPeriod result = null;
        CurricularPeriodInfoDTO dto = new CurricularPeriodInfoDTO(Integer.valueOf(year), AcademicPeriod.YEAR);
        CurricularPeriod degreeStructure = dcp.getDegreeStructure();
        if (degreeStructure != null) {
            result = degreeStructure.getAbsoluteOrderOfChild() == year && degreeStructure.getAcademicPeriod().equals((Object)AcademicPeriod.YEAR) ? degreeStructure : degreeStructure.getCurricularPeriod(new CurricularPeriodInfoDTO[]{dto});
        }
        if (result == null) {
            logger.debug("Unsupported Curricular Period [{},{}], DCP [{}]", new Object[]{dto.getPeriodType().getName(), dto.getOrder(), dcp.getPresentationName()});
        }
        return result;
    }

    public static CurricularPeriodConfiguration getCurricularPeriodConfiguration(DegreeCurricularPlan dcp, int year) {
        CurricularPeriod curricularPeriod = CurricularPeriodServices.getCurricularPeriod(dcp, year);
        return curricularPeriod == null ? null : curricularPeriod.getConfiguration();
    }

    private static int getCurricularYear(IDegreeModuleToEvaluate input) {
        return input instanceof EnroledEnrolmentWrapper ? CurricularPeriodServices.getCurricularYear((CurriculumLine)((EnroledEnrolmentWrapper)input).getCurriculumModule()) : input.getContext().getCurricularYear();
    }

    public static int getCurricularYear(CurriculumLine input) {
        Set contexts;
        ExecutionYear executionYear;
        String report = input.print("").toString();
        if (input.getCurriculumGroup().isNoCourseGroupCurriculumGroup()) {
            logger.debug("NoCourseGroupCurriculumGroup as parent for [{}], returning 1", (Object)report);
            return 1;
        }
        Object degreeModule = input instanceof OptionalEnrolment ? ((OptionalEnrolment)input).getOptionalCurricularCourse() : input.getDegreeModule();
        Integer calculated = CurricularPeriodServices.getCurricularYearCalculated(report, degreeModule, executionYear = input.getExecutionYear(), contexts = input.getCurriculumGroup().getDegreeModule().getChildContextsSet());
        if (calculated != null) {
            return calculated;
        }
        Integer overridenCurricularYear = CurriculumLineServices.getCurricularYear(input);
        if (overridenCurricularYear == null) {
            logger.debug("Unable to guess curricular year for [{}], returning 1", (Object)report.toString().replace("\n", ""));
            return 1;
        }
        return overridenCurricularYear;
    }

    private static Integer getCurricularYearCalculated(final String report, final DegreeModule degreeModule, final ExecutionYear executionYear, final Set<Context> contexts) {
        final String key = String.format("%s#%s#%s", degreeModule == null ? "null" : degreeModule.getExternalId(), executionYear == null ? "null" : executionYear.getExternalId(), contexts.stream().map(i -> i.getExternalId()).collect(Collectors.joining(";")));
        try {
            return (Integer)CACHE_DEGREE_MODULE_CURRICULAR_YEAR.get((Object)key, (Callable)new Callable<Integer>(){

                @Override
                public Integer call() {
                    logger.debug(String.format("Miss on DegreeModule CurricularYear cache [%s %s]", new DateTime(), key));
                    return CurricularPeriodServices.loadCurricularYearCalculated(report, degreeModule, executionYear, contexts).orElse(null);
                }
            });
        }
        catch (Throwable t) {
            logger.debug(String.format("Unable to get DegreeModule CurricularYear [%s %s %s]", new DateTime(), key, t.getLocalizedMessage()));
            return null;
        }
    }

    private static Optional<Integer> loadCurricularYearCalculated(String report, DegreeModule degreeModule, ExecutionYear executionYear, Set<Context> contexts) {
        ArrayList curricularYearsValids = Lists.newArrayList();
        ArrayList curricularYears = Lists.newArrayList();
        for (Context context : contexts) {
            if (!context.getChildDegreeModule().isLeaf()) continue;
            Integer curricularYear = context.getCurricularYear();
            if (degreeModule != null && context.getChildDegreeModule() != degreeModule) continue;
            curricularYears.add(curricularYear);
            if (!context.isValidForExecutionAggregation(executionYear)) continue;
            curricularYearsValids.add(curricularYear);
        }
        if (!curricularYearsValids.isEmpty()) {
            return Optional.of((Integer)Collections.min(curricularYearsValids));
        }
        if (!curricularYears.isEmpty()) {
            return Optional.of((Integer)Collections.min(curricularYears));
        }
        return Optional.empty();
    }

    public static Map<CurricularPeriod, BigDecimal> mapYearCredits(ICurriculum curriculum) {
        return CurricularPeriodServices.mapYearCredits(curriculum, null);
    }

    public static Map<CurricularPeriod, BigDecimal> mapYearCredits(ICurriculum curriculum, Boolean applyToOptionals) {
        HashMap result = Maps.newHashMap();
        DegreeCurricularPlan dcp = curriculum.getStudentCurricularPlan().getDegreeCurricularPlan();
        for (ICurriculumEntry iter : curriculum.getCurricularYearEntries()) {
            int year;
            CurricularPeriod curricularPeriod;
            CurriculumLine curriculumLine = (CurriculumLine)iter;
            if (applyToOptionals != null) {
                boolean isOptionalByGroup = CurriculumLineServices.isOptionalByGroup(curriculumLine);
                if (applyToOptionals.booleanValue() && !isOptionalByGroup || !applyToOptionals.booleanValue() && isOptionalByGroup) continue;
            }
            if ((curricularPeriod = CurricularPeriodServices.getCurricularPeriod(dcp, year = CurricularPeriodServices.getCurricularYear(curriculumLine))) == null) continue;
            BigDecimal credits = iter.getEctsCreditsForCurriculum();
            CurricularPeriodServices.addYearCredits(result, curricularPeriod, credits, iter.getCode());
        }
        CurricularPeriodServices.mapYearCreditsLogger(result);
        return result;
    }

    public static Map<CurricularPeriod, BigDecimal> mapYearCredits(EnrolmentContext enrolmentContext, Boolean applyToOptionals, ExecutionInterval interval) {
        HashMap result = Maps.newHashMap();
        DegreeCurricularPlan dcp = enrolmentContext.getStudentCurricularPlan().getDegreeCurricularPlan();
        for (IDegreeModuleToEvaluate iter : RuleEnrolment.getEnroledAndEnroling(enrolmentContext)) {
            int year;
            CurricularPeriod curricularPeriod;
            DegreeModule degreeModule = iter.getDegreeModule();
            if (applyToOptionals != null) {
                boolean isOptionalByGroup = iter.getCurriculumGroup().getDegreeModule().getIsOptional();
                if (applyToOptionals.booleanValue() && !isOptionalByGroup || !applyToOptionals.booleanValue() && isOptionalByGroup) continue;
            }
            if ((curricularPeriod = CurricularPeriodServices.getCurricularPeriod(dcp, year = CurricularPeriodServices.getCurricularYear(iter), interval == null ? null : interval.getChildOrder())) == null) continue;
            BigDecimal credits = BigDecimal.valueOf(interval != null ? iter.getAccumulatedEctsCredits(interval) : iter.getEctsCredits().doubleValue());
            String code = degreeModule == null ? "Opt" : degreeModule.getCode();
            CurricularPeriodServices.addYearCredits(result, curricularPeriod, credits, code);
        }
        CurricularPeriodServices.mapYearCreditsLogger(result);
        return result;
    }

    public static void mapYearCreditsLogger(Map<CurricularPeriod, BigDecimal> input) {
        for (Map.Entry<CurricularPeriod, BigDecimal> entry : input.entrySet()) {
            CurricularPeriodRule.logger.debug("{}#{} ECTS", (Object)entry.getKey().getFullLabel(), (Object)entry.getValue().toPlainString());
        }
    }

    public static void addYearCredits(Map<CurricularPeriod, BigDecimal> result, CurricularPeriod curricularPeriod, BigDecimal credits, String code) {
        BigDecimal creditsYear = result.get(curricularPeriod);
        result.put(curricularPeriod, creditsYear != null ? creditsYear.add(credits) : credits);
        CurricularPeriodRule.logger.debug("{}#UC {}#{} ECTS", new Object[]{code, curricularPeriod.getFullLabel(), credits.toPlainString()});
    }

    @Deprecated
    public static int getCurricularSemester(CurriculumLine curriculumLine) {
        return CurricularPeriodServices.getCurricularPeriodChildOrder(curriculumLine);
    }

    public static CurricularPeriod getCurricularPeriod(CurriculumLine line) {
        DegreeCurricularPlan degreeCurricularPlan = CurricularPeriodServices.getDegreeCurricularPlanForCurricularPeriod(line);
        return degreeCurricularPlan.getCurricularPeriodFor(CurricularPeriodServices.getCurricularYear(line), CurricularPeriodServices.getCurricularPeriodChildOrder(line), line.getExecutionInterval().getAcademicPeriod());
    }

    private static DegreeCurricularPlan getDegreeCurricularPlanForCurricularPeriod(CurriculumLine line) {
        if (line.getCurriculumGroup().isNoCourseGroupCurriculumGroup() || line.getDegreeModule() == null) {
            return line.getDegreeCurricularPlanOfStudent();
        }
        DegreeModule degreeModule = line instanceof OptionalEnrolment ? ((OptionalEnrolment)line).getOptionalCurricularCourse() : line.getDegreeModule();
        return degreeModule.getParentDegreeCurricularPlan();
    }

    private static int getCurricularPeriodChildOrder(CurriculumLine line) {
        if (line.isEnrolment()) {
            return line.getExecutionInterval().getChildOrder();
        }
        Collection<Context> contexts = CurriculumLineServices.getParentContexts(line);
        return contexts.size() == 1 ? contexts.iterator().next().getCurricularPeriod().getChildOrder() : line.getExecutionInterval().getChildOrder();
    }
}

