/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition.MinimumPartialAverage$callable$create;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition.MinimumPartialAverage_Base;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MinimumPartialAverage
extends MinimumPartialAverage_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected MinimumPartialAverage() {
    }

    public RuleResult execute(Curriculum curriculum) {
        StudentCurricularPlan studentCurricularPlan = curriculum.getStudentCurricularPlan();
        Set programConclusions = ProgramConclusion.conclusionsFor((DegreeCurricularPlan)studentCurricularPlan.getDegreeCurricularPlan()).filter(x -> !x.isTerminal()).collect(Collectors.toSet());
        boolean result = true;
        for (ProgramConclusion programConclusion : programConclusions) {
            RegistrationConclusionBean bean = new RegistrationConclusionBean(studentCurricularPlan, programConclusion);
            if (!bean.getFinalGrade().isNumeric()) continue;
            result &= bean.getFinalGrade().getNumericValue().compareTo(this.getValue()) >= 0;
        }
        return result ? this.createTrue() : this.createFalseLabelled(this.getValue());
    }

    public String getLabel() {
        return BundleUtil.getString((String)MODULE_BUNDLE, (String)("label." + ((Object)((Object)this)).getClass().getSimpleName()), (String[])new String[]{this.getValue().toString()});
    }

    public static MinimumPartialAverage create(CurricularPeriodConfiguration curricularPeriodConfiguration, BigDecimal bigDecimal) {
        return (MinimumPartialAverage)((Object)advice$create.perform((Callable)new MinimumPartialAverage$callable$create(curricularPeriodConfiguration, bigDecimal)));
    }

    static /* synthetic */ MinimumPartialAverage advised$create(CurricularPeriodConfiguration configuration, BigDecimal average) {
        MinimumPartialAverage result = new MinimumPartialAverage();
        result.init(configuration, average, null, null);
        return result;
    }
}

