/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.curricularPeriod;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration$callable$create;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration$callable$delete;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration_Base;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodRule;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.RuleEnrolment;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.RuleTransition;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.RootCourseGroup;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.bennu.core.domain.Bennu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CurricularPeriodConfiguration
extends CurricularPeriodConfiguration_Base {
    private static final Logger logger;
    public static final Advice advice$delete;
    public static final Advice advice$create;

    protected CurricularPeriodConfiguration() {
        super.setBennu(Bennu.getInstance());
    }

    protected void init(CurricularPeriod curricularPeriod) {
        this.setCurricularPeriod(curricularPeriod);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getCurricularPeriod() == null) {
            throw new DomainException("error." + ((Object)((Object)this)).getClass().getSimpleName() + ".curricularPeriod.required", new String[0]);
        }
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new CurricularPeriodConfiguration$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(CurricularPeriodConfiguration this_) {
        DomainException.throwWhenDeleteBlocked((Collection)this_.getDeletionBlockers());
        super.setBennu(null);
        super.setCurricularPeriod(null);
        while (!this_.getRuleEnrolmentSet().isEmpty()) {
            ((RuleEnrolment)((Object)this_.getRuleEnrolmentSet().iterator().next())).delete();
        }
        while (!this_.getRuleTransitionSet().isEmpty()) {
            ((RuleTransition)((Object)this_.getRuleTransitionSet().iterator().next())).delete();
        }
        this_.deleteDomainObject();
    }

    public static CurricularPeriodConfiguration create(CurricularPeriod curricularPeriod) {
        return (CurricularPeriodConfiguration)((Object)advice$create.perform((Callable)new CurricularPeriodConfiguration$callable$create(curricularPeriod)));
    }

    static /* synthetic */ CurricularPeriodConfiguration advised$create(CurricularPeriod curricularPeriod) {
        CurricularPeriodConfiguration result = new CurricularPeriodConfiguration();
        result.init(curricularPeriod);
        return result;
    }

    public RuleResult verifyRulesForEnrolment(EnrolmentContext enrolmentContext) {
        Registration registration = enrolmentContext.getRegistration();
        RootCourseGroup degreeModule = this.getDegreeCurricularPlan().getRoot();
        if (this.getRuleEnrolmentSet().isEmpty()) {
            RuleResult falseResult = CurricularPeriodRule.createFalseConfiguration((DegreeModule)degreeModule, this);
            logger.debug("[REG][{}][{}]", (Object)registration.getNumber(), (Object)CurricularPeriodRule.getMessages(falseResult));
            return falseResult;
        }
        for (RuleEnrolment rule : this.getFilteredRuleEnrolment(true)) {
            RuleResult ruleResult = rule.execute(enrolmentContext);
            if (ruleResult.isTrue()) {
                return ruleResult;
            }
            logger.debug("[RULE executive !true][{}] [REG][{}][{}]", new Object[]{rule.getExternalId(), registration.getNumber(), CurricularPeriodRule.getMessages(rule.createFalseLabelled())});
        }
        RuleResult result = RuleResult.createTrue((DegreeModule)degreeModule);
        for (RuleEnrolment rule : this.getFilteredRuleEnrolment(false)) {
            RuleResult ruleResult = rule.execute(enrolmentContext);
            if (ruleResult.isTrue()) continue;
            result = result.and(ruleResult);
            logger.debug("[RULE !true][{}] [REG][{}][{}]", new Object[]{rule.getExternalId(), registration.getNumber(), CurricularPeriodRule.getMessages(rule.createFalseLabelled())});
        }
        return result;
    }

    public RuleResult verifyRulesForTransition(Curriculum curriculum) {
        Registration registration = curriculum.getStudentCurricularPlan().getRegistration();
        RootCourseGroup degreeModule = this.getDegreeCurricularPlan().getRoot();
        if (this.getRuleTransitionSet().isEmpty()) {
            RuleResult falseResult = CurricularPeriodRule.createFalseConfiguration((DegreeModule)degreeModule, this);
            logger.debug("[REG][{}][{}]", (Object)registration.getNumber(), (Object)CurricularPeriodRule.getMessages(falseResult));
            return falseResult;
        }
        for (RuleTransition rule : this.getFilteredRuleTransition(true)) {
            RuleResult ruleResult = rule.execute(curriculum);
            if (ruleResult.isTrue()) {
                return ruleResult;
            }
            logger.debug("[RULE executive !true][{}] [REG][{}][{}]", new Object[]{rule.getExternalId(), registration.getNumber(), CurricularPeriodRule.getMessages(rule.createFalseLabelled())});
        }
        Collection<RuleTransition> otherRules = this.getFilteredRuleTransition(false);
        if (otherRules.isEmpty()) {
            RuleResult falseResult = CurricularPeriodRule.createFalseConfiguration((DegreeModule)degreeModule, this);
            logger.debug("[REG][{}][{}]", (Object)registration.getNumber(), (Object)CurricularPeriodRule.getMessages(falseResult));
            return falseResult;
        }
        RuleResult result = RuleResult.createTrue((DegreeModule)degreeModule);
        for (RuleTransition rule : otherRules) {
            RuleResult ruleResult = rule.execute(curriculum);
            if (ruleResult.isTrue()) continue;
            result = result.and(ruleResult);
            logger.debug("[RULE !true][{}] [REG][{}][{}]", new Object[]{rule.getExternalId(), registration.getNumber(), CurricularPeriodRule.getMessages(rule.createFalseLabelled())});
        }
        return result;
    }

    private Collection<RuleTransition> getFilteredRuleTransition(boolean executive) {
        return this.getRuleTransitionSet().stream().filter(r -> r.isExecutive() == executive).collect(Collectors.toSet());
    }

    private Collection<RuleEnrolment> getFilteredRuleEnrolment(boolean executive) {
        return this.getRuleEnrolmentSet().stream().filter(r -> r.isExecutive() == executive).collect(Collectors.toSet());
    }

    public DegreeCurricularPlan getDegreeCurricularPlan() {
        CurricularPeriod curricularPeriod = this.getCurricularPeriod();
        while (curricularPeriod.getParent() != null) {
            curricularPeriod = curricularPeriod.getParent();
        }
        return curricularPeriod.getDegreeCurricularPlan();
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(CurricularPeriodConfiguration.class);
    }
}

