/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import org.fenixedu.academic.domain.ShiftType;

public class ShiftTypes {
    private final ImmutableSet<ShiftType> types;

    public ShiftTypes(JsonElement json) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JsonElement el : json.getAsJsonArray()) {
            builder.add((Object)ShiftType.valueOf((String)el.getAsString()));
        }
        this.types = builder.build();
    }

    public ShiftTypes(Collection<ShiftType> types) {
        this.types = ImmutableSet.copyOf(types);
    }

    public ShiftTypes() {
        this.types = ImmutableSet.of();
    }

    public Collection<ShiftType> getTypes() {
        return this.types;
    }

    public JsonElement toJson() {
        JsonArray array = new JsonArray();
        this.types.stream().map(Enum::name).map(JsonPrimitive::new).forEach(type -> array.add((JsonElement)type));
        return array;
    }
}

