/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.services;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.StatuteType;

public class StatuteServices {
    public static Collection<StatuteType> findStatuteTypes(Registration registration, ExecutionInterval executionInterval) {
        if (executionInterval instanceof ExecutionYear) {
            return StatuteServices.findStatuteTypesByYear(registration, (ExecutionYear)executionInterval);
        }
        return StatuteServices.findStatuteTypesByChildInterval(registration, executionInterval);
    }

    private static Collection<StatuteType> findStatuteTypesByYear(Registration registration, ExecutionYear executionYear) {
        HashSet result = Sets.newHashSet();
        for (ExecutionInterval executionInterval : executionYear.getExecutionPeriodsSet()) {
            result.addAll(StatuteServices.findStatuteTypesByChildInterval(registration, executionInterval));
        }
        return result;
    }

    private static Collection<StatuteType> findStatuteTypesByChildInterval(Registration registration, ExecutionInterval executionInterval) {
        return registration.getStudent().getStudentStatutesSet().stream().filter(s -> s.isValidInExecutionInterval(executionInterval) && (s.getRegistration() == null || s.getRegistration() == registration)).map(s -> s.getType()).collect(Collectors.toSet());
    }

    public static String getVisibleStatuteTypesDescription(Registration registration, ExecutionInterval executionInterval) {
        return StatuteServices.findVisibleStatuteTypes(registration, executionInterval).stream().map(s -> s.getName().getContent()).distinct().collect(Collectors.joining(", "));
    }

    public static Collection<StatuteType> findVisibleStatuteTypes(Registration registration, ExecutionInterval executionInterval) {
        return StatuteServices.findStatuteTypes(registration, executionInterval).stream().filter(s -> s.getVisible()).collect(Collectors.toSet());
    }
}

