/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.student.curriculum.CurriculumLineServices;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.EctsAndWeightProviderRegistry;

public class EctsAndWeightProviders {
    public static void init() {
        EctsAndWeightProviders.initForEnrolment();
        EctsAndWeightProviders.initForDismissal();
    }

    protected static void initForEnrolment() {
        EctsAndWeightProviderRegistry.setEctsProvider(Enrolment.class, x -> {
            Enrolment enrolment = (Enrolment)x;
            BigDecimal ectsOverride = CurriculumLineServices.getEctsCredits((CurriculumLine)enrolment);
            if (ectsOverride != null) {
                return ectsOverride;
            }
            return BigDecimal.valueOf(enrolment.getCurricularCourse().getEctsCredits(enrolment.getExecutionPeriod()));
        });
        EctsAndWeightProviderRegistry.setEctsForCurriculumProvider(Enrolment.class, x -> BigDecimal.valueOf(((Enrolment)x).getEctsCredits()));
        EctsAndWeightProviderRegistry.setWeightProvider(Enrolment.class, x -> {
            Enrolment enrolment = (Enrolment)x;
            BigDecimal weightOverride = CurriculumLineServices.getWeight((CurriculumLine)enrolment);
            if (weightOverride != null) {
                return weightOverride;
            }
            return enrolment.getCurricularCourse().getBaseWeight() != null ? new BigDecimal(enrolment.getCurricularCourse().getBaseWeight()) : null;
        });
        EctsAndWeightProviderRegistry.setWeightForCurriculumProvider(Enrolment.class, x -> {
            Enrolment enrolment = (Enrolment)x;
            if (enrolment.getEctsCreditsForCurriculum() != null && enrolment.getEctsCreditsForCurriculum().doubleValue() != 0.0) {
                return enrolment.getEctsCreditsForCurriculum();
            }
            if (enrolment.getWeigth() != null && enrolment.getWeigth() != 0.0) {
                return BigDecimal.valueOf(enrolment.getWeigth());
            }
            return BigDecimal.ZERO;
        });
    }

    private static void initForDismissal() {
        EctsAndWeightProviderRegistry.setEctsProvider(Dismissal.class, x -> {
            Dismissal dismissal = (Dismissal)x;
            BigDecimal ectsOverride = CurriculumLineServices.getEctsCredits((CurriculumLine)dismissal);
            if (ectsOverride != null) {
                return ectsOverride;
            }
            return BigDecimal.valueOf(dismissal.getCurricularCourse().getEctsCredits(dismissal.getCredits().getExecutionPeriod()));
        });
        EctsAndWeightProviderRegistry.setEctsForCurriculumProvider(Dismissal.class, x -> BigDecimal.valueOf(((Dismissal)x).getEctsCredits()));
        EctsAndWeightProviderRegistry.setWeightProvider(Dismissal.class, x -> {
            Dismissal dismissal = (Dismissal)x;
            BigDecimal weightOverride = CurriculumLineServices.getWeight((CurriculumLine)dismissal);
            if (weightOverride != null) {
                return weightOverride;
            }
            CurricularCourse curricularCourse = dismissal.getCurricularCourse();
            return curricularCourse != null && curricularCourse.getBaseWeight() != null ? BigDecimal.valueOf(curricularCourse.getBaseWeight()) : null;
        });
        EctsAndWeightProviderRegistry.setWeightForCurriculumProvider(Dismissal.class, x -> {
            Dismissal dismissal = (Dismissal)x;
            if (dismissal.getEctsCreditsForCurriculum() != null && dismissal.getEctsCreditsForCurriculum().doubleValue() != 0.0) {
                return dismissal.getEctsCreditsForCurriculum();
            }
            if (dismissal.getWeigth() != null && dismissal.getWeigth() != 0.0) {
                return BigDecimal.valueOf(dismissal.getWeigth());
            }
            return BigDecimal.ZERO;
        });
    }
}

