/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.enrolment.schoolClass;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.enrolment.schoolClass.SchoolClassEnrolmentPreference_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionInterval;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;

public class SchoolClassEnrolmentPreference
extends SchoolClassEnrolmentPreference_Base
implements Comparable<SchoolClassEnrolmentPreference> {
    protected SchoolClassEnrolmentPreference() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setLastModificationDate(new DateTime());
    }

    protected SchoolClassEnrolmentPreference(SchoolClass schoolClass, Integer preferenceOrder, RegistrationDataByExecutionInterval registrationData) {
        this();
        Objects.requireNonNull(schoolClass, "error.SchoolClassEnrolmentPreference.creation.nullSchoolClass");
        Objects.requireNonNull(preferenceOrder, "error.SchoolClassEnrolmentPreference.creation.nullPreferenceOrder");
        Objects.requireNonNull(registrationData, "error.SchoolClassEnrolmentPreference.creation.nullRegistrationData");
        if (SchoolClassEnrolmentPreference.findPreferenceByOrder(preferenceOrder, registrationData).isPresent()) {
            throw new DomainException("error.SchoolClassEnrolmentPreference.creation.alreadyExistsPreferenceWithSameOrder", new String[0]);
        }
        this.setSchoolClass(schoolClass);
        this.setPreferenceOrder(preferenceOrder);
        this.setRegistrationDataByExecutionInterval(registrationData);
    }

    public static void initializePreferencesForRegistration(RegistrationDataByExecutionInterval registrationData, Collection<SchoolClass> schoolClasses) {
        Set selectedSchoolClasses = registrationData.getSchoolClassEnrolmentPreferencesSet().stream().map(p -> p.getSchoolClass()).collect(Collectors.toSet());
        AtomicInteger order = new AtomicInteger(selectedSchoolClasses.size());
        schoolClasses.stream().filter(sc -> !selectedSchoolClasses.contains(sc)).forEach(sc -> new SchoolClassEnrolmentPreference((SchoolClass)sc, order.incrementAndGet(), registrationData));
    }

    public void changePreferenceOrder(boolean increment) {
        Integer currentOrder = this.getPreferenceOrder();
        Integer newOrder = currentOrder + (increment ? -1 : 1);
        Optional<SchoolClassEnrolmentPreference> preferenceToSwap = SchoolClassEnrolmentPreference.findPreferenceByOrder(newOrder, this.getRegistrationDataByExecutionInterval());
        preferenceToSwap.ifPresent(preference -> {
            preference.setPreferenceOrder(currentOrder);
            this.setPreferenceOrder(newOrder);
        });
    }

    public void setPreferenceOrder(Integer preferenceOrder) {
        super.setPreferenceOrder(preferenceOrder);
        this.setLastModificationDate(new DateTime());
    }

    public static Optional<SchoolClassEnrolmentPreference> findPreferenceByOrder(Integer preferenceOrder, RegistrationDataByExecutionInterval registrationData) {
        return registrationData.getSchoolClassEnrolmentPreferencesSet().stream().filter(preference -> preference.getPreferenceOrder().equals(preferenceOrder)).findFirst();
    }

    public void delete() {
        this.setRegistrationDataByExecutionInterval(null);
        this.setSchoolClass(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    @Override
    public int compareTo(SchoolClassEnrolmentPreference anotherPreference) {
        return this.getPreferenceOrder().compareTo(anotherPreference.getPreferenceOrder());
    }
}

