/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.dml;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.dml.DynamicField$callable$edit;
import org.fenixedu.academic.domain.dml.DynamicField$callable$findOrCreateFields;
import org.fenixedu.academic.domain.dml.DynamicFieldDescriptor;
import org.fenixedu.academic.domain.dml.DynamicFieldValueConverter;
import org.fenixedu.academic.domain.dml.DynamicField_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DynamicField
extends DynamicField_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$findOrCreateFields = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected DynamicField() {
        this.setRoot(Bennu.getInstance());
    }

    private String getCode() {
        return this.getDescriptor().getCode();
    }

    private boolean isRequired() {
        return this.getDescriptor().getRequired();
    }

    public DynamicField edit(Object value) {
        return this.edit(DynamicFieldValueConverter.serialize(this.getDescriptor().getFieldValueClass(), value));
    }

    private DynamicField edit(String string) {
        return (DynamicField)((Object)advice$edit.perform((Callable)new DynamicField$callable$edit(this, string)));
    }

    static /* synthetic */ DynamicField advised$edit(DynamicField this_, String value) {
        this_.setValue(value);
        if (this_.isRequired() && Strings.isNullOrEmpty((String)this_.getValue())) {
            throw new IllegalArgumentException("error.DynamicField.value.required");
        }
        return this_;
    }

    public <T> T getValue(Class<T> type) {
        return (T)DynamicFieldValueConverter.deserialize(type, this.getValue());
    }

    public void delete() {
        super.setDescriptor(null);
        super.setRoot(null);
        super.deleteDomainObject();
    }

    public static <T> T getFieldValue(DomainObject domainObject, String code) {
        if (domainObject == null) {
            return null;
        }
        DynamicField field = DynamicField.findField(domainObject, code);
        if (field == null) {
            throw new IllegalArgumentException("Cannot dynamic find field with code " + code + " in " + domainObject.getClass().getName());
        }
        Class type = field.getDescriptor().getFieldValueClass();
        return field != null ? (T)field.getValue(type) : null;
    }

    public static void setFieldValue(DomainObject domainObject, String code, Object value) {
        if (domainObject == null) {
            throw new NullPointerException("Domain object cannot be null");
        }
        DynamicField field = DynamicField.findField(domainObject, code);
        if (field == null) {
            throw new IllegalArgumentException("Cannot dynamic find field with code " + code + " in " + domainObject.getClass().getName());
        }
        field.edit(value);
    }

    public static DynamicField findField(DomainObject domainObject, String code) {
        return DynamicField.findOrCreateFields(domainObject).stream().filter(i -> StringUtils.equals((String)i.getCode(), (String)code)).findFirst().orElse(null);
    }

    public static Set<DynamicField> findOrCreateFields(DomainObject domainObject) {
        return (Set)advice$findOrCreateFields.perform((Callable)new DynamicField$callable$findOrCreateFields(domainObject));
    }

    static /* synthetic */ Set<DynamicField> advised$findOrCreateFields(DomainObject domainObject) {
        LinkedHashSet<DynamicField> result = new LinkedHashSet<DynamicField>();
        DynamicFieldDescriptor.find(domainObject).stream().sorted((x, y) -> Integer.compare(x.getOrder(), y.getOrder())).forEach(descriptor -> {
            DynamicField field = descriptor.findField(domainObject);
            if (field == null) {
                field = descriptor.createField(domainObject);
            }
            result.add(field);
        });
        return result;
    }
}

