/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment.CreditsInEnrolmentPeriod$callable$create;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment.CreditsInEnrolmentPeriod$callable$create$1;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment.CreditsInEnrolmentPeriod$callable$create$2;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment.CreditsInEnrolmentPeriod$callable$createForSemester;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment.CreditsInEnrolmentPeriod_Base;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreditsInEnrolmentPeriod
extends CreditsInEnrolmentPeriod_Base {
    public static final Advice advice$createForSemester = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create$2 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected CreditsInEnrolmentPeriod() {
        this.setIncludeEnrolments(false);
    }

    public static CreditsInEnrolmentPeriod createForSemester(CurricularPeriodConfiguration curricularPeriodConfiguration, BigDecimal bigDecimal, Integer n) {
        return (CreditsInEnrolmentPeriod)((Object)advice$createForSemester.perform((Callable)new CreditsInEnrolmentPeriod$callable$createForSemester(curricularPeriodConfiguration, bigDecimal, n)));
    }

    static /* synthetic */ CreditsInEnrolmentPeriod advised$createForSemester(CurricularPeriodConfiguration configuration, BigDecimal credits, Integer semester) {
        return CreditsInEnrolmentPeriod.create(configuration, credits, semester);
    }

    public static CreditsInEnrolmentPeriod create(CurricularPeriodConfiguration curricularPeriodConfiguration, BigDecimal bigDecimal, boolean bl) {
        return (CreditsInEnrolmentPeriod)((Object)advice$create.perform((Callable)new CreditsInEnrolmentPeriod$callable$create(curricularPeriodConfiguration, bigDecimal, bl)));
    }

    static /* synthetic */ CreditsInEnrolmentPeriod advised$create(CurricularPeriodConfiguration configuration, BigDecimal credits, boolean includeEnrolments) {
        CreditsInEnrolmentPeriod result = CreditsInEnrolmentPeriod.create(configuration, credits, null);
        result.setIncludeEnrolments(includeEnrolments);
        return result;
    }

    public static CreditsInEnrolmentPeriod create(CurricularPeriodConfiguration curricularPeriodConfiguration, BigDecimal bigDecimal) {
        return (CreditsInEnrolmentPeriod)((Object)advice$create$1.perform((Callable)new CreditsInEnrolmentPeriod$callable$create$1(curricularPeriodConfiguration, bigDecimal)));
    }

    static /* synthetic */ CreditsInEnrolmentPeriod advised$create(CurricularPeriodConfiguration configuration, BigDecimal credits) {
        return CreditsInEnrolmentPeriod.create(configuration, credits, null);
    }

    private static CreditsInEnrolmentPeriod create(CurricularPeriodConfiguration curricularPeriodConfiguration, BigDecimal bigDecimal, Integer n) {
        return (CreditsInEnrolmentPeriod)((Object)advice$create$2.perform((Callable)new CreditsInEnrolmentPeriod$callable$create$2(curricularPeriodConfiguration, bigDecimal, n)));
    }

    static /* synthetic */ CreditsInEnrolmentPeriod advised$create(CurricularPeriodConfiguration configuration, BigDecimal credits, Integer semester) {
        CreditsInEnrolmentPeriod result = new CreditsInEnrolmentPeriod();
        result.init(configuration, credits, semester);
        return result;
    }

    public String getLabel() {
        if (this.getSemester() != null) {
            return BundleUtil.getString((String)MODULE_BUNDLE, (String)("label." + ((Object)((Object)this)).getClass().getSimpleName() + ".semester"), (String[])new String[]{this.getCredits().toString(), this.getSemester().toString()});
        }
        return BundleUtil.getString((String)MODULE_BUNDLE, (String)("label." + ((Object)((Object)this)).getClass().getSimpleName()), (String[])new String[]{this.getCredits().toString()});
    }

    public RuleResult execute(EnrolmentContext enrolmentContext) {
        if (this.getSemester() != null) {
            if (this.getSemester().intValue() != enrolmentContext.getExecutionPeriod().getChildOrder().intValue()) {
                return this.createNA();
            }
            return this.executeBySemester(enrolmentContext);
        }
        return this.executeByYear(enrolmentContext);
    }

    private RuleResult executeByYear(EnrolmentContext enrolmentContext) {
        BigDecimal total = BigDecimal.ZERO;
        HashSet processedDegreeModules = Sets.newHashSet();
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : CreditsInEnrolmentPeriod.getEnroledAndEnroling((EnrolmentContext)enrolmentContext, i -> i.getExecutionInterval().getExecutionYear() == enrolmentContext.getExecutionPeriod().getExecutionYear())) {
            processedDegreeModules.add(degreeModuleToEvaluate.getDegreeModule());
            BigDecimal credits = BigDecimal.valueOf(degreeModuleToEvaluate.getEctsCredits());
            total = total.add(credits);
        }
        if (this.getIncludeEnrolments()) {
            for (Enrolment enrolment : enrolmentContext.getStudentCurricularPlan().getEnrolmentsSet()) {
                if (enrolment.isAnnulled() || processedDegreeModules.contains(enrolment.getCurricularCourse()) || enrolment.getExecutionYear() != enrolmentContext.getExecutionYear() || enrolment.getExecutionPeriod() == enrolmentContext.getExecutionPeriod()) continue;
                total = total.add(enrolment.getEctsCreditsForCurriculum());
            }
        }
        return total.compareTo(this.getCredits()) <= 0 ? this.createTrue() : this.createFalseLabelled(total);
    }

    private RuleResult executeBySemester(EnrolmentContext enrolmentContext) {
        BigDecimal total = BigDecimal.ZERO;
        Predicate<IDegreeModuleToEvaluate> filter = i -> i.isAnnualCurricularCourse(enrolmentContext.getExecutionYear()) ? i.getExecutionInterval().getExecutionYear() == enrolmentContext.getExecutionYear() : i.getExecutionInterval() == enrolmentContext.getExecutionPeriod();
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : CreditsInEnrolmentPeriod.getEnroledAndEnroling((EnrolmentContext)enrolmentContext, filter)) {
            BigDecimal credits = BigDecimal.valueOf(degreeModuleToEvaluate.getAccumulatedEctsCredits(enrolmentContext.getExecutionPeriod()));
            total = total.add(credits);
        }
        return total.compareTo(this.getCredits()) <= 0 ? this.createTrue() : this.createFalseLabelled(total);
    }
}

