/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment.CreditsInCurricularPeriod$callable$create;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment.CreditsInCurricularPeriod_Base;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.degreeStructure.CurricularPeriodServices;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreditsInCurricularPeriod
extends CreditsInCurricularPeriod_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected CreditsInCurricularPeriod() {
    }

    public static CreditsInCurricularPeriod createForYearInterval(CurricularPeriodConfiguration configuration, BigDecimal credits, Integer yearMin, Integer yearMax) {
        return CreditsInCurricularPeriod.create(configuration, credits, null, yearMin, yearMax);
    }

    private static CreditsInCurricularPeriod create(CurricularPeriodConfiguration curricularPeriodConfiguration, BigDecimal bigDecimal, Integer n, Integer n2, Integer n3) {
        return (CreditsInCurricularPeriod)((Object)advice$create.perform((Callable)new CreditsInCurricularPeriod$callable$create(curricularPeriodConfiguration, bigDecimal, n, n2, n3)));
    }

    static /* synthetic */ CreditsInCurricularPeriod advised$create(CurricularPeriodConfiguration configuration, BigDecimal credits, Integer semester, Integer yearMin, Integer yearMax) {
        CreditsInCurricularPeriod result = new CreditsInCurricularPeriod();
        result.init(configuration, credits, semester, yearMin, yearMax);
        return result;
    }

    private void init(CurricularPeriodConfiguration configuration, BigDecimal credits, Integer semester, Integer yearMin, Integer yearMax) {
        super.init(configuration, credits, semester);
        this.setYearMin(yearMin);
        this.setYearMax(yearMax);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getYearMin() == null) {
            throw new DomainException("error." + ((Object)((Object)this)).getClass().getSimpleName() + ".yearMin.required", new String[0]);
        }
    }

    private boolean isForYear() {
        return this.getYearMin() != null && this.getYearMax() != null && this.getYearMin().intValue() == this.getYearMax().intValue();
    }

    public String getLabel() {
        BigDecimal credits = this.getCredits();
        if (this.getSemester() != null) {
            return this.getStatuteTypesLabelPrefix() + BundleUtil.getString((String)MODULE_BUNDLE, (String)("label." + ((Object)((Object)this)).getClass().getSimpleName() + ".semester"), (String[])new String[]{credits.toString(), this.getSemester().toString(), this.getYearMin().toString()});
        }
        if (this.isForYear()) {
            return this.getStatuteTypesLabelPrefix() + BundleUtil.getString((String)MODULE_BUNDLE, (String)("label." + ((Object)((Object)this)).getClass().getSimpleName() + ".year"), (String[])new String[]{credits.toString(), this.getYearMin().toString()});
        }
        int configurationYear = this.getConfiguration().getCurricularPeriod().getChildOrder();
        int degreeDuration = this.getConfiguration().getDegreeCurricularPlan().getDegreeDuration();
        boolean simple = credits.equals(BigDecimal.ZERO) && this.getYearMin() == configurationYear + 1 && this.getYearMax() == degreeDuration;
        return this.getStatuteTypesLabelPrefix() + BundleUtil.getString((String)MODULE_BUNDLE, (String)("label." + ((Object)((Object)this)).getClass().getSimpleName() + (simple ? ".simple" : "")), (String[])new String[]{credits.toString(), this.getYearMin().toString(), this.getYearMax().toString()});
    }

    public RuleResult execute(EnrolmentContext enrolmentContext) {
        if (!this.isToEvaluate(enrolmentContext)) {
            return this.createNA();
        }
        Set configured = this.getCurricularPeriodsConfigured(this.getYearMin(), this.getYearMax(), true);
        if (configured == null) {
            return this.createFalseConfiguration();
        }
        BigDecimal total = this.getCreditsEnroledAndEnroling(enrolmentContext, configured);
        return total.compareTo(this.getCredits()) <= 0 ? this.createTrue() : this.createFalseLabelled(total);
    }

    private boolean isToEvaluate(EnrolmentContext enrolmentContext) {
        if (!this.hasValidStatute(enrolmentContext)) {
            return false;
        }
        return this.getApplyToFlunkedStudents() == null || this.getApplyToFlunkedStudents() == RegistrationServices.isFlunkedUsingCurricularYear(enrolmentContext.getRegistration(), enrolmentContext.getExecutionYear());
    }

    private BigDecimal getCreditsEnroledAndEnroling(EnrolmentContext enrolmentContext, Set<CurricularPeriod> configured) {
        BigDecimal result = BigDecimal.ZERO;
        ExecutionYear executionYear = enrolmentContext.getExecutionPeriod().getExecutionYear();
        ExecutionInterval interval = this.getSemester() == null ? null : executionYear.getExecutionSemesterFor(this.getSemester());
        Map<CurricularPeriod, BigDecimal> curricularPeriodCredits = CurricularPeriodServices.mapYearCredits(enrolmentContext, this.getApplyToOptionals(), interval);
        Set<CurricularPeriod> toInspect = configured;
        for (CurricularPeriod iter : toInspect) {
            BigDecimal credits = curricularPeriodCredits.get(iter);
            if (credits == null) continue;
            result = result.add(credits);
        }
        return result;
    }
}

