/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.gradingTable;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.student.gradingTable.GradingTableData;
import org.fenixedu.academic.domain.student.gradingTable.GradingTable_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.fenixframework.CallableWithoutException;
import pt.ist.fenixframework.FenixFramework;

public abstract class GradingTable
extends GradingTable_Base {
    public GradingTable() {
        this.setBennu(Bennu.getInstance());
        this.setCopied(false);
    }

    public void delete() {
        this.setExecutionYear(null);
        this.setBennu(null);
        this.deleteDomainObject();
    }

    private GradingTableData.GradeConversion find(String mark) {
        return this.getData().getTable().stream().filter(gc -> {
            try {
                BigDecimal tableMark = new BigDecimal(gc.getMark());
                BigDecimal testingMark = new BigDecimal(mark);
                return tableMark.compareTo(testingMark) == 0;
            }
            catch (NumberFormatException nfe) {
                return gc.getMark().equals(mark);
            }
        }).findFirst().orElse(null);
    }

    public String getEctsGrade(String mark) {
        GradingTableData.GradeConversion gc = this.find(mark);
        return gc != null ? gc.getEctsGrade() : null;
    }

    public String getEctsGrade(int mark) {
        return this.getEctsGrade(String.valueOf(mark));
    }

    public String getEctsGrade(BigDecimal mark) {
        return this.getEctsGrade(mark.toString());
    }

    public void setEctsGrade(String mark, String ectsGrade) {
        GradingTableData.GradeConversion gc = this.find(mark);
        if (gc != null) {
            gc.setEctsGrade(ectsGrade);
        }
    }

    public void setGrade(int mark, String ectsGrade) {
        this.setEctsGrade(String.valueOf(mark), ectsGrade);
    }

    public void setGrade(BigDecimal mark, String ectsGrade) {
        this.setEctsGrade(mark.toString(), ectsGrade);
    }

    public boolean hasMark(String mark) {
        return this.find(mark) != null;
    }

    public boolean hasMark(int mark) {
        return this.hasMark(String.valueOf(mark));
    }

    public boolean hasMark(BigDecimal mark) {
        return this.hasMark(mark.toString());
    }

    public void addMark(String mark, String ectsGrade) {
        GradingTableData.GradeConversion gc = new GradingTableData.GradeConversion(mark, ectsGrade);
        if (this.hasMark(mark)) {
            this.setEctsGrade(mark, ectsGrade);
        } else {
            this.getData().getTable().add(gc);
        }
    }

    public void addMark(int mark, String ectsGrade) {
        this.addMark(String.valueOf(mark), ectsGrade);
    }

    public void addMark(BigDecimal mark, String ectsGrade) {
        this.addMark(mark.toString(), ectsGrade);
    }

    public List<GradingTableData.GradeConversion> getEctsGrades() {
        return new ArrayList<GradingTableData.GradeConversion>(this.getData().getTable());
    }

    public String printScale() {
        Object scale = "";
        for (GradingTableData.GradeConversion gc : this.getEctsGrades()) {
            scale = (String)scale + gc.getEctsGrade();
        }
        return scale;
    }

    public abstract void compileData();

    protected static class GeneratorWorker<T extends GradingTable>
    extends Thread {
        private T table;
        private CallableWithoutException<T> logic;

        public GeneratorWorker(CallableWithoutException<T> logic) {
            this.logic = logic;
        }

        @Override
        public void run() {
            this.table = (GradingTable)((Object)FenixFramework.getTransactionManager().withTransaction(this.logic));
        }

        T getTable() {
            return this.table;
        }
    }
}

