/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Set;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curriculum.grade.GradeScale;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;

public class CurriculumGradeCalculator
implements Curriculum.CurriculumGradeCalculator {
    public static final RoundingMode ROUNDING_DEFAULT = RoundingMode.HALF_UP;
    public static final RoundingMode ROUNDING_TRUNCATE = RoundingMode.DOWN;
    private static final int FULL_SCALE = 5;
    public static final int RAW_SCALE = 2;
    private Curriculum curriculum;
    private BigDecimal sumPiCi;
    private BigDecimal sumPi;
    private Grade rawGrade;
    private Grade finalGrade;

    private void doCalculus(Curriculum curriculum) {
        GradeScale gradeScale = curriculum.getStudentCurricularPlan().getDegree().getNumericGradeScale();
        this.curriculum = curriculum;
        this.sumPiCi = BigDecimal.ZERO;
        this.sumPi = BigDecimal.ZERO;
        this.countAverage(curriculum.getEnrolmentRelatedEntries());
        this.countAverage(curriculum.getDismissalRelatedEntries());
        BigDecimal avg = this.calculateAverage();
        BigDecimal rawAvg = avg.setScale(2, curriculum.getStudentCurricularPlan() == null ? ROUNDING_DEFAULT : this.getRawGradeRoundingMode(curriculum.getStudentCurricularPlan().getDegree()));
        this.rawGrade = Grade.createGrade((String)rawAvg.toString(), (GradeScale)gradeScale);
        this.finalGrade = Grade.createGrade((String)rawAvg.setScale(0, ROUNDING_DEFAULT).toString(), (GradeScale)gradeScale);
    }

    protected RoundingMode getRawGradeRoundingMode(Degree degree) {
        return ROUNDING_DEFAULT;
    }

    private void countAverage(Set<ICurriculumEntry> entries) {
        for (ICurriculumEntry entry : entries) {
            if (!entry.getGrade().isNumeric()) continue;
            BigDecimal weigth = entry.getWeigthForCurriculum();
            this.sumPi = this.sumPi.add(weigth);
            this.sumPiCi = this.sumPiCi.add(entry.getWeigthForCurriculum().multiply(entry.getGrade().getNumericValue()));
        }
    }

    protected BigDecimal calculateAverage() {
        return this.sumPi.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : this.sumPiCi.divide(this.sumPi, 5, ROUNDING_DEFAULT);
    }

    public BigDecimal calculateAverage(Curriculum curriculum) {
        if (this.sumPiCi == null) {
            this.doCalculus(curriculum);
        }
        return this.calculateAverage();
    }

    public Grade rawGrade(Curriculum curriculum) {
        if (this.rawGrade == null) {
            this.doCalculus(curriculum);
        }
        return this.rawGrade;
    }

    public Grade finalGrade(Curriculum curriculum) {
        if (this.finalGrade == null) {
            this.doCalculus(curriculum);
        }
        return this.finalGrade;
    }

    public BigDecimal weigthedGradeSum(Curriculum curriculum) {
        if (this.sumPiCi == null) {
            this.doCalculus(curriculum);
        }
        return this.sumPiCi;
    }

    public Curriculum getCurriculum() {
        return this.curriculum;
    }

    public BigDecimal getSumPiCi() {
        return this.sumPiCi;
    }

    public BigDecimal getSumPi() {
        return this.sumPi;
    }

    public boolean isCalculatorForDegree() {
        return true;
    }

    public StudentCurricularPlan getStudentCurricularPlan() {
        return this.getCurriculum() == null ? null : this.getCurriculum().getStudentCurricularPlan();
    }
}

