/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.evaluation.season;

import org.fenixedu.academic.domain.OccupationPeriod;
import org.fenixedu.academic.domain.OccupationPeriodReference;
import org.fenixedu.academic.domain.OccupationPeriodType;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;
import org.fenixedu.commons.i18n.LocalizedString;

public enum EvaluationSeasonPeriodType {
    GRADE_SUBMISSION{

        @Override
        protected OccupationPeriodType translate() {
            return OccupationPeriodType.GRADE_SUBMISSION;
        }
    }
    ,
    EXAMS{

        @Override
        protected OccupationPeriodType translate() {
            return OccupationPeriodType.EXAMS;
        }
    };


    public LocalizedString getDescriptionI18N() {
        return AcademicExtensionsUtil.bundleI18N(this.name(), new String[0]);
    }

    protected abstract OccupationPeriodType translate();

    protected static EvaluationSeasonPeriodType get(OccupationPeriod input) {
        switch (((OccupationPeriodReference)input.getExecutionDegreesSet().iterator().next()).getPeriodType()) {
            case EXAMS: 
            case EXAMS_SPECIAL_SEASON: {
                return EXAMS;
            }
            case GRADE_SUBMISSION: 
            case GRADE_SUBMISSION_SPECIAL_SEASON: {
                return GRADE_SUBMISSION;
            }
        }
        throw new RuntimeException();
    }
}

