/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.curricularRules.CreditsLimit;
import org.fenixedu.academic.domain.curricularRules.CreditsLimitWithPreviousApprovals;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleServices;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnroledCurriculumModuleWrapper;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;

public class CreditsLimitWithPreviousApprovalsExecutor
extends CurricularRuleExecutor {
    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        if (!this.canApplyRule(enrolmentContext, curricularRule)) {
            return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        CreditsLimit creditsLimit = (CreditsLimit)sourceDegreeModuleToEvaluate.getCurriculumGroup().getMostRecentActiveCurricularRule(CurricularRuleType.CREDITS_LIMIT, enrolmentContext.getExecutionYear());
        if (creditsLimit == null) {
            return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        CreditsLimitWithPreviousApprovals rule = (CreditsLimitWithPreviousApprovals)curricularRule;
        IDegreeModuleToEvaluate degreeModuleToEvaluate = this.searchDegreeModuleToEvaluate(enrolmentContext, (ICurricularRule)rule);
        if (degreeModuleToEvaluate.isEnroled()) {
            EnroledCurriculumModuleWrapper moduleEnroledWrapper = (EnroledCurriculumModuleWrapper)degreeModuleToEvaluate;
            CurriculumModule curriculumModule = moduleEnroledWrapper.getCurriculumModule();
            double ectsFromPrevious = CurricularRuleServices.calculateEctsCreditsFromPreviousGroups(enrolmentContext, rule);
            Double ectsCredits = CurricularRuleServices.calculateCreditsConcluded(enrolmentContext, curriculumModule) + CurricularRuleServices.calculateEnroledEctsCredits(enrolmentContext, curriculumModule) + this.calculateEctsCreditsFromToEnrolCurricularCourses(enrolmentContext, curriculumModule) + ectsFromPrevious;
            if (creditsLimit.creditsExceedMaximum(ectsCredits)) {
                if (sourceDegreeModuleToEvaluate.isEnroled() && sourceDegreeModuleToEvaluate.isLeaf()) {
                    return this.createImpossibleResult(creditsLimit, sourceDegreeModuleToEvaluate, ectsCredits);
                }
                return this.createFalseRuleResult(creditsLimit, sourceDegreeModuleToEvaluate, ectsCredits);
            }
            return RuleResult.createTrue((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    private Double calculateEctsCreditsFromToEnrolCurricularCourses(EnrolmentContext enrolmentContext, CurriculumModule parentCurriculumModule) {
        ExecutionInterval executionInterval = enrolmentContext.getExecutionPeriod();
        BigDecimal result = BigDecimal.ZERO;
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!degreeModuleToEvaluate.isEnroling() || !parentCurriculumModule.hasCurriculumModule((CurriculumModule)degreeModuleToEvaluate.getCurriculumGroup())) continue;
            result = result.add(BigDecimal.valueOf(degreeModuleToEvaluate.getEctsCredits(executionInterval)));
        }
        return result.doubleValue();
    }

    private RuleResult createFalseRuleResult(CreditsLimit rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, Double ectsCredits) {
        if (rule.getMinimumCredits().equals(rule.getMaximumCredits())) {
            return RuleResult.createFalse((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule(), (String)"curricularRules.ruleExecutors.CreditsLimitExecutor.limit.not.fulfilled", (String[])new String[]{rule.getDegreeModuleToApplyRule().getName(), rule.getMinimumCredits().toString(), ectsCredits.toString()});
        }
        return RuleResult.createFalse((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule(), (String)"curricularRules.ruleExecutors.CreditsLimitExecutor.limits.not.fulfilled", (String[])new String[]{rule.getDegreeModuleToApplyRule().getName(), rule.getMinimumCredits().toString(), rule.getMaximumCredits().toString(), ectsCredits.toString()});
    }

    @Deprecated
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return this.executeEnrolmentVerificationWithRules(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
    }

    private RuleResult createImpossibleResult(CreditsLimit rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, Double ectsCredits) {
        if (rule.getMinimumCredits().equals(rule.getMaximumCredits())) {
            return RuleResult.createImpossible((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule(), (String)"curricularRules.ruleExecutors.CreditsLimitExecutor.limit.not.fulfilled", (String[])new String[]{rule.getDegreeModuleToApplyRule().getName(), rule.getMinimumCredits().toString(), ectsCredits.toString()});
        }
        return RuleResult.createImpossible((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule(), (String)"curricularRules.ruleExecutors.CreditsLimitExecutor.limits.not.fulfilled", (String[])new String[]{rule.getDegreeModuleToApplyRule().getName(), rule.getMinimumCredits().toString(), rule.getMaximumCredits().toString(), ectsCredits.toString()});
    }

    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }

    protected boolean canApplyRule(EnrolmentContext enrolmentContext, ICurricularRule curricularRule) {
        return super.canApplyRule(enrolmentContext, curricularRule) && RegistrationServices.isCurriculumAccumulated(enrolmentContext.getRegistration());
    }
}

