/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.student;

import java.io.Serializable;
import java.math.BigDecimal;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionYear;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.student.curriculum.CurriculumConfigurationInitializer;
import org.fenixedu.academic.domain.student.curriculum.CurriculumModuleServices;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.RootCurriculumGroup;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.academic.dto.student.RegistrationStateBean;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;

public class RegistrationDataBean
implements Serializable {
    private RegistrationDataByExecutionYear data;
    private LocalDate enrolmentDate;
    private StudentCurricularPlan studentCurricularPlan;
    private SchoolClass schoolClass;
    private Boolean notApproved;
    private Integer enrolmentsCount;
    private Double creditsConcluded;
    private BigDecimal enroledEcts;
    private RegistrationStateType lastRegistrationStateType;
    private YearMonthDay lastAcademicActDate;

    public RegistrationDataBean(RegistrationDataByExecutionYear data) {
        this.setData(data);
    }

    public RegistrationDataByExecutionYear getData() {
        return this.data;
    }

    public void setData(RegistrationDataByExecutionYear data) {
        this.data = data;
    }

    public String getExternalId() {
        return this.getData() == null ? null : this.getData().getExternalId();
    }

    public Registration getRegistration() {
        return this.getData() == null ? null : this.getData().getRegistration();
    }

    public ExecutionYear getExecutionYear() {
        return this.getData() == null ? null : this.getData().getExecutionYear();
    }

    public LocalDate getEnrolmentDate() {
        if (this.enrolmentDate == null) {
            this.enrolmentDate = this.getData() == null ? null : this.getData().getEnrolmentDate();
        }
        return this.enrolmentDate;
    }

    public void setEnrolmentDate(LocalDate enrolmentDate) {
        this.enrolmentDate = enrolmentDate;
    }

    public boolean isReingression() {
        return this.getData() == null ? false : this.getData().getReingression();
    }

    public StudentCurricularPlan getStudentCurricularPlan() {
        if (this.studentCurricularPlan == null) {
            Registration registration = this.getRegistration();
            StudentCurricularPlan plan = registration == null ? null : registration.getStudentCurricularPlan(this.getExecutionYear());
            this.studentCurricularPlan = plan == null ? registration.getLastStudentCurricularPlan() : plan;
        }
        return this.studentCurricularPlan;
    }

    private SchoolClass getSchoolClass() {
        if (this.schoolClass == null) {
            Registration registration = this.getRegistration();
            ExecutionInterval executionInterval = this.getExecutionYear().isCurrent() ? ExecutionInterval.findFirstCurrentChild((AcademicCalendarRootEntry)registration.getDegree().getCalendar()) : this.getExecutionYear().getFirstExecutionPeriod();
            this.schoolClass = RegistrationServices.getSchoolClassBy(registration, executionInterval).orElse(null);
        }
        return this.schoolClass;
    }

    public String getSchoolClassPresentation() {
        String result = "";
        SchoolClass schoolClass = this.getSchoolClass();
        if (schoolClass != null && schoolClass.getEditablePartOfName() != null) {
            return schoolClass.getEditablePartOfName().toString();
        }
        return "";
    }

    public CurriculumConfigurationInitializer.CurricularYearResult getCurricularYearResult() {
        return RegistrationServices.getCurricularYear(this.getData().getRegistration(), this.getData().getExecutionYear());
    }

    public String getCurricularYearPresentation() {
        return String.valueOf(this.getCurricularYearResult().getResult());
    }

    public String getCurricularYearJustificationPresentation() {
        return this.getCurricularYearResult().getJustificationPresentation();
    }

    public Boolean getNotApproved() {
        if (this.notApproved == null) {
            Registration registration = this.getRegistration();
            ExecutionYear executionYear = this.getExecutionYear();
            this.notApproved = RegistrationServices.isFlunkedUsingCurricularYear(registration, executionYear);
        }
        return this.notApproved;
    }

    public Integer getEnrolmentsCount() {
        if (this.enrolmentsCount == null) {
            StudentCurricularPlan plan = this.getStudentCurricularPlan();
            this.enrolmentsCount = plan == null ? null : Integer.valueOf(Long.valueOf(plan.getEnrolmentsByExecutionYear(this.getExecutionYear()).stream().filter(i -> !i.isAnnulled()).count()).intValue());
        }
        return this.enrolmentsCount;
    }

    @Deprecated(forRemoval=true)
    public Double getCreditsConcluded() {
        if (this.creditsConcluded == null) {
            BigDecimal approvedEnrolments = this.getStudentCurricularPlan().getEnrolmentsByExecutionYear(this.getExecutionYear()).stream().filter(e -> e.isApproved()).map(e -> e.getEctsCreditsForCurriculum()).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.creditsConcluded = approvedEnrolments.doubleValue();
        }
        return this.creditsConcluded;
    }

    public BigDecimal getEnroledEcts() {
        if (this.enroledEcts == null) {
            BigDecimal result = BigDecimal.ZERO;
            ExecutionYear year = this.getExecutionYear();
            if (RegistrationServices.isCurriculumAccumulated(this.getRegistration())) {
                for (StudentCurricularPlan iter : this.getRegistration().getStudentCurricularPlansSet()) {
                    RootCurriculumGroup curriculumGroup = iter.getRoot();
                    result = result.add(CurriculumModuleServices.getEnroledAndNotApprovedEctsCreditsFor((CurriculumGroup)curriculumGroup, (ExecutionInterval)year));
                }
            } else {
                StudentCurricularPlan plan = this.getStudentCurricularPlan();
                RootCurriculumGroup curriculumGroup = plan.getRoot();
                result = result.add(CurriculumModuleServices.getEnroledAndNotApprovedEctsCreditsFor((CurriculumGroup)curriculumGroup, (ExecutionInterval)year));
            }
            this.enroledEcts = result;
        }
        return this.enroledEcts;
    }

    public String getRegimePresentation() {
        return this.getRegistration().getRegimeType(this.getExecutionYear()).getLocalizedName();
    }

    public String getLastRegistrationStatePresentation() {
        if (this.lastRegistrationStateType == null) {
            RegistrationStateBean bean = RegistrationServices.getLastRegistrationState(this.getRegistration(), this.getExecutionYear());
            this.lastRegistrationStateType = bean == null ? null : bean.getStateType();
        }
        return this.lastRegistrationStateType == null ? "-" : this.lastRegistrationStateType.getDescription();
    }

    public YearMonthDay getLastAcademicActDate() {
        if (this.lastAcademicActDate == null) {
            StudentCurricularPlan plan = this.getStudentCurricularPlan();
            this.lastAcademicActDate = plan == null ? null : CurriculumModuleServices.calculateLastAcademicActDate((CurriculumGroup)plan.getRoot(), this.getExecutionYear(), false);
        }
        return this.lastAcademicActDate;
    }
}

