/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.gradingTable;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class GradingTableData {
    private Gson gson = new Gson();
    private Set<GradeConversion> table = new TreeSet<GradeConversion>(GradeConversion.COMPARE_BY_MARK);

    public String toJson() {
        Type type = new TypeToken<Set<GradeConversion>>(){}.getType();
        return this.gson.toJson(this.table, type);
    }

    public static GradingTableData fromJson(String json) {
        GradingTableData data = new GradingTableData();
        Type type = new TypeToken<Set<GradeConversion>>(){}.getType();
        Set table = (Set)data.gson.fromJson(json, type);
        data.table.addAll(table);
        return data;
    }

    public Set<GradeConversion> getTable() {
        return this.table;
    }

    public void setTable(Set<GradeConversion> table) {
        this.table = table;
    }

    public static class GradeConversion {
        private String mark;
        private String ectsGrade;
        public static Comparator<GradeConversion> COMPARE_BY_MARK = new Comparator<GradeConversion>(){

            @Override
            public int compare(GradeConversion gc1, GradeConversion gc2) {
                return gc1.getMark().compareTo(gc2.getMark());
            }
        };

        public GradeConversion(String mark, String ectsGrade) {
            this.mark = mark;
            this.ectsGrade = ectsGrade;
        }

        public String getMark() {
            return this.mark;
        }

        public void setMark(String mark) {
            this.mark = mark;
        }

        public String getEctsGrade() {
            return this.ectsGrade;
        }

        public void setEctsGrade(String ectsGrade) {
            this.ectsGrade = ectsGrade;
        }

        public boolean equals(Object obj) {
            if (obj instanceof GradeConversion) {
                GradeConversion gc = (GradeConversion)obj;
                return this.getMark().equals(gc.getMark());
            }
            return super.equals(obj);
        }
    }
}

