/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.researchPublication;

import java.util.Comparator;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.researchPublication.ResearchPublicationType;
import org.fenixedu.academic.domain.researchPublication.ResearchPublication_Base;
import org.fenixedu.bennu.core.domain.Bennu;

public class ResearchPublication
extends ResearchPublication_Base {
    protected ResearchPublication() {
        this.setRoot(Bennu.getInstance());
    }

    public static ResearchPublication create(Person person, ResearchPublicationType type) {
        ResearchPublication publication = new ResearchPublication();
        Optional<ResearchPublication> maxPublication = person.getResearchPublicationsSet().stream().filter(p -> p.getType() == type).max(Comparator.comparing(ResearchPublication_Base::getRelevanceOrder));
        publication.setRelevanceOrder(maxPublication.isPresent() ? maxPublication.get().getRelevanceOrder() + 1 : 1);
        publication.setPerson(person);
        publication.setType(type);
        return publication;
    }

    public void edit(String title, String authors, String publicationData, Integer year) {
        this.setTitle(title);
        this.setAuthors(authors);
        this.setPublicationData(publicationData);
        this.setYear(year);
    }

    public void changeRelevanceOrder(boolean increment) {
        Integer currentOrder = this.getRelevanceOrder();
        Integer newOrder = currentOrder + (increment ? -1 : 1);
        Optional<ResearchPublication> publicationToSwap = ResearchPublication.findPublicationByRelevanceOrder(newOrder, this.getPerson(), this.getType());
        publicationToSwap.ifPresent(preference -> {
            preference.setRelevanceOrder(currentOrder);
            this.setRelevanceOrder(newOrder);
        });
    }

    private static Optional<ResearchPublication> findPublicationByRelevanceOrder(Integer relevanceOrder, Person person, ResearchPublicationType type) {
        return person.getResearchPublicationsSet().stream().filter(p -> p.getRelevanceOrder().equals(relevanceOrder) && p.getType() == type).findFirst();
    }

    public static SortedSet<ResearchPublication> findPublicationsSortedByRelevance(Person person, ResearchPublicationType type) {
        TreeSet<ResearchPublication> result = new TreeSet<ResearchPublication>(Comparator.comparing(ResearchPublication_Base::getRelevanceOrder));
        if (person != null && type != null) {
            result.addAll(person.getResearchPublicationsSet().stream().filter(p -> type.equals((Object)p.getType())).collect(Collectors.toSet()));
        }
        return result;
    }

    public void delete() {
        Person person = this.getPerson();
        ResearchPublicationType type = this.getType();
        this.setPerson(null);
        this.setType(null);
        this.setRoot(null);
        AtomicInteger order = new AtomicInteger(0);
        ResearchPublication.findPublicationsSortedByRelevance(person, type).forEach(rp -> rp.setRelevanceOrder(order.incrementAndGet()));
        super.deleteDomainObject();
    }
}

