/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.evaluation.season.rule;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.evaluation.season.rule.EvaluationSeasonRule$callable$delete;
import org.fenixedu.academic.domain.evaluation.season.rule.EvaluationSeasonRule_Base;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class EvaluationSeasonRule
extends EvaluationSeasonRule_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected EvaluationSeasonRule() {
    }

    protected void init(EvaluationSeason season) {
        this.setSeason(season);
        this.checkRules();
    }

    private void checkRules() {
        EvaluationSeason season = this.getSeason();
        if (season == null) {
            throw new AcademicExtensionsDomainException("error.EvaluationSeasonRule.evaluationSeason.required", new String[0]);
        }
        if (season.getRulesSet().stream().anyMatch(this.checkDuplicate())) {
            throw new AcademicExtensionsDomainException("error.EvaluationSeasonRule.duplicated", new String[0]);
        }
    }

    protected Predicate<? super EvaluationSeasonRule> checkDuplicate() {
        return i -> i != this && ((Object)i).getClass().equals(((Object)((Object)this)).getClass());
    }

    protected static void checkRules(Grade grade) {
        if (grade == null || grade.isEmpty()) {
            throw new AcademicExtensionsDomainException("error.EvaluationSeasonRule.grade.required", new String[0]);
        }
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new EvaluationSeasonRule$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(EvaluationSeasonRule this_) {
        AcademicExtensionsDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        this_.setSeason(null);
        this_.deleteDomainObject();
    }

    public abstract boolean isUpdatable();

    public abstract LocalizedString getDescriptionI18N();

    protected static LocalizedString getDescriptionI18N(Class<? extends EvaluationSeasonRule> clazz, Grade grade) {
        LocalizedString.Builder builder = AcademicExtensionsUtil.bundleI18N(clazz.getSimpleName(), new String[0]).builder();
        builder.append(grade.getExtendedValue(), ": ");
        builder.append(grade.getValue(), " [");
        builder.append(grade.getGradeScale().getName().getContent(), ", ");
        builder.append("]");
        return builder.build();
    }

    public static <T extends EvaluationSeasonRule> Set<T> find(EvaluationSeason season, Class<T> clazz) {
        HashSet result = Sets.newHashSet();
        if (season != null && clazz != null) {
            season.getRulesSet().stream().filter(i -> ((Object)i).getClass() == clazz).forEach(i -> result.add(i));
        }
        return result;
    }
}

