/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.evaluation.markSheet;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.Holiday;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.curriculum.EnrolmentEvaluationContext;
import org.fenixedu.academic.domain.curriculum.grade.GradeScale;
import org.fenixedu.academic.domain.evaluation.EvaluationComparator;
import org.fenixedu.academic.domain.evaluation.EvaluationServices;
import org.fenixedu.academic.domain.evaluation.config.MarkSheetSettings;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet$callable$confirm;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet$callable$create;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet$callable$delete;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet$callable$edit;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet$callable$markAsPrinted;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet$callable$revertToEdition;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet$callable$submit;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetChangeRequest;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetChangeRequestStateEnum;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetSnapshot;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetStateChange;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetStateEnum;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet_Base;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonPeriod;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonPeriodType;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonServices;
import org.fenixedu.academic.domain.evaluation.season.rule.EvaluationSeasonRule;
import org.fenixedu.academic.domain.evaluation.season.rule.GradeScaleValidator;
import org.fenixedu.academic.domain.evaluation.services.EnrolmentEvaluationServices;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.services.EnrolmentServices;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.util.EnrolmentEvaluationState;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.commons.i18n.I18N;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CompetenceCourseMarkSheet
extends CompetenceCourseMarkSheet_Base {
    public static Comparator<String> COMPARATOR_FOR_STUDENT_NAME;
    private static final Logger logger;
    private static BiPredicate<EvaluationSeason, Enrolment> enrolmentCandidateForEvaluationExtensionPredicate;
    private static BiPredicate<GradeScaleValidator, CompetenceCourseMarkSheet> gradeValidatorToConsiderExtensionPredicate;
    private static Predicate<CompetenceCourseMarkSheet> supportsTeacherConfirmationExtensionPredicate;
    public static final Advice advice$edit;
    public static final Advice advice$delete;
    public static final Advice advice$create;
    public static final Advice advice$markAsPrinted;
    public static final Advice advice$confirm;
    public static final Advice advice$submit;
    public static final Advice advice$revertToEdition;

    protected CompetenceCourseMarkSheet() {
    }

    protected void init(ExecutionInterval executionInterval, CompetenceCourse competenceCourse, ExecutionCourse executionCourse, EvaluationSeason evaluationSeason, Evaluation courseEvaluation, LocalDate evaluationDate, GradeScale gradeScale, Person certifier, Set<Shift> shifts, LocalDate expireDate) {
        this.setExecutionSemester(executionInterval);
        this.setCompetenceCourse(competenceCourse);
        this.setExecutionCourse(executionCourse);
        this.setEvaluationSeason(evaluationSeason);
        if (courseEvaluation != null) {
            this.setCourseEvaluation(courseEvaluation);
            this.setEvaluationDate(new LocalDate((Object)courseEvaluation.getEvaluationDate()));
        } else {
            this.setEvaluationDate(evaluationDate);
        }
        this.setGradeScale(gradeScale);
        this.setCertifier(certifier);
        this.getShiftSet().addAll(shifts);
        this.setExpireDate(expireDate);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getExecutionInterval() == null) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.executionSemester.required", new String[0]);
        }
        if (this.getCompetenceCourse() == null) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.competenceCourse.required", new String[0]);
        }
        if (this.getExecutionCourse() == null) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.executionCourse.required", new String[0]);
        }
        if (this.getEvaluationSeason() == null) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.evaluationSeason.required", new String[0]);
        }
        if (this.getEvaluationDate() == null) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.evaluationDate.required", new String[0]);
        }
        if (this.getCertifier() == null) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.certifier.required", new String[0]);
        }
        if (this.getGradeScale() == null) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.gradeScale.required", new String[0]);
        }
        for (EnrolmentEvaluation enrolmentEvaluation : this.getEnrolmentEvaluationSet()) {
            if (enrolmentEvaluation.getGrade() == null || enrolmentEvaluation.getGrade().isEmpty() || enrolmentEvaluation.getGrade().getGradeScale() == this.getGradeScale()) continue;
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.marksheet.already.contains.evaluations.with.another.grade.scale", new String[0]);
        }
        if (this.getEnrolmentEvaluationSet().isEmpty() && this.getExecutionCourseEnrolmentsNotInAnyMarkSheet().isEmpty()) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.no.enrolments.found.for.grade.submission", new String[0]);
        }
        this.checkRulesEvaluationDate();
    }

    private void checkRulesEvaluationDate() {
        this.checkIfEvaluationDateIsWorkingDay();
        this.checkIfEvaluationDateIsInExamsPeriod();
        this.checkIfEvaluationsDateIsEqualToMarkSheetEvaluationDate();
    }

    private void checkIfEvaluationDateIsWorkingDay() {
        if (this.getEvaluationDate().getDayOfWeek() == 7 || Holiday.isHoliday((LocalDate)this.getEvaluationDate())) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.evaluationDateNotInWorkingDay", this.getEvaluationDate().toString());
        }
    }

    private void checkIfEvaluationDateIsInExamsPeriod() {
        Set<EvaluationSeasonPeriod> periods = this.getExamsPeriods();
        if (periods.isEmpty()) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.evaluationDateNotInExamsPeriod.undefined", EvaluationSeasonServices.getDescriptionI18N(this.getEvaluationSeason()).getContent(), this.getExecutionInterval().getQualifiedName());
        }
        for (EvaluationSeasonPeriod iter : periods) {
            if (!iter.isContainingDate(this.getEvaluationDate())) continue;
            return;
        }
        throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.evaluationDateNotInExamsPeriod", this.getEvaluationDate().toString(), EvaluationSeasonPeriod.getIntervalsDescription(periods));
    }

    protected void checkIfIsGradeSubmissionAvailable() {
        if (this.getExpireDate() != null) {
            if (this.getExpireDate().isBefore((ReadablePartial)new LocalDate())) {
                throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.notInGradeSubmissionPeriod.expired", new String[0]);
            }
            return;
        }
        Set<EvaluationSeasonPeriod> periods = this.getGradeSubmissionPeriods();
        if (periods.isEmpty()) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.notInGradeSubmissionPeriod.undefined", EvaluationSeasonServices.getDescriptionI18N(this.getEvaluationSeason()).getContent(), this.getExecutionInterval().getQualifiedName());
        }
        for (EvaluationSeasonPeriod iter : periods) {
            if (!iter.isContainingDate(new LocalDate())) continue;
            return;
        }
        throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.notInGradeSubmissionPeriod", EvaluationSeasonPeriod.getIntervalsDescription(periods));
    }

    private void checkIfEvaluationsDateIsEqualToMarkSheetEvaluationDate() {
        for (EnrolmentEvaluation iter : this.getEnrolmentEvaluationSet()) {
            if (iter.getExamDateYearMonthDay().toLocalDate().isEqual((ReadablePartial)this.getEvaluationDate())) continue;
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.evaluations.examDate.must.be.equal.marksheet.evaluationDate", new String[0]);
        }
    }

    public void edit(LocalDate localDate, GradeScale gradeScale, Person person, LocalDate localDate2) {
        Object object = advice$edit.perform((Callable)new CompetenceCourseMarkSheet$callable$edit(this, localDate, gradeScale, person, localDate2));
    }

    static /* synthetic */ void advised$edit(CompetenceCourseMarkSheet this_, LocalDate evaluationDate, GradeScale gradeScale, Person certifier, LocalDate expireDate) {
        if (!this_.isEdition()) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.markSheet.can.only.be.updated.in.edition.state", new String[0]);
        }
        this_.getEnrolmentEvaluationSet().forEach(e -> {
            e.setExamDateYearMonthDay(evaluationDate == null ? null : evaluationDate.toDateTimeAtStartOfDay().toYearMonthDay());
            e.setPersonResponsibleForGrade(certifier);
        });
        this_.init(this_.getExecutionInterval(), this_.getCompetenceCourse(), this_.getExecutionCourse(), this_.getEvaluationSeason(), this_.getCourseEvaluation(), evaluationDate, gradeScale, certifier, this_.getShiftSet(), expireDate);
        this_.checkRules();
    }

    void editExpireDate(LocalDate expireDate) {
        super.setExpireDate(expireDate);
        this.checkRules();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new CompetenceCourseMarkSheet$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(CompetenceCourseMarkSheet this_) {
        if (!this_.isEdition()) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.markSheet.can.only.be.deleted.in.edition.state", new String[0]);
        }
        this_.setExecutionSemester(null);
        this_.setCompetenceCourse(null);
        this_.setExecutionCourse(null);
        this_.setEvaluationSeason(null);
        this_.setCourseEvaluation(null);
        this_.setCertifier(null);
        this_.getShiftSet().clear();
        this_.removeEnrolmentEvaluationData();
        this_.setGradeScale(null);
        Iterator stateIterator = this_.getStateChangeSet().iterator();
        while (stateIterator.hasNext()) {
            CompetenceCourseMarkSheetStateChange stateChange = (CompetenceCourseMarkSheetStateChange)stateIterator.next();
            stateIterator.remove();
            stateChange.delete();
        }
        Iterator changeRequestIterator = this_.getChangeRequestsSet().iterator();
        while (changeRequestIterator.hasNext()) {
            CompetenceCourseMarkSheetChangeRequest changeRequest = (CompetenceCourseMarkSheetChangeRequest)((Object)changeRequestIterator.next());
            changeRequestIterator.remove();
            changeRequest.delete();
        }
        AcademicExtensionsDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        this_.deleteDomainObject();
    }

    private void removeEnrolmentEvaluationData() {
        for (EnrolmentEvaluation evaluation : this.getEnrolmentEvaluationSet()) {
            CompetenceCourseMarkSheet.removeEnrolmentEvaluationData(evaluation);
        }
    }

    public Set<EvaluationSeasonPeriod> getGradeSubmissionPeriods() {
        return this.getEvaluationSeasonPeriods(EvaluationSeasonPeriodType.GRADE_SUBMISSION);
    }

    public Set<EvaluationSeasonPeriod> getExamsPeriods() {
        return this.getEvaluationSeasonPeriods(EvaluationSeasonPeriodType.EXAMS);
    }

    private Set<EvaluationSeasonPeriod> getEvaluationSeasonPeriods(EvaluationSeasonPeriodType periodType) {
        HashSet result = Sets.newHashSet();
        for (EvaluationSeasonPeriod iter : this.getExecutionInterval().getEvaluationSeasonPeriodSet()) {
            if (iter.getPeriodType() != periodType || iter.getSeason() != this.getEvaluationSeason() || Sets.intersection(iter.getExecutionDegrees(), this.getExecutionDegrees()).isEmpty()) continue;
            result.add(iter);
        }
        return result;
    }

    private Set<ExecutionDegree> getExecutionDegrees() {
        return this.getExecutionCourse().getAssociatedCurricularCoursesSet().stream().map(i -> i.getExecutionDegreeFor(this.getExecutionInterval().getAcademicInterval())).collect(Collectors.toSet());
    }

    public static CompetenceCourseMarkSheet create(ExecutionInterval executionInterval, CompetenceCourse competenceCourse, ExecutionCourse executionCourse, EvaluationSeason evaluationSeason, Evaluation evaluation, LocalDate localDate, Person person, Set<Shift> set, boolean bl) {
        return (CompetenceCourseMarkSheet)((Object)advice$create.perform((Callable)new CompetenceCourseMarkSheet$callable$create(executionInterval, competenceCourse, executionCourse, evaluationSeason, evaluation, localDate, person, set, bl)));
    }

    static /* synthetic */ CompetenceCourseMarkSheet advised$create(ExecutionInterval interval, CompetenceCourse competence, ExecutionCourse execution, EvaluationSeason season, Evaluation courseEvaluation, LocalDate evaluationDate, Person certifier, Set<Shift> shifts, boolean byTeacher) {
        CompetenceCourseMarkSheet result = new CompetenceCourseMarkSheet();
        GradeScale gradeScale = competence.getGradeScale();
        result.init(interval, competence, execution, season, courseEvaluation, evaluationDate, gradeScale, certifier, shifts, null);
        if (byTeacher && !EvaluationSeasonServices.isSupportsEmptyGrades(season) && CompetenceCourseMarkSheet.findBy(interval, competence, execution, season, result.getEvaluationDateTime(), shifts, null, null).anyMatch(i -> i != result)) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.duplicated", season.getName().getContent());
        }
        CompetenceCourseMarkSheetStateChange.createEditionState(result, byTeacher, null);
        return result;
    }

    public static Stream<CompetenceCourseMarkSheet> findBy(ExecutionCourse executionCourse) {
        HashSet result = Sets.newHashSet();
        if (executionCourse != null) {
            for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
                result.addAll(curricularCourse.getCompetenceCourse().getCompetenceCourseMarkSheetSet());
            }
        }
        return result.stream().filter(c -> c.getExecutionInterval() == executionCourse.getExecutionInterval());
    }

    public static Stream<CompetenceCourseMarkSheet> findBy(ExecutionInterval executionInterval, CompetenceCourse competenceCourse, ExecutionCourse executionCourse, EvaluationSeason evaluationSeason, DateTime evaluationDateTime, Set<Shift> shifts, CompetenceCourseMarkSheetStateEnum markSheetState, CompetenceCourseMarkSheetChangeRequestStateEnum changeRequestState) {
        HashSet result = Sets.newHashSet();
        if (executionInterval != null) {
            result.addAll(executionInterval.getCompetenceCourseMarkSheetSet());
        }
        return result.stream().filter(c -> competenceCourse == null || c.getCompetenceCourse() == competenceCourse).filter(c -> executionCourse == null || c.getExecutionCourse() == executionCourse).filter(c -> evaluationSeason == null || c.getEvaluationSeason() == evaluationSeason).filter(c -> evaluationDateTime == null || c.getEvaluationDateTime().equals((Object)evaluationDateTime)).filter(c -> shifts == null || shifts.isEmpty() || Sets.symmetricDifference((Set)shifts, (Set)c.getShiftSet()).isEmpty()).filter(c -> markSheetState == null || c.isInState(markSheetState)).filter(c -> changeRequestState == null || c.getChangeRequestsSet().stream().anyMatch(r -> r.getState() == changeRequestState));
    }

    private CompetenceCourseMarkSheetStateChange getFirstStateChange() {
        return (CompetenceCourseMarkSheetStateChange)this.getStateChangeSet().stream().min(CompetenceCourseMarkSheetStateChange::compareTo).get();
    }

    private CompetenceCourseMarkSheetStateChange getStateChange() {
        return (CompetenceCourseMarkSheetStateChange)this.getStateChangeSet().stream().max(CompetenceCourseMarkSheetStateChange::compareTo).get();
    }

    public boolean isEdition() {
        return this.getStateChange().isEdition();
    }

    public boolean isSubmitted() {
        return this.getStateChange().isSubmitted();
    }

    public boolean isConfirmed() {
        return this.getStateChange().isConfirmed();
    }

    public DateTime getCreationDate() {
        return this.getFirstStateChange().getDate();
    }

    public Person getCreator() {
        return this.getFirstStateChange().getResponsible();
    }

    public String getState() {
        return this.getStateChange().getState().getDescriptionI18N().getContent();
    }

    public DateTime getStateDate() {
        return this.getStateChange().getDate();
    }

    public String getEvaluationDatePresentation() {
        return CompetenceCourseMarkSheet.getEvaluationDatePresentation(this.getEvaluationDateTime());
    }

    public DateTime getEvaluationDateTime() {
        return CompetenceCourseMarkSheet.getEvaluationDateTime(this.getCourseEvaluation(), this.getEvaluationDate());
    }

    public static String getEvaluationDatePresentation(DateTime input) {
        return input.toString(!input.toString().contains("T00:00") ? "yyyy-MM-dd HH:mm" : "yyyy-MM-dd");
    }

    public static DateTime getEvaluationDateTime(Evaluation courseEvaluation, LocalDate evaluationDate) {
        return CompetenceCourseMarkSheet.getEvaluationDateTime(courseEvaluation == null ? null : new DateTime((Object)courseEvaluation.getEvaluationDate()), evaluationDate);
    }

    public static DateTime getEvaluationDateTime(DateTime evaluationDateTime, LocalDate evaluationDate) {
        if (evaluationDateTime != null) {
            return evaluationDateTime;
        }
        return evaluationDate.toDateTimeAtStartOfDay();
    }

    public boolean hasCourseEvaluationDate() {
        Evaluation courseEvaluation = this.getCourseEvaluation();
        return courseEvaluation != null && courseEvaluation.getEvaluationDate() != null;
    }

    public void markAsPrinted() {
        Object object = advice$markAsPrinted.perform((Callable)new CompetenceCourseMarkSheet$callable$markAsPrinted(this));
    }

    static /* synthetic */ void advised$markAsPrinted(CompetenceCourseMarkSheet this_) {
        super.setPrinted(true);
    }

    @Deprecated
    public ExecutionInterval getExecutionSemester() {
        return super.getExecutionSemester();
    }

    public ExecutionInterval getExecutionInterval() {
        return super.getExecutionSemester();
    }

    public ExecutionYear getExecutionYear() {
        return this.getExecutionInterval().getExecutionYear();
    }

    public String getShiftsDescription() {
        return this.getShiftSet().stream().map(i -> i.getNome()).collect(Collectors.joining(", "));
    }

    private static Set<Enrolment> getEnrolmentsNotInAnyMarkSheet(ExecutionInterval interval, CompetenceCourse competence, ExecutionCourse execution, EvaluationSeason season, LocalDate evaluationDate, Set<Shift> shifts) {
        return CompetenceCourseMarkSheet.filterEnrolmentsForGradeSubmission(CompetenceCourseMarkSheet.collectEnrolmentsForGradeSubmission(interval, competence, execution), interval, season, evaluationDate, shifts);
    }

    private static Set<Enrolment> collectEnrolmentsForGradeSubmission(ExecutionInterval interval, CompetenceCourse competence, ExecutionCourse execution) {
        HashSet result = Sets.newHashSet();
        for (ExecutionCourse iter : competence.getExecutionCoursesByExecutionPeriod(interval)) {
            if (execution != null && iter != execution) continue;
            for (CurricularCourse curricularCourse : iter.getAssociatedCurricularCoursesSet()) {
                for (CurriculumModule curriculumModule : curricularCourse.getCurriculumModulesSet()) {
                    if (!curriculumModule.isEnrolment()) continue;
                    result.add((Enrolment)curriculumModule);
                }
            }
            for (Attends attends : iter.getAttendsSet()) {
                Enrolment enrolment = attends.getEnrolment();
                if (enrolment == null) continue;
                result.add(enrolment);
            }
        }
        return result;
    }

    public Set<Enrolment> getExecutionCourseEnrolmentsNotInAnyMarkSheet() {
        HashSet result = Sets.newHashSet(CompetenceCourseMarkSheet.getExecutionCourseEnrolmentsNotInAnyMarkSheet(this.getExecutionInterval(), this.getCompetenceCourse(), this.getExecutionCourse(), this.getEvaluationSeason(), this.getEvaluationDate(), this.getShiftSet()));
        if (this.getCourseEvaluation() == null) {
            return result;
        }
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Set<Evaluation> courseEvaluations;
            Enrolment enrolment = (Enrolment)iterator.next();
            if (!EvaluationServices.isEnroledInAnyCourseEvaluation(enrolment, this.getEvaluationSeason(), this.getExecutionInterval()) || (courseEvaluations = EvaluationServices.findEnrolmentCourseEvaluations(enrolment, this.getEvaluationSeason(), this.getExecutionInterval())).contains(this.getCourseEvaluation()) || courseEvaluations.stream().anyMatch(courseEvaluation -> EvaluationServices.isCourseEvaluationIgnoredInMarkSheet(courseEvaluation))) continue;
            iterator.remove();
        }
        return result;
    }

    public static Set<Enrolment> getExecutionCourseEnrolmentsNotInAnyMarkSheet(ExecutionInterval interval, CompetenceCourse competence, ExecutionCourse execution, EvaluationSeason season, LocalDate evaluationDate, Set<Shift> shifts) {
        HashSet result = Sets.newHashSet();
        for (Enrolment enrolment : CompetenceCourseMarkSheet.getEnrolmentsNotInAnyMarkSheet(interval, competence, execution, season, evaluationDate, shifts)) {
            if (competence.isAnual() && interval == interval.getExecutionYear().getLastExecutionPeriod()) {
                ExecutionCourse otherExecutionCourse = enrolment.getExecutionCourseFor(interval.getExecutionYear().getFirstExecutionPeriod());
                if (otherExecutionCourse == null || !otherExecutionCourse.getAssociatedCurricularCoursesSet().containsAll(execution.getAssociatedCurricularCoursesSet()) || enrolment.getAttendsByExecutionCourse(otherExecutionCourse) == null) continue;
                result.add(enrolment);
                continue;
            }
            if (enrolment.getAttendsByExecutionCourse(execution) == null) continue;
            result.add(enrolment);
        }
        return result;
    }

    private static Set<Enrolment> filterEnrolmentsForGradeSubmission(Set<Enrolment> enrolments, ExecutionInterval interval, EvaluationSeason season, LocalDate evaluationDate, Set<Shift> shifts) {
        HashSet result = Sets.newHashSet();
        for (Enrolment enrolment : enrolments) {
            EnrolmentEvaluation evaluation;
            if (enrolment.isAnnulled() || !EvaluationSeasonServices.isDifferentEvaluationSemesterAccepted(season) && !enrolment.isValid(interval) || !shifts.isEmpty() && !EnrolmentServices.containsAnyShift(enrolment, interval, shifts)) continue;
            Optional inspect = enrolment.getEnrolmentEvaluation(season, interval, null);
            EnrolmentEvaluation enrolmentEvaluation = evaluation = inspect.isPresent() ? (EnrolmentEvaluation)inspect.get() : null;
            if (evaluation != null) {
                if (!evaluation.isTemporary() || evaluation.isAnnuled()) continue;
                if (evaluation.isTemporary()) {
                    if (evaluation.getCompetenceCourseMarkSheet() != null) continue;
                    if (EvaluationSeasonServices.isRequiredEnrolmentEvaluation(season)) {
                        result.add(enrolment);
                        continue;
                    }
                }
            } else if (EvaluationSeasonServices.isRequiredEnrolmentEvaluation(season)) continue;
            if (!CompetenceCourseMarkSheet.isEnrolmentCandidateForEvaluation(enrolment, evaluationDate, interval, season)) continue;
            result.add(enrolment);
        }
        return result;
    }

    private static boolean isEnrolmentCandidateForEvaluation(Enrolment enrolment, LocalDate evaluationDate, ExecutionInterval interval, EvaluationSeason season) {
        boolean isApproved;
        Collection<EnrolmentEvaluation> evaluations = CompetenceCourseMarkSheet.getAllFinalEnrolmentEvaluations(enrolment, evaluationDate);
        EnrolmentEvaluation latestEvaluation = CompetenceCourseMarkSheet.getLatestEnrolmentEvaluation(evaluations);
        boolean bl = isApproved = latestEvaluation != null && latestEvaluation.isApproved();
        if (!EvaluationSeasonServices.isForApprovedEnrolments(season) && isApproved) {
            return false;
        }
        if (EvaluationSeasonServices.isForApprovedEnrolments(season) && !isApproved) {
            return false;
        }
        if (EvaluationSeasonServices.hasStudentStatuteBlocking(season, enrolment, interval)) {
            return false;
        }
        if (EvaluationSeasonServices.hasPreviousSeasonBlockingGrade(season, latestEvaluation)) {
            return false;
        }
        if (!EvaluationSeasonServices.hasRequiredPreviousSeasonMinimumGrade(season, evaluations)) {
            return false;
        }
        if (EvaluationSeasonServices.isRequiredPreviousSeasonEvaluation(season)) {
            if (latestEvaluation == null) {
                return false;
            }
            boolean exclude = true;
            EvaluationSeason previousSeason = EvaluationSeasonServices.getPreviousSeason(season);
            if (previousSeason != null) {
                for (EnrolmentEvaluation iter : evaluations) {
                    if (iter.getEvaluationSeason() != previousSeason) continue;
                    exclude = false;
                    break;
                }
            }
            if (exclude) {
                return false;
            }
        }
        if (EvaluationSeasonServices.isBlockingTreasuryEventInDebt(season, enrolment, interval)) {
            return false;
        }
        return enrolmentCandidateForEvaluationExtensionPredicate == null || enrolmentCandidateForEvaluationExtensionPredicate.test(season, enrolment);
    }

    public static void setEnrolmentCandidateForEvaluationExtensionPredicate(BiPredicate<EvaluationSeason, Enrolment> enrolmentCandidateForEvaluationExtensionPredicate) {
        CompetenceCourseMarkSheet.enrolmentCandidateForEvaluationExtensionPredicate = enrolmentCandidateForEvaluationExtensionPredicate;
    }

    private static Collection<EnrolmentEvaluation> getAllFinalEnrolmentEvaluations(Enrolment enrolment, LocalDate evaluationDate) {
        List evaluations = enrolment.getAllFinalEnrolmentEvaluations();
        if (evaluationDate != null) {
            Iterator iterator = evaluations.iterator();
            while (iterator.hasNext()) {
                EnrolmentEvaluation enrolmentEvaluation = (EnrolmentEvaluation)iterator.next();
                YearMonthDay examDate = enrolmentEvaluation.getExamDateYearMonthDay();
                if (examDate == null || examDate.isBefore((ReadablePartial)evaluationDate)) continue;
                iterator.remove();
            }
        }
        return evaluations;
    }

    private static EnrolmentEvaluation getLatestEnrolmentEvaluation(Collection<EnrolmentEvaluation> evaluations) {
        return evaluations == null || evaluations.isEmpty() ? null : evaluations.stream().max(new EvaluationComparator()).get();
    }

    public boolean isGradeValueAccepted(String gradeValue) {
        if (!Strings.isNullOrEmpty((String)gradeValue)) {
            GradeScaleValidator validator = this.getGradeScaleValidator();
            if (validator == null) {
                return this.getGradeScale().belongsTo(gradeValue);
            }
            return validator.isGradeValueAccepted(gradeValue);
        }
        return false;
    }

    public String getGradeScaleDescription() {
        GradeScaleValidator validator = this.getGradeScaleValidator();
        return validator == null ? this.getGradeScale().getName().getContent() : validator.getRuleDescription().getContent();
    }

    public GradeScaleValidator getGradeScaleValidator() {
        TreeSet result = Sets.newTreeSet((Comparator)DomainObjectUtil.COMPARATOR_BY_ID);
        for (GradeScaleValidator validator : EvaluationSeasonRule.find(this.getEvaluationSeason(), GradeScaleValidator.class)) {
            Set markSheetDegreeTypes;
            if (validator.getGradeScale() != this.getGradeScale() || Sets.intersection(markSheetDegreeTypes = this.getExecutionCourse().getAssociatedCurricularCoursesSet().stream().map(c -> c.getDegree().getDegreeType()).collect(Collectors.toSet()), (Set)validator.getDegreeTypeSet()).isEmpty() || gradeValidatorToConsiderExtensionPredicate != null && !gradeValidatorToConsiderExtensionPredicate.test(validator, this)) continue;
            result.add(validator);
        }
        if (result.size() > 1) {
            logger.warn("Mark sheet {} has more than one GradeScaleValidator configured, returning the oldest", (Object)this);
        }
        return result.isEmpty() ? null : (GradeScaleValidator)((Object)result.first());
    }

    public static void setGradeValidatorToConsiderExtensionPredicate(BiPredicate<GradeScaleValidator, CompetenceCourseMarkSheet> gradeValidatorToConsiderExtensionPredicate) {
        CompetenceCourseMarkSheet.gradeValidatorToConsiderExtensionPredicate = gradeValidatorToConsiderExtensionPredicate;
    }

    public void confirm(boolean bl) {
        Object object = advice$confirm.perform((Callable)new CompetenceCourseMarkSheet$callable$confirm(this, bl));
    }

    static /* synthetic */ void advised$confirm(CompetenceCourseMarkSheet this_, boolean byTeacher) {
        if (!this_.isSubmitted()) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.must.be.submitted.to.confirm", new String[0]);
        }
        if (this_.getEnrolmentEvaluationSet().isEmpty()) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.enrolmentEvaluations.required.to.confirm.markSheet", new String[0]);
        }
        if (byTeacher && !this_.getSupportsTeacherConfirmation()) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.unauthorized.teacher.confirmation", this_.getEvaluationSeason().getName().getContent());
        }
        CompetenceCourseMarkSheetStateChange.createConfirmedState(this_, byTeacher, null);
        for (EnrolmentEvaluation evaluation : this_.getEnrolmentEvaluationSet()) {
            if (evaluation.isFinal()) continue;
            evaluation.setEnrolmentEvaluationState(EnrolmentEvaluationState.FINAL_OBJ);
            evaluation.setGradeAvailableDateYearMonthDay(new YearMonthDay());
            EnrolmentEvaluationServices.onStateChange(evaluation);
            EnrolmentServices.updateState(evaluation.getEnrolment());
        }
    }

    public boolean getSupportsTeacherConfirmation() {
        if (EvaluationSeasonServices.isSupportsTeacherConfirmation(this.getEvaluationSeason())) {
            return true;
        }
        return supportsTeacherConfirmationExtensionPredicate != null && supportsTeacherConfirmationExtensionPredicate.test(this);
    }

    public static void setSupportsTeacherConfirmationExtensionPredicate(Predicate<CompetenceCourseMarkSheet> supportsTeacherConfirmationExtensionPredicate) {
        CompetenceCourseMarkSheet.supportsTeacherConfirmationExtensionPredicate = supportsTeacherConfirmationExtensionPredicate;
    }

    public static void setEnrolmentEvaluationData(CompetenceCourseMarkSheet markSheet, EnrolmentEvaluation evaluation, String gradeValue, GradeScale gradeScale) {
        if (evaluation.getCompetenceCourseMarkSheet() != null && evaluation.getCompetenceCourseMarkSheet() != markSheet) {
            return;
        }
        if (gradeValue.equals(evaluation.getGradeValue())) {
            return;
        }
        evaluation.setEnrolmentEvaluationState(EnrolmentEvaluationState.TEMPORARY_OBJ);
        evaluation.setGrade(Grade.createGrade((String)gradeValue, (GradeScale)gradeScale));
        evaluation.setWhenDateTime(new DateTime());
        evaluation.setCompetenceCourseMarkSheet(markSheet);
        evaluation.setExamDateYearMonthDay(markSheet.getEvaluationDateTime().toYearMonthDay());
        evaluation.setPersonResponsibleForGrade(markSheet.getCertifier());
        evaluation.setPerson(Authenticate.getUser().getPerson());
        evaluation.setContext(EnrolmentEvaluationContext.MARK_SHEET_EVALUATION);
        EnrolmentEvaluationServices.onStateChange(evaluation);
        EnrolmentServices.updateState(evaluation.getEnrolment());
    }

    public static void removeEnrolmentEvaluationData(EnrolmentEvaluation evaluation) {
        if (!evaluation.hasGrade()) {
            return;
        }
        evaluation.setEnrolmentEvaluationState(EnrolmentEvaluationState.TEMPORARY_OBJ);
        evaluation.setGradeAvailableDateYearMonthDay((YearMonthDay)null);
        evaluation.setGrade(Grade.createEmptyGrade());
        evaluation.setWhenDateTime((DateTime)null);
        evaluation.setCompetenceCourseMarkSheet(null);
        evaluation.setExamDateYearMonthDay((YearMonthDay)null);
        evaluation.setPersonResponsibleForGrade((Person)null);
        evaluation.setPerson((Person)null);
        evaluation.setContext((EnrolmentEvaluationContext)null);
        EnrolmentEvaluationServices.onStateChange(evaluation);
        if (FenixFramework.isDomainObjectValid((DomainObject)evaluation)) {
            EnrolmentServices.updateState(evaluation.getEnrolment());
        }
    }

    public void submit(boolean bl) {
        Object object = advice$submit.perform((Callable)new CompetenceCourseMarkSheet$callable$submit(this, bl));
    }

    static /* synthetic */ void advised$submit(CompetenceCourseMarkSheet this_, boolean byTeacher) {
        if (!this_.isEdition()) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.must.be.edition.to.confirm", new String[0]);
        }
        CompetenceCourseMarkSheetStateChange stateChange = CompetenceCourseMarkSheetStateChange.createSubmitedState(this_, byTeacher, null);
        CompetenceCourseMarkSheetSnapshot snapshot = CompetenceCourseMarkSheetSnapshot.create(stateChange, this_.getCompetenceCourse().getCode(), this_.getCompetenceCourse().getNameI18N(), this_.getExecutionInterval().getQualifiedName(), this_.getEvaluationSeason().getName(), this_.getCertifier().getName(), this_.getEvaluationDate(), this_.getEvaluationDateTime());
        for (EnrolmentEvaluation evaluation : this_.getSortedEnrolmentEvaluations()) {
            Registration registration = evaluation.getRegistration();
            Degree degree = evaluation.getStudentCurricularPlan().getDegree();
            snapshot.addEntry(registration.getNumber(), registration.getName(), evaluation.getGrade(), degree.getCode(), degree.getNameI18N(), EnrolmentServices.getShiftsDescription(evaluation.getEnrolment(), evaluation.getExecutionInterval()));
        }
        snapshot.finalize();
    }

    public void revertToEdition(boolean bl, String string) {
        Object object = advice$revertToEdition.perform((Callable)new CompetenceCourseMarkSheet$callable$revertToEdition(this, bl, string));
    }

    static /* synthetic */ void advised$revertToEdition(CompetenceCourseMarkSheet this_, boolean byTeacher, String reason) {
        if (this_.isEdition()) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.already.in.edition", new String[0]);
        }
        CompetenceCourseMarkSheetStateChange.createEditionState(this_, byTeacher, reason);
    }

    public String getCheckSum() {
        if (this.isEdition()) {
            return null;
        }
        return this.getLastSnapshot().get().getCheckSum();
    }

    public String getFormattedCheckSum() {
        if (this.isEdition()) {
            return null;
        }
        return this.getLastSnapshot().get().getFormattedCheckSum();
    }

    public SortedSet<EnrolmentEvaluation> getSortedEnrolmentEvaluations() {
        Comparator byStudentName = (x, y) -> COMPARATOR_FOR_STUDENT_NAME.compare(x.getRegistration().getStudent().getName(), y.getRegistration().getStudent().getName());
        TreeSet result = Sets.newTreeSet(byStudentName.thenComparing(DomainObjectUtil.COMPARATOR_BY_ID));
        result.addAll(this.getEnrolmentEvaluationSet());
        return result;
    }

    private Optional<CompetenceCourseMarkSheetStateChange> getLastStateBy(CompetenceCourseMarkSheetStateEnum type) {
        return this.getStateChangeSet().stream().filter(s -> s.getState() == type).max(CompetenceCourseMarkSheetStateChange::compareTo);
    }

    public Optional<CompetenceCourseMarkSheetSnapshot> getLastSnapshot() {
        Optional<CompetenceCourseMarkSheetStateChange> lastStateChange = this.getLastStateBy(CompetenceCourseMarkSheetStateEnum.findSubmited());
        return Optional.ofNullable(lastStateChange.isPresent() ? lastStateChange.get().getSnapshot() : null);
    }

    public List<CompetenceCourseMarkSheetSnapshot> getSnapshots() {
        return this.getStateChangeSet().stream().sorted().filter(s -> s.getState() == CompetenceCourseMarkSheetStateEnum.findSubmited()).map(s -> s.getSnapshot()).collect(Collectors.toList());
    }

    public Collection<CompetenceCourseMarkSheetSnapshot> getPreviousSnapshots() {
        List<CompetenceCourseMarkSheetSnapshot> snapshots = this.getSnapshots();
        if (snapshots.isEmpty()) {
            return Collections.emptySet();
        }
        CompetenceCourseMarkSheetSnapshot lastSnapshot = this.getLastSnapshot().get();
        return snapshots.stream().filter(s -> s != lastSnapshot).collect(Collectors.toSet());
    }

    public boolean isInState(CompetenceCourseMarkSheetStateEnum markSheetState) {
        return this.getStateChange().getState() == markSheetState;
    }

    public boolean isCertifierExecutionCourseResponsible() {
        Professorship professorship = this.getExecutionCourse().getProfessorship(this.getCertifier());
        return professorship != null && professorship.isResponsibleFor();
    }

    public boolean getLimitTeacherView() {
        Person logged = Authenticate.getUser().getPerson();
        boolean teacherCanView = this.getCertifier() == logged || this.getCreator() == logged || MarkSheetSettings.getInstance().getAllowTeacherToChooseCertifier();
        return !teacherCanView;
    }

    public CompetenceCourseMarkSheetChangeRequest getLastChangeRequest() {
        Optional<CompetenceCourseMarkSheetChangeRequest> result = this.getChangeRequestsSet().stream().max(CompetenceCourseMarkSheetChangeRequest.COMPARATOR_BY_REQUEST_DATE);
        return result.isPresent() ? result.get() : null;
    }

    public CompetenceCourseMarkSheetChangeRequest getLastPendingChangeRequest() {
        Optional<CompetenceCourseMarkSheetChangeRequest> result = this.getPendingChangeRequests().stream().max(CompetenceCourseMarkSheetChangeRequest.COMPARATOR_BY_REQUEST_DATE);
        return result.isPresent() ? result.get() : null;
    }

    public Set<CompetenceCourseMarkSheetChangeRequest> getPendingChangeRequests() {
        return this.getChangeRequestsSet().stream().filter(i -> i.isPending()).collect(Collectors.toSet());
    }

    public SortedSet<CompetenceCourseMarkSheetChangeRequest> getSortedChangeRequests() {
        TreeSet result = Sets.newTreeSet(CompetenceCourseMarkSheetChangeRequest.COMPARATOR_BY_REQUEST_DATE.reversed());
        result.addAll(this.getChangeRequestsSet());
        return result;
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$markAsPrinted = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$confirm = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$submit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$revertToEdition = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_FOR_STUDENT_NAME = new Comparator<String>(){
            final Supplier<Collator> collator = () -> {
                Collator result = Collator.getInstance(I18N.getLocale());
                return result;
            };

            @Override
            public int compare(String o1, String o2) {
                return this.collator.get().compare(this.normalize(o1), this.normalize(o2));
            }

            private String normalize(String input) {
                return input == null ? "" : input.replaceAll("\\s+", "").toUpperCase();
            }
        };
        logger = LoggerFactory.getLogger(CompetenceCourseMarkSheet.class);
    }
}

