/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.FenixEduAcademicExtensionsConfiguration;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompetenceCourseServices {
    private static final Logger logger = LoggerFactory.getLogger(CompetenceCourseServices.class);
    private static final int CACHE_APPROVALS_MAX_SIZE = 50000;
    private static final int CACHE_APPROVALS_EXPIRE_MIN = 1;
    private static final Cache<String, Boolean> CACHE_APPROVALS = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(50000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private static final Cache<String, Set<StudentCurricularPlan>> CACHE_SCPS = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(50000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private static final LoadingCache<String, Set<CurricularCourse>> CACHE_COMPETENCE_CURRICULARS = CacheBuilder.newBuilder().concurrencyLevel(8).build((CacheLoader)new CacheLoader<String, Set<CurricularCourse>>(){

        public Set<CurricularCourse> load(String key) throws Exception {
            logger.debug(String.format("Miss on CompetenceCourse CurricularCourses cache [%s %s]", new DateTime(), key));
            return CompetenceCourseServices.loadExpandedCurricularCourses(key);
        }
    });

    public static boolean isCompetenceCourseApproved(StudentCurricularPlan plan, CurricularCourse course, ExecutionInterval Interval2) {
        Registration registration = plan.getRegistration();
        CompetenceCourse competence = course.getCompetenceCourse();
        if (competence == null) {
            return plan.isApproved(course, Interval2);
        }
        String key = registration.getExternalId();
        try {
            Set set = (Set)CACHE_SCPS.get((Object)key, () -> CompetenceCourseServices.getScpsToCheck(registration));
            return set.stream().anyMatch(i -> CompetenceCourseServices.isApproved(i, competence, Interval2));
        }
        catch (ExecutionException e) {
            logger.error(String.format("Unable to get Approvals [%s %s %s]", new DateTime(), key, e.getLocalizedMessage()));
            return false;
        }
    }

    public static int countEnrolmentsUntil(StudentCurricularPlan plan, CurricularCourse curricularCourse, ExecutionYear executionYear) {
        Registration registration = plan.getRegistration();
        CompetenceCourse competence = curricularCourse.getCompetenceCourse();
        Predicate<Enrolment> validEnrolment = e -> !e.isAnnulled() && e.getExecutionYear().isBeforeOrEquals(executionYear);
        if (competence == null) {
            return (int)plan.getEnrolments(curricularCourse).stream().filter(validEnrolment).count();
        }
        Set<CurricularCourse> expandedCourses = CompetenceCourseServices.getExpandedCurricularCourses(competence.getCode());
        int total = 0;
        for (StudentCurricularPlan scpToCheck : CompetenceCourseServices.getScpsToCheck(registration)) {
            for (CurricularCourse expandedCourse : expandedCourses) {
                total = (int)((long)total + scpToCheck.getEnrolments(expandedCourse).stream().filter(validEnrolment).count());
            }
        }
        return total;
    }

    private static Set<StudentCurricularPlan> getScpsToCheck(Registration registration) {
        HashSet result = Sets.newHashSet();
        if (FenixEduAcademicExtensionsConfiguration.getConfiguration().getCurricularRulesApprovalsAwareOfCompetenceCourseAtStudentScope().booleanValue()) {
            ((Stream)registration.getStudent().getRegistrationsSet().stream().flatMap(r -> r.getStudentCurricularPlansSet().stream()).sequential()).collect(Collectors.toCollection(() -> result));
        } else {
            result.addAll(registration.getStudentCurricularPlansSet());
        }
        return result;
    }

    private static boolean isApproved(final StudentCurricularPlan plan, final CompetenceCourse competence, final ExecutionInterval interval) {
        final String key = String.format("%s#%s#%s", plan.getExternalId(), competence.getExternalId(), interval == null ? "null" : interval.getExternalId());
        try {
            return (Boolean)CACHE_APPROVALS.get((Object)key, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    logger.debug(String.format("Miss on Approvals cache [%s %s]", new DateTime(), key));
                    Set<CurricularCourse> curriculars = CompetenceCourseServices.getExpandedCurricularCourses(competence.getCode());
                    return curriculars == null ? false : curriculars.stream().anyMatch(curricular -> plan.isApproved(curricular, interval));
                }
            });
        }
        catch (Throwable t) {
            logger.error(String.format("Unable to get Approvals [%s %s %s]", new DateTime(), key, t.getLocalizedMessage()));
            return false;
        }
    }

    public static Set<CurricularCourse> getExpandedCurricularCourses(String code) {
        String key = CompetenceCourseServices.filterCode(code);
        try {
            return (Set)CACHE_COMPETENCE_CURRICULARS.get((Object)key);
        }
        catch (Throwable t) {
            logger.error(String.format("Unable to get CompetenceCourse CurricularCourses [%s %s %s]", new DateTime(), key, t.getLocalizedMessage()));
            return null;
        }
    }

    private static Set<CurricularCourse> loadExpandedCurricularCourses(String key) {
        HashSet result = Sets.newHashSet();
        String code = CompetenceCourseServices.filterCode(key);
        if (!Strings.isNullOrEmpty((String)code)) {
            CompetenceCourse competence = CompetenceCourse.find((String)code);
            if (competence != null) {
                result.addAll(competence.getAssociatedCurricularCoursesSet());
            }
            for (CompetenceCourse iter : Bennu.getInstance().getCompetenceCoursesSet()) {
                if (iter == competence || !code.equals(CompetenceCourseServices.filterCode(iter.getCode()))) continue;
                result.addAll(iter.getAssociatedCurricularCoursesSet());
            }
        }
        return result;
    }

    private static boolean isExpandedCode(String input) {
        return !Strings.isNullOrEmpty((String)input) && input.endsWith("ects") && input.contains("_");
    }

    private static String filterCode(String input) {
        return !CompetenceCourseServices.isExpandedCode(input) ? input : input.substring(0, input.lastIndexOf("_"));
    }
}

