/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition.ApprovedCredits$callable$create;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition.ApprovedCredits$callable$createForSemester;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition.ApprovedCredits$callable$createForYearInterval;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition.ApprovedCredits_Base;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.degreeStructure.CurricularPeriodServices;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ApprovedCredits
extends ApprovedCredits_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createForSemester = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createForYearInterval = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected ApprovedCredits() {
    }

    public static ApprovedCredits create(CurricularPeriodConfiguration curricularPeriodConfiguration, BigDecimal bigDecimal) {
        return (ApprovedCredits)((Object)advice$create.perform((Callable)new ApprovedCredits$callable$create(curricularPeriodConfiguration, bigDecimal)));
    }

    static /* synthetic */ ApprovedCredits advised$create(CurricularPeriodConfiguration configuration, BigDecimal credits) {
        ApprovedCredits result = new ApprovedCredits();
        result.init(configuration, credits, null, null);
        return result;
    }

    public static ApprovedCredits createForSemester(CurricularPeriodConfiguration curricularPeriodConfiguration, BigDecimal bigDecimal, Integer n) {
        return (ApprovedCredits)((Object)advice$createForSemester.perform((Callable)new ApprovedCredits$callable$createForSemester(curricularPeriodConfiguration, bigDecimal, n)));
    }

    static /* synthetic */ ApprovedCredits advised$createForSemester(CurricularPeriodConfiguration configuration, BigDecimal credits, Integer semester) {
        ApprovedCredits result = new ApprovedCredits();
        result.init(configuration, credits, null, null);
        result.setSemester(semester);
        return result;
    }

    public static ApprovedCredits createForYearInterval(CurricularPeriodConfiguration curricularPeriodConfiguration, BigDecimal bigDecimal, Integer n, Integer n2) {
        return (ApprovedCredits)((Object)advice$createForYearInterval.perform((Callable)new ApprovedCredits$callable$createForYearInterval(curricularPeriodConfiguration, bigDecimal, n, n2)));
    }

    static /* synthetic */ ApprovedCredits advised$createForYearInterval(CurricularPeriodConfiguration configuration, BigDecimal credits, Integer yearMin, Integer yearMax) {
        ApprovedCredits result = new ApprovedCredits();
        result.init(configuration, credits, yearMin, yearMax);
        return result;
    }

    public String getLabel() {
        String label = "label." + ((Object)((Object)this)).getClass().getSimpleName();
        ArrayList args = Lists.newArrayList();
        if (this.isYearless()) {
            args.add(this.getCredits().toString());
        } else {
            int yearMax;
            int yearMin = this.getYearMinFinal();
            if (yearMin == (yearMax = this.getYearMaxFinal())) {
                label = label + ".year";
                args.add(this.getCredits().toString());
                args.add(String.valueOf(yearMin));
            } else {
                label = label + ".years";
                args.add(this.getCredits().toString());
                args.add(String.valueOf(yearMin));
                args.add(String.valueOf(yearMax));
            }
        }
        if (this.getApplyToOptionals() != null) {
            label = label + (this.getApplyToOptionals() != false ? ".applyToOptionals" : ".applyToOptionals.not");
        }
        return BundleUtil.getString((String)MODULE_BUNDLE, (String)label, (String[])args.toArray(new String[0]));
    }

    private boolean isYearless() {
        return this.getYearMin() == null && this.getYearMax() == null;
    }

    private int getYearMinFinal() {
        return this.getYearMin() == null ? 1 : this.getYearMin();
    }

    private int getYearMaxFinal() {
        return this.getYearMax() == null ? this.getConfiguration().getCurricularPeriod().getChildOrder() - 1 : this.getYearMax();
    }

    public RuleResult executeYearless(Curriculum input) {
        Curriculum curriculum = this.prepareCurriculum(input);
        BigDecimal total = curriculum.getSumEctsCredits();
        return total.compareTo(this.getCredits()) >= 0 ? this.createTrue() : this.createFalseLabelled(total);
    }

    public RuleResult execute(Curriculum input) {
        int yearMax;
        if (this.isYearless()) {
            return this.executeYearless(input);
        }
        Curriculum curriculum = this.prepareCurriculum(input);
        int yearMin = this.getYearMinFinal();
        Set configured = this.getCurricularPeriodsConfigured(yearMin, yearMax = this.getYearMaxFinal(), false);
        if (configured == null) {
            return this.createFalseConfiguration();
        }
        BigDecimal total = this.calculateTotalApproved(curriculum, configured);
        return total.compareTo(this.getCredits()) >= 0 ? this.createTrue() : this.createFalseLabelled(total);
    }

    private BigDecimal calculateTotalApproved(Curriculum curriculum, Set<CurricularPeriod> configured) {
        BigDecimal result = BigDecimal.ZERO;
        Map<CurricularPeriod, BigDecimal> curricularPeriodCredits = CurricularPeriodServices.mapYearCredits((ICurriculum)curriculum, this.getApplyToOptionals());
        Set<CurricularPeriod> toInspect = configured.isEmpty() ? curricularPeriodCredits.keySet() : configured;
        for (CurricularPeriod curricularPeriod : toInspect) {
            BigDecimal approved = curricularPeriodCredits.get(curricularPeriod) != null ? curricularPeriodCredits.get(curricularPeriod) : BigDecimal.ZERO;
            result = result.add(approved);
        }
        return result;
    }
}

