/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.curricularPeriod;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodRule$callable$delete;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodRule_Base;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.AbstractCurricularRuleExecutorLogic;
import org.fenixedu.academic.domain.degreeStructure.CurricularPeriodServices;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class CurricularPeriodRule
extends CurricularPeriodRule_Base {
    public static final Logger logger;
    protected static String MODULE_BUNDLE;
    public static final Advice advice$delete;

    protected CurricularPeriodRule() {
        this.setHideMessagePrefix(false);
    }

    public String getRuleName() {
        return BundleUtil.getString((String)MODULE_BUNDLE, (String)((Object)((Object)this)).getClass().getName(), (String[])new String[0]);
    }

    public void messagePrefixDisabled() {
        this.setHideMessagePrefix(true);
    }

    public void messagePrefixEnabled() {
        this.setHideMessagePrefix(false);
    }

    public void init(BigDecimal value) {
        this.setValue(value);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getValue() == null) {
            throw new DomainException("error." + ((Object)((Object)this)).getClass().getSimpleName() + ".value.required", new String[0]);
        }
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new CurricularPeriodRule$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(CurricularPeriodRule this_) {
        DomainException.throwWhenDeleteBlocked((Collection)this_.getDeletionBlockers());
        this_.deleteDomainObject();
    }

    public boolean isExecutive() {
        return false;
    }

    protected DegreeModule getDegreeModule() {
        return this.getDegreeCurricularPlan().getRoot();
    }

    public RuleResult createTrue() {
        return RuleResult.createTrue((DegreeModule)this.getDegreeModule());
    }

    public RuleResult createFalseConfiguration() {
        return CurricularPeriodRule.createFalseConfiguration(this.getDegreeModule(), this.getMessagesPrefix());
    }

    public static RuleResult createFalseConfiguration(DegreeModule degreeModule, CurricularPeriodConfiguration configuration) {
        return CurricularPeriodRule.createFalseConfiguration(degreeModule, CurricularPeriodRule.getMessagesPrefix(configuration, true));
    }

    private static RuleResult createFalseConfiguration(DegreeModule degreeModule, String prefix) {
        return AbstractCurricularRuleExecutorLogic.createFalseConfiguration(degreeModule, prefix, "label.enrolmentPeriodRestrictions");
    }

    public RuleResult createFalseLabelled(BigDecimal suffix) {
        return suffix == null ? this.createFalseLabelled() : this.createFalseLabelled(this.getMessagesSuffix("label.CurricularPeriodRule.suffix", suffix.toPlainString()));
    }

    public RuleResult createFalseLabelled() {
        return this.createFalseLabelled("");
    }

    public RuleResult createFalseLabelled(String suffix) {
        String literalMessage = this.getMessagesPrefix() + this.getLabel() + suffix;
        return RuleResult.createFalseWithLiteralMessage((DegreeModule)this.getDegreeModule(), (String)literalMessage);
    }

    public RuleResult createNA() {
        return RuleResult.createNA((DegreeModule)this.getDegreeModule());
    }

    public static String getMessages(RuleResult input) {
        if (input == null || input.getMessages() == null || input.getMessages().isEmpty()) {
            return "-";
        }
        return input.getMessages().stream().filter(i -> !Strings.isNullOrEmpty((String)i.getMessage())).map(i -> i.getMessage()).sorted().collect(Collectors.joining("; "));
    }

    public void copyConfigurationTo(CurricularPeriodRule target) {
        target.setValue(this.getValue());
        target.setHideMessagePrefix(this.getHideMessagePrefix());
        target.setSemester(this.getSemester());
        target.setYearMin(this.getYearMin());
        target.setYearMax(this.getYearMax());
    }

    private String getMessagesPrefix() {
        return CurricularPeriodRule.getMessagesPrefix(this.getConfiguration(), this.getHideMessagePrefix());
    }

    private static String getMessagesPrefix(CurricularPeriodConfiguration configuration, boolean hideMessagePrefix) {
        return hideMessagePrefix || configuration == null ? "" : BundleUtil.getString((String)MODULE_BUNDLE, (String)"label.CurricularPeriodRule.prefix", (String[])new String[]{configuration.getCurricularPeriod().getFullLabel()}) + " ";
    }

    protected String getMessagesSuffix(String key, String ... args) {
        return args == null ? "" : " " + BundleUtil.getString((String)MODULE_BUNDLE, (String)key, (String[])args);
    }

    protected Set<CurricularPeriod> getCurricularPeriodsConfigured(int yearMin, int yearMax, boolean semesterAware) {
        HashSet result = Sets.newHashSet();
        DegreeCurricularPlan dcp = this.getDegreeCurricularPlan();
        for (int i = yearMin; i <= yearMax; ++i) {
            CurricularPeriod curricularPeriod;
            CurricularPeriod curricularPeriod2 = curricularPeriod = semesterAware ? CurricularPeriodServices.getCurricularPeriod(dcp, i, this.getSemester()) : CurricularPeriodServices.getCurricularPeriod(dcp, i);
            if (curricularPeriod == null) {
                return null;
            }
            result.add(curricularPeriod);
        }
        return result;
    }

    public CurricularPeriodRule cloneRule() {
        try {
            Constructor<?> constructor = ((Object)((Object)this)).getClass().getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            CurricularPeriodRule newInstance = (CurricularPeriodRule)((Object)constructor.newInstance(new Object[0]));
            this.copyConfigurationTo(newInstance);
            return newInstance;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract CurricularPeriodConfiguration getConfiguration();

    protected abstract DegreeCurricularPlan getDegreeCurricularPlan();

    public abstract String getLabel();

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(CurricularPeriodRule.class);
        MODULE_BUNDLE = "resources.FenixeduAcademicExtensionsResources";
    }
}

