/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Set;
import org.fenixedu.academic.domain.EnrolmentType_Base;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.bennu.core.domain.Bennu;

public class EnrolmentType
extends EnrolmentType_Base {
    private static final String NORMAL = "NORMAL";
    private static final String FLUNKED = "FLUNKED";

    public EnrolmentType() {
        this.setRoot(Bennu.getInstance());
    }

    public void setCode(String code) {
        if (EnrolmentType.find(code) != null) {
            throw new AcademicExtensionsDomainException("error.EnrolmentType.alreadyExistsTypeWithSameCode", code);
        }
        super.setCode(code);
    }

    public boolean isNormal() {
        return NORMAL.equals(this.getCode());
    }

    public boolean isFlunked() {
        return FLUNKED.equals(this.getCode());
    }

    public static EnrolmentType find(String code) {
        return EnrolmentType.readAll().stream().filter(et -> et.getCode() != null && et.getCode().equals(code)).findFirst().orElse(null);
    }

    public static Set<EnrolmentType> readAll() {
        return Bennu.getInstance().getEnrolmentTypesSet();
    }

    public void delete() {
        this.setRoot(null);
        super.deleteDomainObject();
    }
}

