/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.evaluation.markSheet;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.accessControl.AcademicAuthorizationGroup;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.services.EnrolmentServices;
import org.fenixedu.academic.domain.student.services.StatuteServices;
import org.fenixedu.academic.dto.evaluation.markSheet.MarkBean$callable$updateGrade;
import org.fenixedu.academic.dto.evaluation.markSheet.MarkBean$callable$updateGradeAvailableDate;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;
import org.fenixedu.bennu.IBean;
import org.fenixedu.bennu.core.security.Authenticate;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.GenericChecksumRewriter;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MarkBean
implements IBean,
Comparable<MarkBean> {
    private CompetenceCourseMarkSheet markSheet;
    private Enrolment enrolment;
    private EnrolmentEvaluation evaluation;
    private Integer studentNumber;
    private String studentName;
    private String viewStudentCurriculum;
    private String gradeValue;
    private Grade gradeSuggested;
    private String degreeName;
    private String degreeCode;
    private String shifts;
    private String statutes;
    private LocalDate gradeAvailableDate;
    private String errorMessage;
    private String infoMessage;
    private static Function<MarkBean, Grade> gradeSuggestionCalculator;
    public static final Advice advice$updateGrade;
    public static final Advice advice$updateGradeAvailableDate;

    public MarkBean() {
    }

    public MarkBean(CompetenceCourseMarkSheet markSheet, EnrolmentEvaluation evaluation) {
        this(markSheet, evaluation.getEnrolment());
        this.setEvaluation(evaluation);
        this.setGradeValueSuggested();
        if (!evaluation.isTemporary()) {
            this.setGradeAvailableDate(evaluation.getGradeAvailableDateYearMonthDay().toLocalDate());
        }
    }

    public MarkBean(CompetenceCourseMarkSheet markSheet, Enrolment enrolment) {
        this.setMarkSheet(markSheet);
        this.setEnrolment(enrolment);
        this.setGradeValueSuggested();
        Registration registration = enrolment.getRegistration();
        this.studentNumber = registration.getNumber();
        this.studentName = registration.getName();
        this.degreeName = enrolment.getStudentCurricularPlan().getDegree().getPresentationName().replace("'", " ").replace("\"", " ");
        this.degreeCode = enrolment.getStudentCurricularPlan().getDegree().getCode();
        this.shifts = EnrolmentServices.getShiftsDescription(enrolment, markSheet.getExecutionSemester());
        this.statutes = StatuteServices.getVisibleStatuteTypesDescription(enrolment.getRegistration(), enrolment.getExecutionPeriod()).replace("'", " ").replace("\"", " ");
    }

    public CompetenceCourseMarkSheet getMarkSheet() {
        return this.markSheet;
    }

    public void setMarkSheet(CompetenceCourseMarkSheet input) {
        this.markSheet = input;
    }

    public Enrolment getEnrolment() {
        return this.enrolment;
    }

    public void setEnrolment(Enrolment input) {
        this.enrolment = input;
    }

    public EnrolmentEvaluation getEvaluation() {
        return this.evaluation;
    }

    private void setEvaluation(EnrolmentEvaluation input) {
        this.evaluation = input;
    }

    public Integer getStudentNumber() {
        return this.studentNumber;
    }

    public void setStudentNumber(Integer studentNumber) {
        this.studentNumber = studentNumber;
    }

    public String getStudentName() {
        return this.studentName;
    }

    public void setStudentName(String studentName) {
        this.studentName = studentName;
    }

    public String getViewStudentCurriculum() {
        return this.viewStudentCurriculum;
    }

    public void setViewStudentCurriculum(String input) {
        this.viewStudentCurriculum = input;
    }

    public void updateViewStudentCurriculum(HttpServletRequest request) {
        if (this.getEnrolment() != null && AcademicAuthorizationGroup.get((AcademicOperationType)AcademicOperationType.MANAGE_REGISTRATIONS).isMember(Authenticate.getUser())) {
            String url = "/academicAdministration/viewStudentCurriculum.do?method=prepare&registrationOID=" + this.getEnrolment().getRegistration().getExternalId();
            String contextPath = request.getContextPath();
            this.viewStudentCurriculum = contextPath + GenericChecksumRewriter.injectChecksumInUrl((String)contextPath, (String)url, (HttpSession)request.getSession());
        }
    }

    private void setGradeValueSuggested() {
        this.setInfoMessage(null);
        Grade current = this.evaluation == null ? Grade.createEmptyGrade() : this.evaluation.getGrade();
        String suggestionValue = null;
        Grade suggestion = this.calculateGradeSuggested();
        if (!suggestion.isEmpty() && suggestion.compareTo(current) != 0) {
            suggestionValue = suggestion.getValue();
            this.setInfoMessage(AcademicExtensionsUtil.bundle("info.MarkBean.gradeValue.suggestion", suggestionValue));
        }
        this.setGradeValue(!current.isEmpty() ? current.getValue() : suggestionValue);
    }

    private Grade calculateGradeSuggested() {
        if (this.gradeSuggested == null) {
            this.gradeSuggested = gradeSuggestionCalculator != null ? gradeSuggestionCalculator.apply(this) : Grade.createEmptyGrade();
        }
        return this.gradeSuggested;
    }

    public String getGradeValue() {
        return this.gradeValue;
    }

    public void setGradeValue(String input) {
        this.gradeValue = input;
        this.cleanupGrade();
    }

    private void cleanupGrade() {
        if (!StringUtils.isBlank((String)this.gradeValue)) {
            this.gradeValue = this.gradeValue.replaceAll("\\s+", "").toUpperCase();
        }
        this.gradeValue = NumberUtils.isNumber((String)this.gradeValue) ? this.cleanupNumber(this.gradeValue) : this.gradeValue;
    }

    private String cleanupNumber(String toCleanup) {
        Double parsedValue = Double.valueOf(toCleanup);
        return parsedValue % 1.0 == 0.0 ? String.valueOf(parsedValue.intValue()) : parsedValue.toString();
    }

    public String getDegreeName() {
        return this.degreeName;
    }

    public void setDegreeName(String degreeName) {
        this.degreeName = degreeName;
    }

    public String getDegreeCode() {
        return this.degreeCode;
    }

    public void setDegreeCode(String degreeCode) {
        this.degreeCode = degreeCode;
    }

    public String getShifts() {
        return this.shifts;
    }

    public void setShifts(String shifts) {
        this.shifts = shifts;
    }

    public String getStatutes() {
        return this.statutes;
    }

    public void setStatutes(String statutes) {
        this.statutes = statutes;
    }

    public LocalDate getGradeAvailableDate() {
        return this.gradeAvailableDate;
    }

    public void setGradeAvailableDate(LocalDate input) {
        this.gradeAvailableDate = input;
    }

    @Override
    public int compareTo(MarkBean o) {
        return CompetenceCourseMarkSheet.COMPARATOR_FOR_STUDENT_NAME.compare(this.getStudentName(), o.getStudentName());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getInfoMessage() {
        return this.infoMessage;
    }

    public void setInfoMessage(String input) {
        this.infoMessage = input;
    }

    public void validate() {
        this.cleanupGrade();
        this.validateGrade();
    }

    private void validateGrade() {
        if (this.hasGradeValue()) {
            if (!this.getMarkSheet().isGradeValueAccepted(this.getGradeValue())) {
                this.setErrorMessage(AcademicExtensionsUtil.bundle("error.MarkBean.gradeValue.does.not.belong.to.scale", this.getGradeScale().getDescription()));
            } else {
                CompetenceCourseMarkSheet evaluationMarkSheet;
                EnrolmentEvaluation evaluation = this.findEnrolmentEvaluation();
                if (evaluation != null && (evaluationMarkSheet = evaluation.getCompetenceCourseMarkSheet()) != null && evaluationMarkSheet != this.getMarkSheet()) {
                    this.setErrorMessage(AcademicExtensionsUtil.bundle("error.MarkBean.evaluation.already.edited", this.getGradeScale().getDescription()));
                }
            }
        }
    }

    public boolean hasGradeValue() {
        return !StringUtils.isBlank((String)this.getGradeValue());
    }

    private GradeScale getGradeScale() {
        return this.getMarkSheet().getGradeScale();
    }

    private EvaluationSeason getEvaluationSeason() {
        return this.getMarkSheet().getEvaluationSeason();
    }

    public void updateGrade() {
        Object object = advice$updateGrade.perform((Callable)new MarkBean$callable$updateGrade(this));
    }

    static /* synthetic */ void advised$updateGrade(MarkBean this_) {
        if (!this_.getMarkSheet().isEdition()) {
            throw new AcademicExtensionsDomainException("error.MarkBean.markSheet.not.edition", new String[0]);
        }
        EnrolmentEvaluation evaluation = this_.findEnrolmentEvaluation();
        if (evaluation == null) {
            if (this_.hasGradeValue()) {
                CompetenceCourseMarkSheet.setEnrolmentEvaluationData(this_.getMarkSheet(), new EnrolmentEvaluation(this_.getEnrolment(), this_.getEvaluationSeason()), this_.getGradeValue(), this_.getGradeScale());
            }
        } else if (!this_.hasGradeValue()) {
            CompetenceCourseMarkSheet.removeEnrolmentEvaluationData(evaluation);
        } else {
            CompetenceCourseMarkSheet.setEnrolmentEvaluationData(this_.getMarkSheet(), evaluation, this_.getGradeValue(), this_.getGradeScale());
        }
    }

    private EnrolmentEvaluation findEnrolmentEvaluation() {
        if (this.getEvaluation() != null) {
            return this.getEvaluation();
        }
        CompetenceCourseMarkSheet markSheet = this.getMarkSheet();
        Optional foundEvaluation = this.getEnrolment().getEnrolmentEvaluation(markSheet.getEvaluationSeason(), markSheet.getExecutionSemester(), Boolean.valueOf(false));
        return foundEvaluation.isPresent() ? (EnrolmentEvaluation)foundEvaluation.get() : null;
    }

    public void updateGradeAvailableDate() {
        Object object = advice$updateGradeAvailableDate.perform((Callable)new MarkBean$callable$updateGradeAvailableDate(this));
    }

    static /* synthetic */ void advised$updateGradeAvailableDate(MarkBean this_) {
        EnrolmentEvaluation evaluation = this_.findEnrolmentEvaluation();
        if (evaluation != null && this_.getGradeAvailableDate() != null && !evaluation.getGradeAvailableDateYearMonthDay().equals((Object)this_.getGradeAvailableDate()) && this_.getMarkSheet().getEvaluationDate().isBefore((ReadablePartial)this_.getGradeAvailableDate())) {
            evaluation.setGradeAvailableDateYearMonthDay(new YearMonthDay((Object)this_.getGradeAvailableDate()));
        }
    }

    public static void setGradeSuggestionCalculator(Function<MarkBean, Grade> gradeSuggestionCalculator) {
        MarkBean.gradeSuggestionCalculator = gradeSuggestionCalculator;
    }

    static {
        advice$updateGrade = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$updateGradeAvailableDate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        gradeSuggestionCalculator = bean -> Grade.createEmptyGrade();
    }
}

