/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.services;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.StatuteType;

public class StatuteServices {
    public static Collection<StatuteType> findStatuteTypes(Registration registration, ExecutionInterval executionInterval) {
        if (executionInterval instanceof ExecutionYear) {
            return StatuteServices.findStatuteTypes(registration, (ExecutionYear)executionInterval);
        }
        if (executionInterval instanceof ExecutionSemester) {
            return StatuteServices.findStatuteTypes(registration, (ExecutionSemester)executionInterval);
        }
        return Collections.emptySet();
    }

    private static Collection<StatuteType> findStatuteTypes(Registration registration, ExecutionYear executionYear) {
        HashSet result = Sets.newHashSet();
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            result.addAll(StatuteServices.findStatuteTypes(registration, executionSemester));
        }
        return result;
    }

    private static Collection<StatuteType> findStatuteTypes(Registration registration, ExecutionSemester executionSemester) {
        return registration.getStudent().getStudentStatutesSet().stream().filter(s -> s.isValidInExecutionPeriod(executionSemester) && (s.getRegistration() == null || s.getRegistration() == registration)).map(s -> s.getType()).collect(Collectors.toSet());
    }

    public static String getVisibleStatuteTypesDescription(Registration registration, ExecutionSemester executionSemester) {
        return StatuteServices.findVisibleStatuteTypes(registration, executionSemester).stream().map(s -> s.getName().getContent()).distinct().collect(Collectors.joining(", "));
    }

    public static Collection<StatuteType> findVisibleStatuteTypes(Registration registration, ExecutionSemester executionSemester) {
        return StatuteServices.findStatuteTypes(registration, executionSemester).stream().filter(s -> s.getVisible()).collect(Collectors.toSet());
    }
}

