/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.mobility;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.SchoolPeriodDuration;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.CountryUnit;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.mobility.MobilityActivityType;
import org.fenixedu.academic.domain.student.mobility.MobilityProgramType;
import org.fenixedu.academic.domain.student.mobility.MobilityProgrammeLevel;
import org.fenixedu.academic.domain.student.mobility.MobilityRegistrationInformation$callable$delete;
import org.fenixedu.academic.domain.student.mobility.MobilityRegistrationInformation$callable$markAsMainInformation;
import org.fenixedu.academic.domain.student.mobility.MobilityRegistrationInformation_Base;
import org.fenixedu.academic.domain.student.mobility.MobilityScientificArea;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MobilityRegistrationInformation
extends MobilityRegistrationInformation_Base {
    private static final Comparator<MobilityRegistrationInformation> COMPARATOR_BY_BEGIN;
    private static final Comparator<MobilityRegistrationInformation> COMPARATOR_BY_BEGIN_DATE;
    public static final Comparator<MobilityRegistrationInformation> COMPARATOR_BY_MOST_RECENT;
    public static final Advice advice$delete;
    public static final Advice advice$markAsMainInformation;

    protected MobilityRegistrationInformation() {
        this.setBennu(Bennu.getInstance());
    }

    public static MobilityRegistrationInformation createOutgoing(Registration registration, boolean national, SchoolPeriodDuration programDuration, ExecutionSemester begin, ExecutionSemester end, LocalDate beginDate, LocalDate endDate, MobilityActivityType mobilityActivityType, MobilityProgramType mobilityProgramType, CountryUnit countryUnit, Unit foreignInstitutionUnit, String remarks) {
        MobilityRegistrationInformation result = new MobilityRegistrationInformation();
        result.setRegistration(registration);
        result.editOutgoing(national, programDuration, begin, end, beginDate, endDate, mobilityActivityType, mobilityProgramType, countryUnit, foreignInstitutionUnit, remarks);
        return result;
    }

    public static MobilityRegistrationInformation createIncoming(Registration registration, boolean national, SchoolPeriodDuration programDuration, ExecutionSemester begin, ExecutionSemester end, LocalDate beginDate, LocalDate endDate, MobilityActivityType mobilityActivityType, MobilityProgramType mobilityProgramType, CountryUnit countryUnit, Unit foreignInstitutionUnit, String remarks, MobilityProgrammeLevel originMobilityProgrammeLevel, String otherOriginMobilityProgrammeLevel, boolean degreeBased, DegreeCurricularPlan degreeCurricularPlan, CourseGroup branchCourseGroup, MobilityScientificArea mobilityScientificArea, MobilityProgrammeLevel incomingMobilityProgrammeLevel, String otherIncomingMobilityProgrammeLevel) {
        MobilityRegistrationInformation result = new MobilityRegistrationInformation();
        result.setRegistration(registration);
        result.editIncoming(national, programDuration, begin, end, beginDate, endDate, mobilityActivityType, mobilityProgramType, countryUnit, foreignInstitutionUnit, remarks, originMobilityProgrammeLevel, otherOriginMobilityProgrammeLevel, degreeBased, degreeCurricularPlan, branchCourseGroup, mobilityScientificArea, incomingMobilityProgrammeLevel, otherIncomingMobilityProgrammeLevel);
        return result;
    }

    public void editOutgoing(boolean national, SchoolPeriodDuration programDuration, ExecutionSemester begin, ExecutionSemester end, LocalDate beginDate, LocalDate endDate, MobilityActivityType mobilityActivityType, MobilityProgramType mobilityProgramType, CountryUnit countryUnit, Unit foreignInstitutionUnit, String remarks) {
        this.setIncoming(false);
        this.setNational(national);
        this.setProgramDuration(programDuration);
        this.setBegin(begin);
        this.setEnd(end);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.setMobilityActivityType(mobilityActivityType);
        this.setMobilityProgramType(mobilityProgramType);
        this.setCountryUnit(countryUnit);
        this.setForeignInstitutionUnit(foreignInstitutionUnit);
        this.setRemarks(remarks);
        this.checkRules();
        this.checkRulesForOutgoing();
    }

    public void editIncoming(boolean national, SchoolPeriodDuration programDuration, ExecutionSemester begin, ExecutionSemester end, LocalDate beginDate, LocalDate endDate, MobilityActivityType mobilityActivityType, MobilityProgramType mobilityProgramType, CountryUnit countryUnit, Unit foreignInstitutionUnit, String remarks, MobilityProgrammeLevel originMobilityProgrammeLevel, String otherOriginMobilityProgrammeLevel, boolean degreeBased, DegreeCurricularPlan degreeCurricularPlan, CourseGroup branchCourseGroup, MobilityScientificArea mobilityScientificArea, MobilityProgrammeLevel incomingMobilityProgrammeLevel, String otherIncomingMobilityProgrammeLevel) {
        this.setIncoming(true);
        this.setNational(national);
        this.setProgramDuration(programDuration);
        this.setBegin(begin);
        this.setEnd(end);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.setMobilityActivityType(mobilityActivityType);
        this.setMobilityProgramType(mobilityProgramType);
        this.setCountryUnit(countryUnit);
        this.setForeignInstitutionUnit(foreignInstitutionUnit);
        this.setRemarks(remarks);
        this.setOriginMobilityProgrammeLevel(originMobilityProgrammeLevel);
        this.setOtherOriginMobilityProgrammeLevel(otherOriginMobilityProgrammeLevel);
        this.setDegreeBased(degreeBased);
        if (degreeBased) {
            this.setDegree(degreeCurricularPlan != null ? degreeCurricularPlan.getDegree() : null);
            this.setDegreeCurricularPlan(degreeCurricularPlan);
            this.setBranchCourseGroup(branchCourseGroup);
            this.setMobilityScientificArea(null);
            this.setIncomingMobilityProgrammeLevel(null);
            this.setOtherIncomingMobilityProgrammeLevel(null);
        } else {
            this.setDegree(null);
            this.setDegreeCurricularPlan(null);
            this.setBranchCourseGroup(null);
            this.setMobilityScientificArea(mobilityScientificArea);
            this.setIncomingMobilityProgrammeLevel(incomingMobilityProgrammeLevel);
            this.setOtherIncomingMobilityProgrammeLevel(otherIncomingMobilityProgrammeLevel);
        }
        this.checkRules();
        this.checkRulesForIncoming();
    }

    private void checkRules() {
        if (this.getRegistration() == null) {
            throw new AcademicExtensionsDomainException("error.MobilityRegistrationInformation.registration.required", new String[0]);
        }
        if (this.getBegin() == null) {
            throw new AcademicExtensionsDomainException("error.MobilityRegistrationInformation.begin.required", new String[0]);
        }
        if (this.getEnd() == null) {
            throw new AcademicExtensionsDomainException("error.MobilityRegistrationInformation.end.required", new String[0]);
        }
        if (this.getBegin().isAfter(this.getEnd())) {
            throw new AcademicExtensionsDomainException("error.MobilityRegistrationInformation.end.must.be.after.begin", new String[0]);
        }
        if (this.getBegin().getExecutionYear().isBefore(this.getRegistration().getStartExecutionYear()) || this.getEnd().getExecutionYear().isBefore(this.getRegistration().getStartExecutionYear())) {
            throw new AcademicExtensionsDomainException("error.MobilityRegistrationInformation.begin.and.end.must.be.after.registration.begin", new String[0]);
        }
        if (this.getMobilityProgramType() == null) {
            throw new AcademicExtensionsDomainException("error.MobilityRegistrationInformation.mobilityProgramType.required", new String[0]);
        }
        if (this.getMobilityActivityType() == null) {
            throw new AcademicExtensionsDomainException("error.MobilityRegistrationInformation.mobilityActivityType.required", new String[0]);
        }
        this.checkOverlaps();
    }

    private void checkOverlaps() {
        for (MobilityRegistrationInformation information : MobilityRegistrationInformation.findAll(this.getRegistration())) {
            if (information == this) continue;
            if (information.getBegin() == null || information.getEnd() == null) {
                throw new AcademicExtensionsDomainException("error.MobilityRegistrationInformation.period.overlaps", new String[0]);
            }
            if (this.getBegin().isAfter(information.getEnd()) || this.getEnd().isBefore(information.getBegin())) continue;
            throw new AcademicExtensionsDomainException("error.MobilityRegistrationInformation.period.overlaps", new String[0]);
        }
    }

    protected void checkRulesForOutgoing() {
        if (this.getCountryUnit() == null) {
            throw new AcademicExtensionsDomainException("error.MobilityRegistrationInformation.countryUnit.required", new String[0]);
        }
        if (this.getForeignInstitutionUnit() == null) {
            throw new AcademicExtensionsDomainException("error.MobilityRegistrationInformation.foreignInstitutionUnit.required", new String[0]);
        }
    }

    private void checkRulesForIncoming() {
        if (this.getProgramDuration() == null) {
            throw new AcademicExtensionsDomainException("error.MobilityRegistrationInformation.programDuration.required", new String[0]);
        }
        if (this.getDegreeBased()) {
            if (this.getDegree() == null) {
                throw new AcademicExtensionsDomainException("error.MobilityRegistrationInformation.degree.required", new String[0]);
            }
            if (this.getDegreeCurricularPlan() == null) {
                throw new AcademicExtensionsDomainException("error.MobilityRegistrationInformation.degreeCurricularPlan.required", new String[0]);
            }
        } else {
            if (this.getMobilityScientificArea() == null) {
                throw new AcademicExtensionsDomainException("error.MobilityRegistrationInformation.mobilityScientificArea.required", new String[0]);
            }
            if (this.getIncomingMobilityProgrammeLevel() == null) {
                throw new AcademicExtensionsDomainException("error.MobilityRegistrationInformation.incomingMobilityProgrammeLevel.required", new String[0]);
            }
        }
        if (this.getOriginMobilityProgrammeLevel() == null) {
            throw new AcademicExtensionsDomainException("error.MobilityRegistrationInformation.originMobilityProgrammeLevel.required", new String[0]);
        }
    }

    public boolean isDeletable() {
        return true;
    }

    public boolean isIncoming() {
        return this.getIncoming();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new MobilityRegistrationInformation$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(MobilityRegistrationInformation this_) {
        this_.setRegistration(null);
        this_.setBegin(null);
        this_.setEnd(null);
        this_.setMobilityProgramType(null);
        this_.setMobilityActivityType(null);
        this_.setCountryUnit(null);
        this_.setForeignInstitutionUnit(null);
        this_.setMobilityScientificArea(null);
        this_.setIncomingMobilityProgrammeLevel(null);
        this_.setOriginMobilityProgrammeLevel(null);
        this_.setDegree(null);
        this_.setDegreeCurricularPlan(null);
        this_.setBranchCourseGroup(null);
        this_.setBennu(null);
        this_.deleteDomainObject();
    }

    public Country getCountry() {
        return this.getCountryUnit() != null ? Country.readByTwoLetterCode((String)this.getCountryUnit().getAcronym()) : this.getCountryByForeignInstitutionUnit();
    }

    @Deprecated
    private Country getCountryByForeignInstitutionUnit() {
        if (this.getForeignInstitutionUnit() == null) {
            return null;
        }
        Collection parentParties = this.getForeignInstitutionUnit().getParentParties(AccountabilityTypeEnum.GEOGRAPHIC, CountryUnit.class);
        if (parentParties.size() > 1) {
            throw new AcademicExtensionsDomainException("error.MobilityRegistrationInformation.found.more.than.one.parent.country.of.foreign.unit", new String[0]);
        }
        if (parentParties.size() == 1) {
            if (((CountryUnit)parentParties.iterator().next()).getCountry() != null) {
                return ((CountryUnit)parentParties.iterator().next()).getCountry();
            }
            if (!Strings.isNullOrEmpty((String)((CountryUnit)parentParties.iterator().next()).getAcronym())) {
                return Country.readByTwoLetterCode((String)((CountryUnit)parentParties.iterator().next()).getAcronym());
            }
        }
        return null;
    }

    public boolean hasCountry() {
        return this.getCountry() != null;
    }

    public boolean isIncomingStudent() {
        return this.getIncoming();
    }

    public LocalizedString getMobilityStudentTypeDescription() {
        if (this.isIncomingStudent()) {
            return AcademicExtensionsUtil.bundleI18N("label.MobilityRegistrationInformationBean.incomingStudent", new String[0]);
        }
        return AcademicExtensionsUtil.bundleI18N("label.MobilityRegistrationInformationBean.outgoingStudent", new String[0]);
    }

    public boolean isValid(ExecutionYear executionYear) {
        if (this.getBegin() == null || this.getEnd() == null) {
            return true;
        }
        return !executionYear.isAfter(this.getEnd().getExecutionYear()) && !executionYear.isBefore(this.getBegin().getExecutionYear());
    }

    private boolean isBeforeOrEquals(ExecutionYear executionYear) {
        if (this.getBegin() == null || this.getEnd() == null) {
            return true;
        }
        return this.getEnd().getExecutionYear().isBeforeOrEquals(executionYear);
    }

    public void markAsMainInformation() {
        Object object = advice$markAsMainInformation.perform((Callable)new MobilityRegistrationInformation$callable$markAsMainInformation(this));
    }

    static /* synthetic */ void advised$markAsMainInformation(MobilityRegistrationInformation this_) {
        this_.getRegistration().getMobilityRegistrationInformationsSet().stream().filter(m -> m.isIncoming() == this.isIncoming() && m.getNational() == this.getNational()).forEach(m -> m.setMainInformation(false));
        this_.setMainInformation(true);
    }

    public static Set<MobilityRegistrationInformation> findAll(Registration registration) {
        return registration.getMobilityRegistrationInformationsSet();
    }

    public static boolean hasAnyInternationalOutgoingMobility(Registration registration) {
        return MobilityRegistrationInformation.hasAnyInternationalOutgoingMobilityUntil(registration, null);
    }

    public static boolean hasAnyInternationalOutgoingMobilityUntil(Registration registration, ExecutionYear until) {
        return registration.getMobilityRegistrationInformationsSet().stream().filter(m -> until == null || m.isBeforeOrEquals(until)).anyMatch(m -> !m.isIncoming() && !m.getNational());
    }

    public static MobilityRegistrationInformation findMainInternationalOutgoingInformation(Registration registration) {
        return MobilityRegistrationInformation.findMainInternationalOutgoingInformationUntil(registration, null);
    }

    public static MobilityRegistrationInformation findMainInternationalOutgoingInformationUntil(Registration registration, ExecutionYear until) {
        return MobilityRegistrationInformation.findInternationalOutgoingInformationsUntil(registration, until).stream().filter(m -> m.getMainInformation()).findFirst().orElse(null);
    }

    public static Collection<MobilityRegistrationInformation> findInternationalOutgoingInformations(Registration registration) {
        return MobilityRegistrationInformation.findInternationalOutgoingInformationsUntil(registration, null);
    }

    public static Collection<MobilityRegistrationInformation> findInternationalOutgoingInformationsUntil(Registration registration, ExecutionYear until) {
        return registration.getMobilityRegistrationInformationsSet().stream().filter(m -> (until == null || m.isBeforeOrEquals(until)) && !m.isIncoming() && !m.getNational()).collect(Collectors.toSet());
    }

    public static MobilityRegistrationInformation findInternationalIncomingInformation(Registration registration, ExecutionYear executionYear) {
        return registration.getMobilityRegistrationInformationsSet().stream().filter(m -> m.isIncoming() && !m.getNational() && m.isValid(executionYear)).sorted(COMPARATOR_BY_MOST_RECENT).findFirst().orElse(null);
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$markAsMainInformation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_BEGIN = (x, y) -> {
            if (x.getBegin() != null && y.getBegin() != null) {
                return x.getBegin().compareTo(y.getBegin());
            }
            if (x.getBegin() == null && y.getBegin() == null) {
                return 0;
            }
            return x.getBegin() != null ? 1 : 0;
        };
        COMPARATOR_BY_BEGIN_DATE = (x, y) -> {
            if (x.getBeginDate() != null && y.getBeginDate() != null) {
                return x.getBeginDate().compareTo((ReadablePartial)y.getBeginDate());
            }
            if (x.getBeginDate() == null && y.getBeginDate() == null) {
                return 0;
            }
            return x.getBeginDate() != null ? 1 : 0;
        };
        COMPARATOR_BY_MOST_RECENT = COMPARATOR_BY_BEGIN.thenComparing(COMPARATOR_BY_BEGIN_DATE).thenComparing(DomainObjectUtil.COMPARATOR_BY_ID).reversed();
    }
}

