/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.gradingTable;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.fenixedu.academic.domain.student.gradingTable.GradingTable;

public class GradingTableGenerator {
    public static void defaultData(GradingTable table) {
        table.addMark("10.0", "E");
        table.addMark("11.0", "E");
        table.addMark("12.0", "D");
        table.addMark("13.0", "D");
        table.addMark("14.0", "C");
        table.addMark("15.0", "C");
        table.addMark("16.0", "B");
        table.addMark("17.0", "B");
        table.addMark("18.0", "A");
        table.addMark("19.0", "A");
        table.addMark("20.0", "A");
    }

    public static void generateTableData(GradingTable table, List<BigDecimal> sample) {
        LinkedHashMap<BigDecimal, Integer> gradeDistro = new LinkedHashMap<BigDecimal, Integer>();
        LinkedHashMap<BigDecimal, BigDecimal> heapedGradeDistro = new LinkedHashMap<BigDecimal, BigDecimal>();
        BigDecimal sampleSize = new BigDecimal(sample.size());
        gradeDistro.put(new BigDecimal("10.0"), 0);
        gradeDistro.put(new BigDecimal("11.0"), 0);
        gradeDistro.put(new BigDecimal("12.0"), 0);
        gradeDistro.put(new BigDecimal("13.0"), 0);
        gradeDistro.put(new BigDecimal("14.0"), 0);
        gradeDistro.put(new BigDecimal("15.0"), 0);
        gradeDistro.put(new BigDecimal("16.0"), 0);
        gradeDistro.put(new BigDecimal("17.0"), 0);
        gradeDistro.put(new BigDecimal("18.0"), 0);
        gradeDistro.put(new BigDecimal("19.0"), 0);
        gradeDistro.put(new BigDecimal("20.0"), 0);
        for (BigDecimal bigDecimal : sample) {
            BigDecimal bigDecimal2 = bigDecimal.setScale(1);
            gradeDistro.put(bigDecimal2, (Integer)gradeDistro.get(bigDecimal2) + 1);
        }
        BigDecimal heap = BigDecimal.ZERO;
        for (Map.Entry entry : gradeDistro.entrySet()) {
            BigDecimal grade = (BigDecimal)entry.getKey();
            BigDecimal count = new BigDecimal((Integer)entry.getValue());
            BigDecimal share = count.divide(sampleSize, 5, 6);
            heap = heap.add(share);
            heapedGradeDistro.put(grade, heap.setScale(3, 6));
        }
        GradeDistributionConverter gradeDistributionConverter = new GradeDistributionConverter();
        Map<BigDecimal, String> map = gradeDistributionConverter.process(heapedGradeDistro);
        for (BigDecimal mark : map.keySet()) {
            table.addMark(mark, map.get(mark));
        }
    }

    private static class GradeDistributionConverter {
        private Map<String, BigDecimal> distro = new LinkedHashMap<String, BigDecimal>();
        private static String[] ectsGrades = new String[]{"E", "D", "C", "B", "A"};
        private int gradePointer = 0;

        GradeDistributionConverter() {
            this.distro.put("E", new BigDecimal("0.10"));
            this.distro.put("D", new BigDecimal("0.35"));
            this.distro.put("C", new BigDecimal("0.65"));
            this.distro.put("B", new BigDecimal("0.90"));
            this.distro.put("A", new BigDecimal("1.00"));
        }

        Map<BigDecimal, String> process(Map<BigDecimal, BigDecimal> heapedGradeDistro) {
            LinkedHashMap<BigDecimal, String> tableMap = new LinkedHashMap<BigDecimal, String>();
            boolean firstCycle = true;
            BigDecimal previousHeap = BigDecimal.ZERO;
            for (Map.Entry<BigDecimal, BigDecimal> tuple : heapedGradeDistro.entrySet()) {
                if (firstCycle) {
                    if (tuple.getValue().compareTo(this.distro.get(ectsGrades[this.gradePointer]).multiply(new BigDecimal(2))) >= 0) {
                        ++this.gradePointer;
                    }
                    tableMap.put(tuple.getKey(), ectsGrades[this.gradePointer]);
                    previousHeap = tuple.getValue();
                    firstCycle = false;
                    continue;
                }
                if (this.gradePointer == 4) {
                    tableMap.put(tuple.getKey(), ectsGrades[this.gradePointer]);
                    previousHeap = tuple.getValue();
                    continue;
                }
                BigDecimal threshold = this.distro.get(ectsGrades[this.gradePointer]);
                BigDecimal nextThreshold = this.distro.get(ectsGrades[this.gradePointer + 1]);
                if (tuple.getValue().compareTo(nextThreshold) >= 0) {
                    while (tuple.getValue().compareTo(nextThreshold) >= 0 && this.gradePointer < ectsGrades.length - 2) {
                        ++this.gradePointer;
                        nextThreshold = this.distro.get(ectsGrades[this.gradePointer + 1]);
                    }
                    tableMap.put(tuple.getKey(), ectsGrades[++this.gradePointer]);
                } else if (tuple.getValue().compareTo(threshold) >= 0) {
                    BigDecimal higherSeparation;
                    BigDecimal lowerSeparation = threshold.subtract(previousHeap);
                    if (lowerSeparation.compareTo(higherSeparation = tuple.getValue().subtract(threshold)) < 0) {
                        tableMap.put(tuple.getKey(), ectsGrades[++this.gradePointer]);
                    } else if (lowerSeparation.compareTo(higherSeparation) >= 0) {
                        tableMap.put(tuple.getKey(), ectsGrades[this.gradePointer++]);
                    }
                } else {
                    tableMap.put(tuple.getKey(), ectsGrades[this.gradePointer]);
                }
                previousHeap = tuple.getValue();
            }
            return tableMap;
        }
    }
}

