/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.executionPlanning.services;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CurricularYearList;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.OccupationPeriod;
import org.fenixedu.academic.domain.OccupationPeriodReference;
import org.fenixedu.academic.domain.OccupationPeriodType;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.util.date.IntervalTools;
import org.fenixedu.commons.i18n.I18N;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.YearMonthDay;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OccupationPeriodServices {
    private static final Logger logger = LoggerFactory.getLogger(OccupationPeriodServices.class);
    public static Comparator<OccupationPeriod> COMPARATOR = (o1, o2) -> {
        if (o1 != null && o2 != null) {
            return ComparisonChain.start().compare(o1.getPeriodInterval().getStartMillis(), o2.getPeriodInterval().getStartMillis()).compare(o1.getExecutionDegreesSet().size(), o2.getExecutionDegreesSet().size()).compare((Comparable)((Object)o1.getExternalId()), (Comparable)((Object)o2.getExternalId())).result();
        }
        return o1 != null ? -1 : 1;
    };
    private static Comparator<Interval> COMPARATOR_INTERVAL = (x, y) -> x.getStart().compareTo((ReadableInstant)y.getStart());
    private static DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"dd/MM/yyyy").withLocale(I18N.getLocale());
    private static CurricularYearList ALL_CURRICULAR_YEARS = CurricularYearList.internalize((String)"-1");

    private static boolean isValid(OccupationPeriodPartner partner) {
        return partner != null && partner.getOccupationPeriod() != null && partner.getExecutionSemester() != null;
    }

    public static OccupationPeriod createOccupationPeriod(OccupationPeriodPartner partner, LocalDate start, LocalDate end, Set<ExecutionDegree> degrees, OccupationPeriodType periodType) {
        OccupationPeriod result = new OccupationPeriod(OccupationPeriodServices.getInterval(start, end));
        partner.setOccupationPeriod().apply(result);
        OccupationPeriodServices.createReferences(partner, degrees, periodType);
        OccupationPeriodServices.checkRules(result);
        return result;
    }

    private static void checkRules(OccupationPeriod input) {
        Set references = input.getExecutionDegreesSet();
        if (references.isEmpty()) {
            throw new AcademicExtensionsDomainException("error.OccupationPeriod.required.ExecutionDegree", new String[0]);
        }
        ExecutionYear year = ((OccupationPeriodReference)references.iterator().next()).getExecutionDegree().getExecutionYear();
        for (OccupationPeriodReference reference : references) {
            if (reference.getExecutionDegree().getExecutionYear() == year) continue;
            throw new AcademicExtensionsDomainException("error.OccupationPeriod.inconsistent.ExecutionYear", new String[0]);
        }
        if (input.getIntervals().isEmpty()) {
            throw new AcademicExtensionsDomainException("error.OccupationPeriod.required.Interval", new String[0]);
        }
    }

    private static void createReferences(OccupationPeriodPartner partner, Set<ExecutionDegree> degrees, OccupationPeriodType periodType) {
        if (OccupationPeriodServices.isValid(partner) && degrees != null) {
            for (ExecutionDegree degree : degrees) {
                OccupationPeriodServices.createReference(partner, degree, periodType);
            }
        }
    }

    private static OccupationPeriodReference createReference(OccupationPeriodPartner partner, ExecutionDegree degree, OccupationPeriodType periodType) {
        OccupationPeriodReference result = null;
        if (degree != null && periodType != null) {
            int semester = partner.getExecutionSemester().getSemester();
            result = new OccupationPeriodReference(partner.getOccupationPeriod(), degree, periodType, Integer.valueOf(semester), ALL_CURRICULAR_YEARS);
            partner.createdReferenceCleanup().apply(result);
        }
        return result;
    }

    public static void deleteOccupationPeriod(OccupationPeriod occupationPeriod) {
        if (occupationPeriod != null) {
            Iterator iterator = occupationPeriod.getExecutionDegreesSet().iterator();
            while (iterator.hasNext()) {
                OccupationPeriodReference reference = (OccupationPeriodReference)iterator.next();
                iterator.remove();
                reference.delete();
            }
            occupationPeriod.delete();
        }
    }

    public static Set<OccupationPeriodReference> getReferences(OccupationPeriodPartner partner) {
        return !OccupationPeriodServices.isValid(partner) ? Sets.newHashSet() : partner.getOccupationPeriod().getExecutionDegreesSet();
    }

    public static Set<ExecutionDegree> getExecutionDegrees(OccupationPeriodPartner partner) {
        return OccupationPeriodServices.getReferences(partner).stream().filter(i -> i.getExecutionDegree() != null).map(i -> i.getExecutionDegree()).collect(Collectors.toSet());
    }

    public static Set<ExecutionDegree> addDegree(OccupationPeriodPartner partner, ExecutionDegree toAdd) {
        Set<ExecutionDegree> current = OccupationPeriodServices.getExecutionDegrees(partner);
        if (toAdd != null) {
            if (current.contains(toAdd)) {
                return current;
            }
            current.add(toAdd);
            OccupationPeriodServices.editDegrees(partner, current);
        }
        return current;
    }

    public static Set<ExecutionDegree> removeDegree(OccupationPeriodPartner partner, ExecutionDegree toRemove) {
        Set<ExecutionDegree> current = OccupationPeriodServices.getExecutionDegrees(partner);
        if (toRemove != null) {
            if (!current.contains(toRemove)) {
                return current;
            }
            current.remove(toRemove);
            OccupationPeriodServices.editDegrees(partner, current);
        }
        return current;
    }

    private static void editDegrees(OccupationPeriodPartner partner, Set<ExecutionDegree> degrees) {
        Set<OccupationPeriodReference> references = OccupationPeriodServices.getReferences(partner);
        Iterator<OccupationPeriodReference> iterator = references.iterator();
        while (iterator.hasNext()) {
            OccupationPeriodReference reference = iterator.next();
            ExecutionDegree degree = reference.getExecutionDegree();
            if (degrees.contains(degree)) {
                degrees.remove(degree);
                continue;
            }
            iterator.remove();
            reference.delete();
        }
        if (!degrees.isEmpty()) {
            OccupationPeriodServices.createReferences(partner, degrees, OccupationPeriodServices.getOccupationPeriodType(partner));
        }
        OccupationPeriodServices.checkRules(partner.getOccupationPeriod());
    }

    public static void addInterval(OccupationPeriodPartner partner, LocalDate start, LocalDate end) {
        List<Interval> current = OccupationPeriodServices.getIntervals(partner);
        Interval toAdd = OccupationPeriodServices.getInterval(start, end);
        if (toAdd != null) {
            Iterator<Interval> iterator = current.iterator();
            while (iterator.hasNext()) {
                Interval interval = iterator.next();
                if (OccupationPeriodServices.equals(interval, toAdd)) {
                    throw new AcademicExtensionsDomainException("error.OccupationPeriod.duplicate.Interval", OccupationPeriodServices.getIntervalDescription(interval));
                }
                if (current.size() == 1) {
                    if (interval.contains((ReadableInterval)toAdd)) {
                        iterator.remove();
                        break;
                    }
                    if (toAdd.contains((ReadableInterval)interval)) {
                        iterator.remove();
                        break;
                    }
                }
                if (interval.contains((ReadableInstant)toAdd.getStart())) {
                    throw new AcademicExtensionsDomainException("error.OccupationPeriod.inconsistent.Interval.start", OccupationPeriodServices.getIntervalDescription(interval));
                }
                if (!interval.contains((ReadableInstant)toAdd.getEnd())) continue;
                throw new AcademicExtensionsDomainException("error.OccupationPeriod.inconsistent.Interval.end", OccupationPeriodServices.getIntervalDescription(interval));
            }
            current.add(toAdd);
            OccupationPeriodServices.editIntervals(partner, current);
        }
    }

    public static void removeInterval(OccupationPeriodPartner partner, LocalDate start, LocalDate end) {
        List<Interval> current = OccupationPeriodServices.getIntervals(partner);
        Interval toRemove = OccupationPeriodServices.getInterval(start, end);
        if (toRemove != null) {
            Iterator<Interval> iterator = current.iterator();
            while (iterator.hasNext()) {
                Interval interval = iterator.next();
                if (!OccupationPeriodServices.equals(interval, toRemove)) continue;
                iterator.remove();
            }
            if (current.size() == OccupationPeriodServices.getIntervals(partner).size()) {
                throw new AcademicExtensionsDomainException("error.OccupationPeriod.interval.not.found", new String[0]);
            }
            OccupationPeriodServices.editIntervals(partner, current);
        }
    }

    private static void editIntervals(OccupationPeriodPartner partner, List<Interval> intervals) {
        if (intervals.isEmpty()) {
            throw new AcademicExtensionsDomainException("error.OccupationPeriod.required.Interval", new String[0]);
        }
        Collections.sort(intervals, COMPARATOR_INTERVAL);
        OccupationPeriod occupationPeriod = partner.getOccupationPeriod();
        occupationPeriod.editDates(intervals.iterator());
        OccupationPeriodServices.checkRules(occupationPeriod);
    }

    private static boolean equals(Interval o1, Interval o2) {
        return o2.getStart().equals((Object)o1.getStart()) && o2.getEnd().equals((Object)o1.getEnd());
    }

    private static Interval getInterval(LocalDate start, LocalDate end) {
        Interval result = null;
        try {
            result = IntervalTools.getInterval((LocalDate)start, (LocalDate)end);
            result = Interval.parse((String)result.toString());
        }
        catch (Throwable t) {
            result = null;
        }
        return result;
    }

    public static List<Interval> getIntervals(OccupationPeriodPartner partner) {
        return !OccupationPeriodServices.isValid(partner) ? Lists.newArrayList() : partner.getOccupationPeriod().getIntervals();
    }

    public static String getIntervalsDescription(List<Interval> intervals) {
        StringBuilder result = new StringBuilder();
        Collections.sort(intervals, COMPARATOR_INTERVAL);
        Iterator<Interval> iterator = intervals.iterator();
        while (iterator.hasNext()) {
            result.append(OccupationPeriodServices.getIntervalDescription(iterator.next()));
            if (!iterator.hasNext()) continue;
            result.append(" ; ");
        }
        return result.toString();
    }

    private static String getIntervalDescription(Interval interval) {
        StringBuilder result = new StringBuilder();
        result.append(DATE_TIME_FORMATTER.print((ReadableInstant)interval.getStart()));
        result.append(" <-> ");
        result.append(DATE_TIME_FORMATTER.print((ReadableInstant)interval.getEnd()));
        return result.toString();
    }

    private static OccupationPeriodType getOccupationPeriodType(OccupationPeriodPartner partner) {
        Set<OccupationPeriodReference> references = OccupationPeriodServices.getReferences(partner);
        OccupationPeriodType periodType = references.iterator().next().getPeriodType();
        if (!references.stream().allMatch(i -> i.getPeriodType() == periodType)) {
            throw new AcademicExtensionsDomainException("error.OccupationPeriod.inconsistent.PeriodType", new String[0]);
        }
        return periodType;
    }

    public static boolean isContainingDate(OccupationPeriodPartner partner, LocalDate date) {
        return !OccupationPeriodServices.isValid(partner) ? false : partner.getOccupationPeriod().nestedOccupationPeriodsContainsDay(new YearMonthDay((Object)date));
    }

    public static interface OccupationPeriodPartner {
        public OccupationPeriod getOccupationPeriod();

        public ExecutionSemester getExecutionSemester();

        public Function<OccupationPeriod, OccupationPeriod> setOccupationPeriod();

        public Function<OccupationPeriodReference, OccupationPeriodReference> createdReferenceCleanup();
    }
}

