/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.enrolment;

import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.period.AcademicEnrolmentPeriod;
import org.fenixedu.academic.domain.exceptions.DomainException;

public class StudentCurricularPlanEnrolmentManager
extends org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanEnrolmentManager {
    public StudentCurricularPlanEnrolmentManager(EnrolmentContext enrolmentContext) {
        super(enrolmentContext);
    }

    protected void assertEnrolmentPreConditions() {
        if (this.isResponsiblePersonManager()) {
            return;
        }
        this.checkDebts();
        if (this.isResponsiblePersonAllowedToEnrolStudents() || this.isResponsibleInternationalRelationOffice()) {
            this.assertAcademicAdminOfficePreConditions();
        } else if (this.isResponsiblePersonStudent()) {
            this.assertStudentEnrolmentPreConditions();
        } else {
            this.assertOtherRolesPreConditions();
        }
    }

    protected void assertAcademicAdminOfficePreConditions() {
        this.checkEnrolmentWithoutRules();
        if (this.updateRegistrationAfterConclusionProcessPermissionEvaluated()) {
            return;
        }
    }

    protected boolean isResponsiblePersonStudent() {
        return this.getResponsiblePerson().getStudent() != null;
    }

    protected void assertStudentEnrolmentPreConditions() {
        if (!this.getResponsiblePerson().getStudent().getActiveRegistrationsIn(this.getExecutionSemester()).contains(this.getRegistration())) {
            throw new DomainException("error.StudentCurricularPlan.student.is.not.allowed.to.perform.enrol", new String[0]);
        }
        if (this.getCurricularRuleLevel() != CurricularRuleLevel.ENROLMENT_WITH_RULES) {
            throw new DomainException("error.StudentCurricularPlan.invalid.curricular.rule.level", new String[0]);
        }
        if (AcademicEnrolmentPeriod.getEnrolmentPeriodsOpenOrUpcoming(this.getStudent()).stream().noneMatch(i -> i.getDegreeCurricularPlansSet().contains(this.getStudentCurricularPlan().getDegreeCurricularPlan()) && i.getExecutionSemester() == this.getExecutionSemester())) {
            throw new DomainException("message.out.curricular.course.enrolment.period.default", new String[0]);
        }
    }
}

