/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.dml;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.dml.DynamicField;
import org.fenixedu.academic.domain.dml.DynamicFieldDescriptor$callable$create;
import org.fenixedu.academic.domain.dml.DynamicFieldDescriptor$callable$edit;
import org.fenixedu.academic.domain.dml.DynamicFieldDescriptor_Base;
import org.fenixedu.academic.domain.dml.DynamicFieldValueConverter;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DynamicFieldDescriptor
extends DynamicFieldDescriptor_Base {
    private static final String DOMAIN_OBJECT_FIELD_NAME = "DynamicField";
    private static final String DOMAIN_OBJECT_METHOD_NAME_ADD = "addDynamicField";
    private static final String DOMAIN_OBJECT_METHOD_NAME_GET = "getDynamicFieldSet";
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected DynamicFieldDescriptor() {
        this.setRoot(Bennu.getInstance());
    }

    protected void init(Class<? extends DomainObject> domainObjectClass, String code, LocalizedString name, Class fieldValueClass, boolean required, int order) {
        this.setDomainObjectClassName(domainObjectClass == null ? null : domainObjectClass.getName());
        this.setCode(code);
        this.setName(name);
        this.setFieldValueClassName(fieldValueClass == null ? null : fieldValueClass.getName());
        this.setRequired(required);
        this.updateOrder(order);
        this.checkRules(fieldValueClass);
    }

    private void checkRules(Class fieldValueClass) {
        if (Strings.isNullOrEmpty((String)this.getDomainObjectClassName())) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.domainObjectClassName.required");
        }
        if (Strings.isNullOrEmpty((String)this.getCode())) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.code.required");
        }
        Class<? extends DomainObject> domainObjectClass = this.getDomainObjectClass();
        if (domainObjectClass == null) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.domainObjectClass.required");
        }
        DynamicFieldDescriptor.find(domainObjectClass, this.getCode());
        if (this.getName() == null || this.getName().isEmpty()) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.name.required");
        }
        if (Strings.isNullOrEmpty((String)this.getFieldValueClassName())) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.fieldValueClassName.required");
        }
        if (!DynamicFieldValueConverter.isSupported(fieldValueClass)) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.fieldValueClass.unsupported");
        }
        if (this.getRequired() && this.getInstanceSet().stream().anyMatch(i -> Strings.isNullOrEmpty((String)i.getValue()))) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.value.inconsistent");
        }
    }

    public static DynamicFieldDescriptor create(Class<? extends DomainObject> clazz, String string, LocalizedString localizedString, Class clazz2, boolean bl, int n) {
        return (DynamicFieldDescriptor)((Object)advice$create.perform((Callable)new DynamicFieldDescriptor$callable$create(clazz, string, localizedString, clazz2, bl, n)));
    }

    static /* synthetic */ DynamicFieldDescriptor advised$create(Class<? extends DomainObject> domainObjectClass, String code, LocalizedString name, Class fieldValueClass, boolean required, int order) {
        DynamicFieldDescriptor result = new DynamicFieldDescriptor();
        result.init(domainObjectClass, code, name, fieldValueClass, required, order);
        return result;
    }

    public DynamicFieldDescriptor edit(Class<? extends DomainObject> clazz, String string, LocalizedString localizedString, Class clazz2, boolean bl, int n) {
        return (DynamicFieldDescriptor)((Object)advice$edit.perform((Callable)new DynamicFieldDescriptor$callable$edit(this, clazz, string, localizedString, clazz2, bl, n)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ DynamicFieldDescriptor advised$edit(DynamicFieldDescriptor this_, Class domainObjectClass, String code, LocalizedString name, Class fieldValueClass, boolean required, int order) {
        this_.init(domainObjectClass, code, name, fieldValueClass, required, order);
        return this_;
    }

    public static DynamicFieldDescriptor find(Class<? extends DomainObject> domainObjectClass, String code) {
        DynamicFieldDescriptor result = null;
        if (domainObjectClass != null && !Strings.isNullOrEmpty((String)code)) {
            for (DynamicFieldDescriptor iter : Bennu.getInstance().getDynamicFieldDescriptorSet()) {
                if (iter.getDomainObjectClass() != domainObjectClass || !StringUtils.equalsIgnoreCase((String)iter.getCode(), (String)code)) continue;
                if (result != null) {
                    throw new IllegalArgumentException("error.DynamicFieldDescriptor.duplicate");
                }
                result = iter;
            }
        }
        return result;
    }

    public static Set<DynamicFieldDescriptor> find(DomainObject domainObject) {
        HashSet<DynamicFieldDescriptor> result = new HashSet<DynamicFieldDescriptor>();
        if (domainObject != null) {
            for (DynamicFieldDescriptor iter : Bennu.getInstance().getDynamicFieldDescriptorSet()) {
                if (!iter.isFor(domainObject)) continue;
                result.add(iter);
            }
        }
        return result;
    }

    private boolean isFor(DomainObject domainObject) {
        return domainObject != null && this.getDomainObjectClass() == domainObject.getClass();
    }

    private Class<? extends DomainObject> getDomainObjectClass() {
        Class<?> result = null;
        try {
            Class<?> domainClass = Class.forName(this.getDomainObjectClassName());
            result = DomainObject.class.isAssignableFrom(domainClass) ? domainClass : null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    protected DynamicField createField(DomainObject domainObject) {
        DynamicField result = new DynamicField();
        result.setDescriptor(this);
        this.setField(domainObject, result);
        this.findField(domainObject);
        return result;
    }

    protected DynamicField findField(DomainObject domainObject) {
        DynamicField result = null;
        if (this.isFor(domainObject)) {
            try {
                Method method = domainObject.getClass().getMethod(DOMAIN_OBJECT_METHOD_NAME_GET, new Class[0]);
                Set fields = (Set)method.invoke((Object)domainObject, new Object[0]);
                for (DynamicField iter : fields) {
                    if (iter.getDescriptor() != this) continue;
                    if (result != null) {
                        throw new IllegalArgumentException("error.DynamicField.duplicate");
                    }
                    result = iter;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    protected void setField(DomainObject domainObject, DynamicField field) {
        if (this.isFor(domainObject) && this.getInstanceSet().contains((Object)field)) {
            try {
                Method method = domainObject.getClass().getMethod(DOMAIN_OBJECT_METHOD_NAME_ADD, DynamicField.class);
                method.invoke((Object)domainObject, new Object[]{field});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void updateOrder(int order) {
        this.setOrder(order);
    }

    public Class getFieldValueClass() {
        try {
            return Class.forName(this.getFieldValueClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void delete() {
        if (!this.getInstanceSet().isEmpty()) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.cannot.delete.with.field.instances");
        }
        super.setRoot(null);
        super.deleteDomainObject();
    }
}

