/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curriculum.grade;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.curriculum.grade.GradeScaleEntry$callable$delete;
import org.fenixedu.academic.domain.curriculum.grade.GradeScaleEntry_Base;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class GradeScaleEntry
extends GradeScaleEntry_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected GradeScaleEntry() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    private void checkRules() {
        if (this.getGradeScale() == null) {
            throw new AcademicExtensionsDomainException("error.GradeScaleEntry.gradeScale.is.required", new String[0]);
        }
        if (StringUtils.isBlank((String)this.getValue())) {
            throw new AcademicExtensionsDomainException("error.GradeScaleEntry.value.is.required", new String[0]);
        }
        if (this.getDescription() == null || this.getDescription().isEmpty()) {
            throw new AcademicExtensionsDomainException("error.GradeScaleEntry.description.is.required", new String[0]);
        }
    }

    public void edit(GradeScale gradeScale, String value, LocalizedString description, boolean allowsApproval) {
        super.setGradeScale(gradeScale);
        super.setValue(value);
        super.setDescription(description);
        super.setAllowsApproval(allowsApproval);
        this.checkRules();
    }

    public static GradeScaleEntry create(GradeScale gradeScale, String value, LocalizedString description, boolean allowsApproval) {
        GradeScaleEntry result = new GradeScaleEntry();
        result.edit(gradeScale, value, description, allowsApproval);
        return result;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new GradeScaleEntry$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(GradeScaleEntry this_) {
        this_.setRootDomainObject(null);
        this_.deleteDomainObject();
    }

    public static Collection<GradeScaleEntry> findAll() {
        return Bennu.getInstance().getGradeScaleEntriesSet();
    }

    public static Collection<GradeScaleEntry> findBy(GradeScale gradeScale) {
        return GradeScaleEntry.findAll().stream().filter(e -> e.getGradeScale() == gradeScale).collect(Collectors.toSet());
    }
}

