/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import com.google.common.collect.Sets;
import java.util.Set;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.curricularRules.AnyCurricularCourseRestrictions;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnroledOptionalEnrolment;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.enrolment.OptionalDegreeModuleToEnrol;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class AnyCurricularCourseRestrictionsExecutor
extends CurricularRuleExecutor {
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }

    @Deprecated
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return this.executeEnrolmentVerificationWithRules(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
    }

    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        if (!this.canApplyRule(enrolmentContext, curricularRule)) {
            return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        AnyCurricularCourseRestrictions rule = (AnyCurricularCourseRestrictions)curricularRule;
        CurricularCourse curricularCourseToEnrol = AnyCurricularCourseRestrictionsExecutor.getCurricularCourseFromOptional(sourceDegreeModuleToEvaluate);
        if (curricularCourseToEnrol != null && this.isAllowedCourseGroup(rule, curricularCourseToEnrol)) {
            return AnyCurricularCourseRestrictionsExecutor.createResultFalse(rule, sourceDegreeModuleToEvaluate, curricularCourseToEnrol, "curricularRules.ruleExecutors.AnyCurricularCourseRestrictions.only.allowedCourseGroups");
        }
        return RuleResult.createTrue((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    private boolean isAllowedCourseGroup(AnyCurricularCourseRestrictions rule, CurricularCourse curricularCourseToEnrol) {
        return Sets.intersection((Set)rule.getCourseGroupsSet(), (Set)curricularCourseToEnrol.getAllParentCourseGroups()).isEmpty();
    }

    private static CurricularCourse getCurricularCourseFromOptional(IDegreeModuleToEvaluate input) {
        CurricularCourse result = null;
        if (input.isEnroling()) {
            OptionalDegreeModuleToEnrol toEnrol = (OptionalDegreeModuleToEnrol)input;
            result = toEnrol.getCurricularCourse();
        } else if (input.isEnroled()) {
            EnroledOptionalEnrolment enroled = (EnroledOptionalEnrolment)input;
            result = (CurricularCourse)enroled.getCurriculumModule().getDegreeModule();
        }
        return result;
    }

    private static RuleResult createResultFalse(AnyCurricularCourseRestrictions rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, CurricularCourse curricularCourseToEnrol, String messageKey) {
        String message = BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)messageKey, (String[])new String[]{curricularCourseToEnrol.getName(), rule.getDegreeModuleToApplyRule().getName(), rule.getCourseGroupsDescription()});
        return sourceDegreeModuleToEvaluate.isEnroled() ? RuleResult.createImpossibleWithLiteralMessage((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule(), (String)message) : RuleResult.createFalseWithLiteralMessage((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule(), (String)message);
    }
}

