/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.StudentSchoolClassCurricularRule_Base;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.StudentSchoolClassCurricularRuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.dto.GenericPair;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class StudentSchoolClassCurricularRule
extends StudentSchoolClassCurricularRule_Base {
    protected StudentSchoolClassCurricularRule() {
    }

    public StudentSchoolClassCurricularRule(DegreeModule toApplyRule, CourseGroup contextCourseGroup, ExecutionSemester begin, ExecutionSemester end, Boolean schoolClassMustContainCourse, Boolean courseMustHaveFreeShifts, Boolean enrolInShiftIfUnique, Boolean allAvailableShiftsMustBeEnrolled, String schoolClassNames) {
        this();
        this.init(toApplyRule, contextCourseGroup, begin, end, CurricularRuleType.CUSTOM);
        this.setSchoolClassMustContainCourse(schoolClassMustContainCourse);
        this.setCourseMustHaveFreeShifts(courseMustHaveFreeShifts);
        this.setEnrolInShiftIfUnique(enrolInShiftIfUnique);
        this.setAllAvailableShiftsMustBeEnrolled(allAvailableShiftsMustBeEnrolled);
        this.setSchoolClassNames(schoolClassNames);
    }

    public void edit(CourseGroup contextCourseGroup, Boolean schoolClassMustContainCourse, Boolean courseMustHaveFreeShifts, Boolean enrolInShiftIfUnique, Boolean allAvailableShiftsMustBeEnrolled, String schoolClassNames) {
        this.setContextCourseGroup(contextCourseGroup);
        this.setSchoolClassMustContainCourse(schoolClassMustContainCourse);
        this.setCourseMustHaveFreeShifts(courseMustHaveFreeShifts);
        this.setEnrolInShiftIfUnique(enrolInShiftIfUnique);
        this.setAllAvailableShiftsMustBeEnrolled(allAvailableShiftsMustBeEnrolled);
        this.setSchoolClassNames(schoolClassNames);
    }

    public RuleResult evaluate(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return new StudentSchoolClassCurricularRuleExecutor().execute((ICurricularRule)this, sourceDegreeModuleToEvaluate, enrolmentContext);
    }

    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return VerifyRuleExecutor.NULL_VERIFY_EXECUTOR;
    }

    public boolean isVisible() {
        return false;
    }

    protected void removeOwnParameters() {
    }

    public List<GenericPair<Object, Boolean>> getLabel() {
        StringBuilder label = new StringBuilder();
        if (this.getSchoolClassMustContainCourse().booleanValue()) {
            label.append(BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)"label.StudentSchoolClassCurricularRule.schoolClassMustContainCourse", (String[])new String[0]));
        }
        if (this.getCourseMustHaveFreeShifts().booleanValue()) {
            if (label.length() > 0) {
                label.append(", ");
            }
            label.append(BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)"label.StudentSchoolClassCurricularRule.courseMustHaveFreeShifts", (String[])new String[0]));
        }
        if (this.getEnrolInShiftIfUnique().booleanValue()) {
            if (label.length() > 0) {
                label.append(", ");
            }
            label.append(BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)"label.StudentSchoolClassCurricularRule.enrolInShiftIfUnique", (String[])new String[0]));
        }
        if (this.getAllAvailableShiftsMustBeEnrolled().booleanValue()) {
            if (label.length() > 0) {
                label.append(", ");
            }
            label.append(BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)"label.StudentSchoolClassCurricularRule.allAvailableShiftsMustBeEnrolled", (String[])new String[0]));
        }
        if (StringUtils.isNotBlank((String)this.getSchoolClassNames())) {
            if (label.length() > 0) {
                label.append(", ");
            }
            label.append(BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)"label.StudentSchoolClassCurricularRule.schoolClassNames", (String[])new String[]{this.getSchoolClassNames()}));
        }
        if (this.getContextCourseGroup() != null) {
            label.append(", ");
            label.append(BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)"label.inGroup", (String[])new String[0]));
            label.append(" ");
            label.append(this.getContextCourseGroup().getOneFullName());
        }
        return Lists.newArrayList((Object[])new GenericPair[]{new GenericPair((Object)label, (Object)false)});
    }

    public Collection<SchoolClass> getSchoolClasses(ExecutionSemester executionSemester) {
        ExecutionDegree executionDegree;
        if (StringUtils.isNotBlank((String)this.getSchoolClassNames()) && (executionDegree = this.getDegreeModuleToApplyRule().getParentDegreeCurricularPlan().getExecutionDegreeByYear(executionSemester.getExecutionYear())) != null) {
            String[] schoolClassNamesSplitted;
            HashSet<SchoolClass> result = new HashSet<SchoolClass>();
            for (String schoolClassName : schoolClassNamesSplitted = this.getSchoolClassNames().trim().replace(';', '/').replace(',', '/').split("/")) {
                result.addAll(executionDegree.getSchoolClassesSet().stream().filter(sc -> sc.getExecutionPeriod() == executionSemester && schoolClassName.trim().equalsIgnoreCase((String)sc.getEditablePartOfName())).collect(Collectors.toSet()));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public Boolean getSchoolClassMustContainCourse() {
        return super.getSchoolClassMustContainCourse() != null && super.getSchoolClassMustContainCourse() != false;
    }

    public Boolean getCourseMustHaveFreeShifts() {
        return super.getCourseMustHaveFreeShifts() != null && super.getCourseMustHaveFreeShifts() != false;
    }

    public Boolean getEnrolInShiftIfUnique() {
        return super.getEnrolInShiftIfUnique() != null && super.getEnrolInShiftIfUnique() != false;
    }

    public Boolean getAllAvailableShiftsMustBeEnrolled() {
        return super.getAllAvailableShiftsMustBeEnrolled() != null && super.getAllAvailableShiftsMustBeEnrolled() != false;
    }
}

