/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.EnrolmentPeriodRestrictions;
import org.fenixedu.academic.domain.curricularRules.EnrolmentPeriodRestrictionsInitializer$callable$createEnrolmentPeriodRestrictions;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentPeriodRestrictionsExecutorLogic;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.RootCourseGroup;
import org.fenixedu.bennu.core.domain.Bennu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EnrolmentPeriodRestrictionsInitializer {
    private static final Logger logger;
    public static final Advice advice$createEnrolmentPeriodRestrictions;

    public static void init() {
        for (DegreeCurricularPlan degreeCurricularPlan : Bennu.getInstance().getDegreeCurricularPlansSet()) {
            EnrolmentPeriodRestrictionsInitializer.createEnrolmentPeriodRestrictions(degreeCurricularPlan);
        }
        EnrolmentPeriodRestrictionsExecutorLogic.configure();
    }

    private static void createEnrolmentPeriodRestrictions(DegreeCurricularPlan degreeCurricularPlan) {
        Object object = advice$createEnrolmentPeriodRestrictions.perform((Callable)new EnrolmentPeriodRestrictionsInitializer$callable$createEnrolmentPeriodRestrictions(degreeCurricularPlan));
    }

    static /* synthetic */ void advised$createEnrolmentPeriodRestrictions(DegreeCurricularPlan input) {
        RootCourseGroup root = input.getRoot();
        List rules = root.getCurricularRules(CurricularRuleType.ENROLMENT_PERIOD_RESTRICTIONS, (ExecutionYear)null);
        if (rules.isEmpty()) {
            new EnrolmentPeriodRestrictions((DegreeModule)root, EnrolmentPeriodRestrictionsInitializer.getBeginExecutionSemester(input, root));
            logger.info("Created {} for DCP {}", (Object)EnrolmentPeriodRestrictions.class.getSimpleName(), (Object)input.getPresentationName());
        } else if (rules.size() > 1) {
            logger.error("Possible error: found {} {} rules for DCP {}", new Object[]{rules.size(), EnrolmentPeriodRestrictions.class.getSimpleName(), input.getPresentationName()});
        }
    }

    private static ExecutionSemester getBeginExecutionSemester(DegreeCurricularPlan dcp, RootCourseGroup root) {
        Optional first = root.getChildContextsSet().stream().sorted((o1, o2) -> o1.getBeginExecutionPeriod().compareTo(o2.getBeginExecutionPeriod())).findFirst();
        ExecutionSemester result = first.isPresent() ? ((Context)first.get()).getBeginExecutionPeriod() : ExecutionSemester.readFirstExecutionSemester();
        return result;
    }

    static {
        advice$createEnrolmentPeriodRestrictions = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(EnrolmentPeriodRestrictionsInitializer.class);
    }
}

