/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.services.evaluation;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonServices;
import org.fenixedu.academic.dto.evaluation.markSheet.report.CompetenceCourseSeasonReport;
import org.fenixedu.academic.dto.evaluation.markSheet.report.ExecutionCourseSeasonReport;
import org.joda.time.LocalDate;

public abstract class MarkSheetStatusReportService {
    public static List<ExecutionCourseSeasonReport> getReportsForExecutionCourse(ExecutionCourse executionCourse) {
        ArrayList result = Lists.newArrayList();
        for (EvaluationSeason season : EvaluationSeasonServices.findByActive(true).collect(Collectors.toList())) {
            ArrayListMultimap reportsByEvaluationDate = ArrayListMultimap.create();
            for (CompetenceCourseSeasonReport competenceCourseSeasonReport : MarkSheetStatusReportService.iterateCompetenceCourses(executionCourse.getExecutionPeriod(), executionCourse.getCompetenceCourses(), Sets.newHashSet((Object[])new EvaluationSeason[]{season}))) {
                reportsByEvaluationDate.put((Object)competenceCourseSeasonReport.getEvaluationDate(), (Object)competenceCourseSeasonReport);
            }
            for (Map.Entry entry : reportsByEvaluationDate.asMap().entrySet()) {
                ExecutionCourseSeasonReport report = new ExecutionCourseSeasonReport(executionCourse, season, (LocalDate)entry.getKey(), (Collection)entry.getValue());
                if (report.getTotalStudents() <= 0) continue;
                result.add(report);
            }
        }
        return result;
    }

    public static List<CompetenceCourseSeasonReport> getReportsForCompetenceCourses(ExecutionInterval executionInterval) {
        return MarkSheetStatusReportService.getReportsForCompetenceCourses(executionInterval, EvaluationSeasonServices.findByActive(true).collect(Collectors.toSet()));
    }

    public static List<CompetenceCourseSeasonReport> getReportsForCompetenceCourses(ExecutionInterval executionInterval, Set<EvaluationSeason> seasons) {
        ArrayList result = Lists.newArrayList();
        ExecutionSemester semester = (ExecutionSemester)ExecutionInterval.assertExecutionIntervalType(ExecutionSemester.class, (ExecutionInterval)executionInterval);
        Set<CompetenceCourse> toProcess = MarkSheetStatusReportService.collectCompetenceCourses(semester);
        result.addAll(MarkSheetStatusReportService.iterateCompetenceCourses(semester, toProcess, seasons));
        return result;
    }

    private static Set<CompetenceCourse> collectCompetenceCourses(ExecutionSemester semester) {
        HashSet result = Sets.newHashSet();
        for (ExecutionCourse executionCourse : semester.getAssociatedExecutionCoursesSet()) {
            result.addAll(executionCourse.getCompetenceCourses());
        }
        for (EnrolmentEvaluation evaluation : semester.getEnrolmentEvaluationsSet()) {
            result.add(evaluation.getEnrolment().getCurricularCourse().getCompetenceCourse());
        }
        return result;
    }

    private static List<CompetenceCourseSeasonReport> iterateCompetenceCourses(ExecutionSemester semester, Set<CompetenceCourse> toProcess, Set<EvaluationSeason> seasons) {
        ArrayList result = Lists.newArrayList();
        for (CompetenceCourse iter : toProcess) {
            result.addAll(MarkSheetStatusReportService.getReportsForCompetenceCourse(semester, iter, seasons));
        }
        return result;
    }

    public static List<CompetenceCourseSeasonReport> getReportsForCompetenceCourse(ExecutionSemester semester, CompetenceCourse toProcess, Set<EvaluationSeason> seasons) {
        ArrayList result = Lists.newArrayList();
        for (EvaluationSeason season : seasons) {
            MarkSheetStatusReportService.addNonEmptyReport(result, MarkSheetStatusReportService.generateReport(semester, toProcess, season, null));
        }
        return result;
    }

    private static void addNonEmptyReport(List<CompetenceCourseSeasonReport> result, CompetenceCourseSeasonReport report) {
        if (report.getTotalStudents() > 0) {
            result.add(report);
        }
    }

    private static CompetenceCourseSeasonReport generateReport(ExecutionSemester semester, CompetenceCourse toProcess, EvaluationSeason season, LocalDate evaluationDate) {
        CompetenceCourseSeasonReport result = new CompetenceCourseSeasonReport(toProcess, season, semester, evaluationDate);
        AtomicInteger notEvaluatedStudents = new AtomicInteger(0);
        toProcess.getExecutionCoursesByExecutionPeriod((ExecutionInterval)semester).stream().forEach(i -> notEvaluatedStudents.addAndGet(CompetenceCourseMarkSheet.getExecutionCourseEnrolmentsNotInAnyMarkSheet(semester, toProcess, i, season, null, Sets.newHashSet()).size()));
        result.setNotEvaluatedStudents(notEvaluatedStudents.get());
        HashSet enrolments = Sets.newHashSet();
        toProcess.getAssociatedCurricularCoursesSet().stream().forEach(i -> enrolments.addAll(i.getEnrolmentsByAcademicInterval(semester.getAcademicInterval())));
        for (Object evaluation : semester.getEnrolmentEvaluationsSet()) {
            if (evaluation.getEvaluationSeason() != season || evaluation.getEnrolment().getCurricularCourse().getCompetenceCourse() != toProcess) continue;
            enrolments.add(evaluation.getEnrolment());
        }
        int evaluatedStudents = 0;
        for (Enrolment enrolment : enrolments) {
            Optional evaluation = enrolment.getEnrolmentEvaluation(season, semester, (Boolean)null);
            if (!evaluation.isPresent() || ((EnrolmentEvaluation)evaluation.get()).getCompetenceCourseMarkSheet() == null) continue;
            ++evaluatedStudents;
        }
        result.setEvaluatedStudents(evaluatedStudents);
        Supplier<Stream> supplier = () -> CompetenceCourseMarkSheet.findBy(semester, toProcess, null, season, null, null, null, null);
        long markSheetsTotal = supplier.get().count();
        result.setMarksheetsTotal(Long.valueOf(markSheetsTotal).intValue());
        long markSheetsToConfirm = supplier.get().filter(markSheet -> !markSheet.isConfirmed()).count();
        result.setMarksheetsToConfirm(Long.valueOf(markSheetsToConfirm).intValue());
        return result;
    }
}

