/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.evaluation.markSheet.report;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Person;
import org.joda.time.LocalDate;

public abstract class AbstractSeasonReport {
    private EvaluationSeason season;
    private LocalDate evaluationDate;

    protected AbstractSeasonReport(EvaluationSeason season, LocalDate evaluationDate) {
        this.season = season;
        this.evaluationDate = evaluationDate;
    }

    public Set<String> getResponsibleNames() {
        HashSet<String> result = new HashSet<String>();
        for (Person person : this.getResponsibles()) {
            result.add(person.getName());
        }
        return result;
    }

    public Set<String> getResponsibleEmails() {
        HashSet<String> result = new HashSet<String>();
        for (Person person : this.getResponsibles()) {
            if (!person.hasDefaultEmailAddress()) continue;
            result.add(person.getDefaultEmailAddressValue());
        }
        return result;
    }

    public Integer getTotalStudents() {
        return this.getEvaluatedStudents() + this.getNotEvaluatedStudents();
    }

    public EvaluationSeason getSeason() {
        return this.season;
    }

    public LocalDate getEvaluationDate() {
        return this.evaluationDate;
    }

    public abstract Integer getNotEvaluatedStudents();

    public abstract Integer getEvaluatedStudents();

    public abstract Integer getMarksheetsTotal();

    public abstract Integer getMarksheetsToConfirm();

    public abstract Collection<Person> getResponsibles();

    public abstract ExecutionSemester getExecutionSemester();
}

