/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.services;

import java.util.Collection;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.curriculum.EnrollmentState;

public class EnrolmentServices {
    public static void updateState(Enrolment enrolment) {
        if (!enrolment.isAnnulled()) {
            enrolment.setEnrollmentState(EnrolmentServices.calculateState(enrolment));
        }
    }

    public static EnrollmentState calculateState(Enrolment enrolment) {
        Grade finalGrade = enrolment.getGrade();
        return finalGrade.isEmpty() ? EnrollmentState.ENROLLED : finalGrade.getEnrolmentState();
    }

    public static Collection<Shift> getShiftsFor(Enrolment enrolment, ExecutionSemester executionSemester) {
        return enrolment.getRegistration().getShiftsFor(enrolment.getExecutionCourseFor(executionSemester));
    }

    public static String getShiftsDescription(Enrolment enrolment, ExecutionSemester executionSemester) {
        return EnrolmentServices.getShiftsFor(enrolment, executionSemester).stream().map(s -> s.getNome()).collect(Collectors.joining(", "));
    }

    public static boolean containsAnyShift(Enrolment enrolment, ExecutionSemester executionSemester, Collection<Shift> shifts) {
        return EnrolmentServices.getShiftsFor(enrolment, executionSemester).stream().anyMatch(s -> shifts.contains(s));
    }
}

