/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.gradingTable;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.conclusion.RegistrationConclusionInformation;
import org.fenixedu.academic.domain.student.curriculum.conclusion.RegistrationConclusionServices;
import org.fenixedu.academic.domain.student.gradingTable.DegreeGradingTable_Base;
import org.fenixedu.academic.domain.student.gradingTable.GradingTable;
import org.fenixedu.academic.domain.student.gradingTable.GradingTableData;
import org.fenixedu.academic.domain.student.gradingTable.GradingTableGenerator;
import org.fenixedu.academic.domain.student.gradingTable.GradingTableSettings;
import org.fenixedu.academic.domain.student.gradingTable.InstitutionGradingTable;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.fenixframework.CallableWithoutException;

public class DegreeGradingTable
extends DegreeGradingTable_Base {
    public void delete() {
        this.setDegree(null);
        this.setProgramConclusion(null);
        this.setRegistration(null);
        super.delete();
    }

    public static Stream<DegreeGradingTable> findAll() {
        return Bennu.getInstance().getGradingTablesSet().stream().filter(DegreeGradingTable.class::isInstance).map(DegreeGradingTable.class::cast);
    }

    public static Set<DegreeGradingTable> find(ExecutionYear ey) {
        return DegreeGradingTable.find(ey, false);
    }

    public static Set<DegreeGradingTable> find(ExecutionYear ey, boolean includeLegacy) {
        return ey.getGradingTablesSet().stream().filter(DegreeGradingTable.class::isInstance).map(DegreeGradingTable.class::cast).filter(dgt -> includeLegacy || dgt.getRegistration() == null).collect(Collectors.toSet());
    }

    public static DegreeGradingTable find(ExecutionYear ey, ProgramConclusion pc, Degree d) {
        return d.getDegreeGradingTablesSet().stream().filter(dgt -> dgt.getRegistration() == null).filter(dgt -> dgt.getProgramConclusion() == pc).filter(dgt -> dgt.getExecutionYear() == ey).findAny().orElse(null);
    }

    public static DegreeGradingTable find(ExecutionYear ey, ProgramConclusion pc, Registration reg) {
        return reg.getDegreeGradingTablesSet().stream().filter(dgt -> dgt.getExecutionYear() == ey).filter(dgt -> dgt.getProgramConclusion() == pc).findFirst().orElse(DegreeGradingTable.find(ey, pc, reg.getDegree()));
    }

    public static String getEctsGrade(RegistrationConclusionBean registrationConclusionBean) {
        DegreeGradingTable table;
        if (registrationConclusionBean != null && registrationConclusionBean.getFinalGrade() != null && registrationConclusionBean.getFinalGrade().getValue() != null && (table = DegreeGradingTable.find(registrationConclusionBean.getConclusionYear(), registrationConclusionBean.getProgramConclusion(), registrationConclusionBean.getRegistration())) != null) {
            return table.getEctsGrade(registrationConclusionBean.getFinalGrade().getValue());
        }
        return "-";
    }

    public static Set<DegreeGradingTable> generate(final ExecutionYear executionYear) {
        HashSet<DegreeGradingTable> allTables = new HashSet<DegreeGradingTable>();
        HashSet<DataTuple> allTablesMetaData = new HashSet<DataTuple>();
        Set dcps = executionYear.getExecutionDegreesSet().stream().map(ed -> ed.getDegreeCurricularPlan()).collect(Collectors.toSet());
        for (DegreeCurricularPlan dcp : dcps) {
            final Degree degree = dcp.getDegree();
            if (!GradingTableSettings.getApplicableDegreeTypes().contains(degree.getDegreeType())) continue;
            block3: for (final ProgramConclusion programConclusion : ProgramConclusion.conclusionsFor((DegreeCurricularPlan)dcp).collect(Collectors.toSet())) {
                DegreeGradingTable table = DegreeGradingTable.find(executionYear, programConclusion, degree);
                if (table == null) {
                    for (DataTuple dataTuple : allTablesMetaData) {
                        if (dataTuple.getExecutionYear() != executionYear || dataTuple.getProgramConclusion() != programConclusion || dataTuple.getDegree() != degree) continue;
                        continue block3;
                    }
                }
                if (table == null) {
                    allTablesMetaData.add(new DataTuple(degree, executionYear, programConclusion));
                    CallableWithoutException<DegreeGradingTable> workerLogic = new CallableWithoutException<DegreeGradingTable>(){

                        public DegreeGradingTable call() {
                            DegreeGradingTable table = new DegreeGradingTable();
                            table.setExecutionYear(executionYear);
                            table.setProgramConclusion(programConclusion);
                            table.setDegree(degree);
                            table.compileData();
                            return table;
                        }
                    };
                    GradingTable.GeneratorWorker<DegreeGradingTable> worker = new GradingTable.GeneratorWorker<DegreeGradingTable>(workerLogic);
                    worker.start();
                    try {
                        worker.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    allTables.add(worker.getTable());
                    continue;
                }
                allTables.add(table);
            }
        }
        return allTables;
    }

    public void compileData() {
        GradingTableData tableData = new GradingTableData();
        this.setData(tableData);
        List<BigDecimal> sample = this.harvestSample();
        if (sample != null) {
            GradingTableGenerator.generateTableData((GradingTable)((Object)this), sample);
        } else {
            InstitutionGradingTable.copyData((GradingTable)((Object)this));
            this.setCopied(true);
        }
        this.checkUniquenessOfTable();
    }

    private void checkUniquenessOfTable() {
        if (DegreeGradingTable.find(this.getExecutionYear()).stream().anyMatch(t -> t != this && t.getDegree() == this.getDegree() && t.getProgramConclusion() == this.getProgramConclusion())) {
            throw new AcademicExtensionsDomainException("error.DegreeGradingTable.already.exists", this.getExecutionYear().getQualifiedName(), "[" + this.getDegree().getCode() + "] " + this.getDegree().getPresentationName(), this.getProgramConclusion().getName().getContent());
        }
    }

    private List<BigDecimal> harvestSample() {
        ArrayList<BigDecimal> sample = new ArrayList<BigDecimal>();
        int coveredYears = 0;
        boolean sampleOK = false;
        Map<ExecutionYear, Set<RegistrationConclusionBean>> conclusionsMap = this.collectConclusions();
        for (ExecutionYear year = this.getExecutionYear().getPreviousExecutionYear(); year != null; year = year.getPreviousExecutionYear()) {
            if (conclusionsMap.get(year) != null) {
                for (RegistrationConclusionBean bean : conclusionsMap.get(year)) {
                    Grade finalGrade = bean.getFinalGrade();
                    Integer finalAverage = finalGrade.isNumeric() && finalGrade.getNumericValue() != null ? finalGrade.getNumericValue().setScale(0, RoundingMode.HALF_UP).intValue() : 0;
                    if (finalAverage == 0) continue;
                    sample.add(new BigDecimal(finalAverage));
                }
            }
            if (++coveredYears >= GradingTableSettings.getMinimumPastYears() && sample.size() >= GradingTableSettings.getMinimumSampleSize()) {
                sampleOK = true;
                break;
            }
            if (coveredYears == GradingTableSettings.getMaximumPastYears()) break;
        }
        return sampleOK ? sample : null;
    }

    private Map<ExecutionYear, Set<RegistrationConclusionBean>> collectConclusions() {
        LinkedHashMap<ExecutionYear, Set<RegistrationConclusionBean>> conclusionsMap = new LinkedHashMap<ExecutionYear, Set<RegistrationConclusionBean>>();
        for (Registration registration : this.getDegree().getRegistrationsSet()) {
            if (registration.getStudentCurricularPlansSet().isEmpty()) continue;
            for (RegistrationConclusionInformation info : RegistrationConclusionServices.inferConclusion(registration)) {
                if (info.getCurriculumGroup() == null || !info.isConcluded()) continue;
                ExecutionYear conclusionYear = info.getRegistrationConclusionBean().getConclusionYear();
                if (!conclusionsMap.containsKey(conclusionYear)) {
                    conclusionsMap.put(conclusionYear, new HashSet());
                }
                ((Set)conclusionsMap.get(conclusionYear)).add(info.getRegistrationConclusionBean());
            }
        }
        return conclusionsMap;
    }

    public static class DataTuple {
        private Degree degree;
        private ExecutionYear executionYear;
        private ProgramConclusion programConclusion;

        public DataTuple(Degree degree, ExecutionYear executionYear, ProgramConclusion programConclusion) {
            this.setDegree(degree);
            this.setExecutionYear(executionYear);
            this.setProgramConclusion(programConclusion);
        }

        public Degree getDegree() {
            return this.degree;
        }

        public void setDegree(Degree degree) {
            this.degree = degree;
        }

        public ExecutionYear getExecutionYear() {
            return this.executionYear;
        }

        public void setExecutionYear(ExecutionYear executionYear) {
            this.executionYear = executionYear;
        }

        public ProgramConclusion getProgramConclusion() {
            return this.programConclusion;
        }

        public void setProgramConclusion(ProgramConclusion programConclusion) {
            this.programConclusion = programConclusion;
        }
    }
}

