/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum;

import com.google.common.base.Predicate;
import java.math.BigDecimal;
import java.util.TreeSet;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularRules.CreditsLimit;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.student.curriculum.CurriculumLineServices;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.joda.time.YearMonthDay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurriculumModuleServices {
    public static final Logger logger = LoggerFactory.getLogger(CurriculumModuleServices.class);

    public static BigDecimal getCreditsConcluded(CurriculumGroup toInspect, ExecutionInterval interval) {
        if (interval instanceof ExecutionSemester) {
            return CurriculumModuleServices.getCreditsConcluded(toInspect, (ExecutionSemester)ExecutionInterval.assertExecutionIntervalType(ExecutionSemester.class, (ExecutionInterval)interval));
        }
        return BigDecimal.valueOf(toInspect.getCreditsConcluded((ExecutionYear)ExecutionInterval.assertExecutionIntervalType(ExecutionYear.class, (ExecutionInterval)interval)));
    }

    private static BigDecimal getCreditsConcluded(CurriculumGroup toInspect, ExecutionSemester semester) {
        BigDecimal result = BigDecimal.ZERO;
        if (toInspect.isNoCourseGroupCurriculumGroup()) {
            return result;
        }
        for (CurriculumModule iter : toInspect.getCurriculumModulesSet()) {
            result = result.add(CurriculumModuleServices.getCreditsConcluded(iter, semester));
        }
        CreditsLimit rule = (CreditsLimit)toInspect.getMostRecentActiveCurricularRule(CurricularRuleType.CREDITS_LIMIT, semester);
        if (rule == null) {
            return result;
        }
        return result.min(BigDecimal.valueOf(rule.getMaximumCredits()));
    }

    private static BigDecimal getCreditsConcluded(CurriculumModule toInspect, ExecutionSemester semester) {
        BigDecimal result = BigDecimal.ZERO;
        if (CurriculumGroup.class.isAssignableFrom(toInspect.getClass())) {
            result = CurriculumModuleServices.getCreditsConcluded((CurriculumGroup)toInspect, semester);
        } else if (Enrolment.class.isAssignableFrom(toInspect.getClass())) {
            result = CurriculumModuleServices.getCreditsConcluded((Enrolment)toInspect, semester);
        } else if (Dismissal.class.isAssignableFrom(toInspect.getClass())) {
            result = CurriculumModuleServices.getCreditsConcluded((Dismissal)toInspect, semester);
        }
        return result;
    }

    private static BigDecimal getCreditsConcluded(Enrolment toInspect, ExecutionSemester semester) {
        return semester == null || toInspect.getExecutionPeriod().isBeforeOrEquals(semester) ? BigDecimal.valueOf(toInspect.getAprovedEctsCredits()) : BigDecimal.ZERO;
    }

    private static BigDecimal getCreditsConcluded(Dismissal toInspect, ExecutionSemester semester) {
        return semester == null || toInspect.getExecutionPeriod() == null || toInspect.getExecutionPeriod().isBeforeOrEquals(semester) && !toInspect.getCredits().isTemporary() ? BigDecimal.valueOf(toInspect.getEctsCredits()) : BigDecimal.ZERO;
    }

    public static BigDecimal getEnroledAndNotApprovedEctsCreditsFor(CurriculumGroup toInspect, ExecutionInterval interval) {
        if (interval instanceof ExecutionSemester) {
            return CurriculumModuleServices.getEnroledAndNotApprovedEctsCreditsFor(toInspect, (ExecutionSemester)ExecutionInterval.assertExecutionIntervalType(ExecutionSemester.class, (ExecutionInterval)interval));
        }
        ExecutionYear year = (ExecutionYear)ExecutionInterval.assertExecutionIntervalType(ExecutionYear.class, (ExecutionInterval)interval);
        return year.getExecutionPeriodsSet().stream().map(i -> CurriculumModuleServices.getEnroledAndNotApprovedEctsCreditsFor(toInspect, i)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private static BigDecimal getEnroledAndNotApprovedEctsCreditsFor(CurriculumGroup toInspect, ExecutionSemester semester) {
        BigDecimal result = BigDecimal.ZERO;
        for (CurriculumModule iter : toInspect.getCurriculumModulesSet()) {
            result = result.add(CurriculumModuleServices.getEnroledAndNotApprovedEctsCreditsFor(iter, semester));
        }
        return result;
    }

    private static BigDecimal getEnroledAndNotApprovedEctsCreditsFor(CurriculumModule toInspect, ExecutionSemester semester) {
        BigDecimal result = BigDecimal.ZERO;
        if (CurriculumGroup.class.isAssignableFrom(toInspect.getClass())) {
            result = CurriculumModuleServices.getEnroledAndNotApprovedEctsCreditsFor((CurriculumGroup)toInspect, semester);
        } else if (Enrolment.class.isAssignableFrom(toInspect.getClass())) {
            result = CurriculumModuleServices.getEnroledAndNotApprovedEctsCreditsFor((Enrolment)toInspect, semester);
        }
        return result;
    }

    private static BigDecimal getEnroledAndNotApprovedEctsCreditsFor(Enrolment toInspect, ExecutionSemester semester) {
        if (CurriculumLineServices.isExcludedFromCurriculum((CurriculumLine)toInspect)) {
            return BigDecimal.ZERO;
        }
        if (toInspect.isAnnulled()) {
            return BigDecimal.ZERO;
        }
        if (!(toInspect.isEnroled() || toInspect.isNotEvaluated() || toInspect.isFlunked())) {
            return BigDecimal.ZERO;
        }
        if (!toInspect.isValid(semester)) {
            return BigDecimal.ZERO;
        }
        if (toInspect.isAnual() && !semester.isFirstOfYear()) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = toInspect.getEctsCreditsForCurriculum();
        logger.debug("{}#UC {}#{} ECTS", new Object[]{toInspect.getCode(), semester.getQualifiedName(), result.toPlainString()});
        return result;
    }

    public static YearMonthDay calculateLastAcademicActDate(CurriculumGroup group, final ExecutionYear executionYear, boolean forConclusion) {
        return CurriculumModuleServices.calculateLastAcademicActDate(group, new Predicate<CurriculumLine>(){

            public boolean apply(CurriculumLine toEval) {
                return toEval.getExecutionYear() == executionYear;
            }
        }, forConclusion);
    }

    public static YearMonthDay calculateLastAcademicActDate(CurriculumGroup group, final boolean forConclusion) {
        return CurriculumModuleServices.calculateLastAcademicActDate(group, new Predicate<CurriculumLine>(){

            public boolean apply(CurriculumLine toEval) {
                return !forConclusion || toEval.isApproved();
            }
        }, forConclusion);
    }

    private static YearMonthDay calculateLastAcademicActDate(CurriculumGroup group, Predicate<CurriculumLine> predicate, boolean forConclusion) {
        TreeSet<YearMonthDay> result = new TreeSet<YearMonthDay>();
        for (CurriculumLine line : group.getAllCurriculumLines()) {
            YearMonthDay lineAcademicActDate;
            if (line.getCurriculumGroup().isNoCourseGroupCurriculumGroup() || CurriculumLineServices.isAffinity(line) || !predicate.apply((Object)line) || (lineAcademicActDate = CurriculumLineServices.getAcademicActDate(line, forConclusion)) == null) continue;
            result.add(lineAcademicActDate);
        }
        return result.isEmpty() ? null : (YearMonthDay)result.last();
    }
}

