/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.evaluation.season;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.OccupationPeriod;
import org.fenixedu.academic.domain.OccupationPeriodReference;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonPeriod$callable$addDegree;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonPeriod$callable$addInterval;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonPeriod$callable$create;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonPeriod$callable$delete;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonPeriod$callable$removeDegree;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonPeriod$callable$removeInterval;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonPeriodType;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonPeriod_Base;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.executionPlanning.services.OccupationPeriodServices;
import org.fenixedu.academic.util.date.IntervalTools;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EvaluationSeasonPeriod
extends EvaluationSeasonPeriod_Base
implements Comparable<EvaluationSeasonPeriod>,
OccupationPeriodServices.OccupationPeriodPartner {
    private static Comparator<Interval> COMPARATOR_INTERVAL;
    private static final Gson intervalsGson;
    public static final Advice advice$create;
    public static final Advice advice$addDegree;
    public static final Advice advice$removeDegree;
    public static final Advice advice$addInterval;
    public static final Advice advice$removeInterval;
    public static final Advice advice$delete;

    protected EvaluationSeasonPeriod() {
    }

    public static EvaluationSeasonPeriod create(ExecutionSemester executionSemester, EvaluationSeasonPeriodType evaluationSeasonPeriodType, EvaluationSeason evaluationSeason, Set<DegreeType> set, LocalDate localDate, LocalDate localDate2) {
        return (EvaluationSeasonPeriod)advice$create.perform((Callable)new EvaluationSeasonPeriod$callable$create(executionSemester, evaluationSeasonPeriodType, evaluationSeason, set, localDate, localDate2));
    }

    static /* synthetic */ EvaluationSeasonPeriod advised$create(ExecutionSemester executionSemester, EvaluationSeasonPeriodType periodType, EvaluationSeason evaluationSeason, Set<DegreeType> degreeTypes, LocalDate start, LocalDate end) {
        EvaluationSeasonPeriod result = new EvaluationSeasonPeriod();
        result.setExecutionSemester(executionSemester);
        result.setSeason(evaluationSeason);
        result.setPeriodType(periodType);
        result.addInterval(start, end);
        Set<ExecutionDegree> initialExecutionDegrees = result.getInitialExecutionDegrees(degreeTypes);
        result.getExecutionDegreesSet().addAll(initialExecutionDegrees);
        result.setOccupationPeriod(OccupationPeriodServices.createOccupationPeriod(result, start, end, initialExecutionDegrees, periodType.translate()));
        result.checkRules();
        return result;
    }

    private Set<ExecutionDegree> getInitialExecutionDegrees(Set<DegreeType> degreeTypes) {
        HashSet result = Sets.newHashSet();
        ExecutionYear year = this.getExecutionYear();
        if (year != null && degreeTypes != null && !degreeTypes.isEmpty()) {
            result.addAll(ExecutionDegree.getAllByExecutionYearAndDegreeType((ExecutionYear)year, (DegreeType[])degreeTypes.toArray(new DegreeType[degreeTypes.size()])));
        }
        return result;
    }

    @Override
    public Function<OccupationPeriod, OccupationPeriod> setOccupationPeriod() {
        return occupationPeriod -> {
            this.setOccupationPeriod((OccupationPeriod)occupationPeriod);
            return occupationPeriod;
        };
    }

    @Override
    public Function<OccupationPeriodReference, OccupationPeriodReference> createdReferenceCleanup() {
        return reference -> {
            if (reference != null) {
                reference.getEvaluationSeasonSet().clear();
                reference.addEvaluationSeason(this.getSeason());
            }
            return reference;
        };
    }

    private void checkRules() {
        this.checkConsistencySeason();
    }

    private void checkConsistencySeason() {
        for (OccupationPeriodReference reference : this.getReferences()) {
            for (EvaluationSeason season : reference.getEvaluationSeasonSet()) {
                if (season == this.getSeason()) continue;
                throw new AcademicExtensionsDomainException("error.EvaluationSeasonPeriod.evaluationSeason.inconsistent", new String[0]);
            }
        }
    }

    private void checkDuplicates() {
        for (EvaluationSeasonPeriod iter : EvaluationSeasonPeriod.findBy(this.getExecutionSemester(), this.getPeriodType())) {
            if (iter == this || iter.getSeason() != this.getSeason() || !iter.getOccupationPeriod().isEqualTo(this.getOccupationPeriod())) continue;
            throw new AcademicExtensionsDomainException("error.EvaluationSeasonPeriod.occupationPeriod.duplicate", new String[0]);
        }
    }

    public void addDegree(ExecutionDegree executionDegree) {
        Object object = advice$addDegree.perform((Callable)new EvaluationSeasonPeriod$callable$addDegree(this, executionDegree));
    }

    static /* synthetic */ void advised$addDegree(EvaluationSeasonPeriod this_, ExecutionDegree input) {
        OccupationPeriodServices.addDegree(this_, input);
        this_.checkRules();
        if (this_.getExecutionDegreesSet().isEmpty()) {
            this_.getExecutionDegreesSet().addAll(this_.getExecutionDegreesByOccupationPeriodReferences());
        }
        this_.getExecutionDegreesSet().add(input);
    }

    public void removeDegree(ExecutionDegree executionDegree) {
        Object object = advice$removeDegree.perform((Callable)new EvaluationSeasonPeriod$callable$removeDegree(this, executionDegree));
    }

    static /* synthetic */ void advised$removeDegree(EvaluationSeasonPeriod this_, ExecutionDegree input) {
        OccupationPeriodServices.removeDegree(this_, input);
        this_.checkRules();
        this_.getExecutionDegreesSet().remove(input);
    }

    public void addInterval(LocalDate localDate, LocalDate localDate2) {
        Object object = advice$addInterval.perform((Callable)new EvaluationSeasonPeriod$callable$addInterval(this, localDate, localDate2));
    }

    static /* synthetic */ void advised$addInterval(EvaluationSeasonPeriod this_, LocalDate start, LocalDate end) {
        List<Interval> intervals = this_.getIntervals();
        intervals.add(IntervalTools.getInterval((LocalDate)start, (LocalDate)end));
        intervals.sort(COMPARATOR_INTERVAL);
        this_.setIntervalsRaw(intervalsGson.toJsonTree(intervals));
    }

    public void removeInterval(LocalDate localDate, LocalDate localDate2) {
        Object object = advice$removeInterval.perform((Callable)new EvaluationSeasonPeriod$callable$removeInterval(this, localDate, localDate2));
    }

    static /* synthetic */ void advised$removeInterval(EvaluationSeasonPeriod this_, LocalDate start, LocalDate end) {
        List<Interval> intervals = this_.getIntervals();
        intervals.removeIf(i -> i.getStart().toLocalDate().equals((Object)start) && i.getEnd().toLocalDate().equals((Object)end));
        if (intervals.isEmpty()) {
            throw new AcademicExtensionsDomainException("error.OccupationPeriod.required.Interval", new String[0]);
        }
        intervals.sort(COMPARATOR_INTERVAL);
        this_.setIntervalsRaw(intervalsGson.toJsonTree(intervals));
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new EvaluationSeasonPeriod$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(EvaluationSeasonPeriod this_) {
        super.setExecutionSemester(null);
        super.setSeason(null);
        OccupationPeriod occupationPeriod = this_.getOccupationPeriod();
        super.setOccupationPeriod(null);
        OccupationPeriodServices.deleteOccupationPeriod(occupationPeriod);
        AcademicExtensionsDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        this_.deleteDomainObject();
    }

    public static Set<EvaluationSeasonPeriod> findBy(ExecutionYear executionYear, EvaluationSeasonPeriodType periodType) {
        HashSet result = Sets.newHashSet();
        if (executionYear != null && periodType != null) {
            for (ExecutionSemester semester : executionYear.getExecutionPeriodsSet()) {
                result.addAll(EvaluationSeasonPeriod.findBy(semester, periodType));
            }
        }
        return result;
    }

    public static Set<EvaluationSeasonPeriod> findBy(ExecutionSemester semester, EvaluationSeasonPeriodType periodType) {
        HashSet result = Sets.newHashSet();
        if (semester != null && periodType != null) {
            for (EvaluationSeasonPeriod period : semester.getEvaluationSeasonPeriodSet()) {
                if (period.getPeriodType() != periodType) continue;
                result.add(period);
            }
        }
        return result;
    }

    public static Set<EvaluationSeasonPeriod> findBy(ExecutionYear executionYear) {
        return executionYear != null ? executionYear.getExecutionPeriodsSet().stream().flatMap(es -> es.getEvaluationSeasonPeriodSet().stream()).collect(Collectors.toSet()) : new HashSet<EvaluationSeasonPeriod>();
    }

    public EvaluationSeasonPeriodType getPeriodType() {
        return super.getPeriodType() != null ? super.getPeriodType() : EvaluationSeasonPeriodType.get(this.getOccupationPeriod());
    }

    private ExecutionYear getExecutionYear() {
        return this.getExecutionSemester().getExecutionYear();
    }

    public static String getIntervalsDescription(Set<EvaluationSeasonPeriod> input) {
        LinkedList intervals = Lists.newLinkedList();
        for (EvaluationSeasonPeriod period : input) {
            intervals.addAll(period.getIntervals());
        }
        return OccupationPeriodServices.getIntervalsDescription(intervals);
    }

    public String getIntervalsDescription() {
        return OccupationPeriodServices.getIntervalsDescription(this.getIntervals());
    }

    @Override
    public int compareTo(EvaluationSeasonPeriod other) {
        OccupationPeriod o1 = this.getOccupationPeriod();
        OccupationPeriod o2 = other.getOccupationPeriod();
        return OccupationPeriodServices.COMPARATOR.compare(o1, o2);
    }

    public String getDegreesDescription() {
        StringBuilder result = new StringBuilder();
        LinkedHashMap mapped = Maps.newLinkedHashMap();
        this.getExecutionDegrees().stream().sorted(ExecutionDegree.EXECUTION_DEGREE_COMPARATORY_BY_DEGREE_TYPE_AND_NAME_AND_EXECUTION_YEAR).forEach(i -> {
            DegreeType key = i.getDegreeType();
            if (!mapped.containsKey(key)) {
                mapped.put(key, Sets.newLinkedHashSet());
            }
            ((Set)mapped.get(key)).add(i);
        });
        Iterator iterator = mapped.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            int size = ((Set)entry.getValue()).size();
            if (size == 0) continue;
            result.append(size);
            result.append(" - ");
            result.append(((DegreeType)entry.getKey()).getName().getContent());
            if (!iterator.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public Set<ExecutionDegree> getExecutionDegrees() {
        return !this.getExecutionDegreesSet().isEmpty() ? this.getExecutionDegreesSet() : this.getExecutionDegreesByOccupationPeriodReferences();
    }

    public Set<ExecutionDegree> getExecutionDegreesByOccupationPeriodReferences() {
        return OccupationPeriodServices.getExecutionDegrees(this);
    }

    private Set<OccupationPeriodReference> getReferences() {
        return OccupationPeriodServices.getReferences(this);
    }

    public List<Interval> getIntervals() {
        if (this.getIntervalsRaw() != null) {
            ArrayList<Interval> result = new ArrayList<Interval>();
            this.getIntervalsRaw().getAsJsonArray().forEach(elem -> result.add((Interval)intervalsGson.fromJson(elem, Interval.class)));
            return result;
        }
        return OccupationPeriodServices.getIntervals(this);
    }

    public boolean isContainingDate(LocalDate date) {
        return this.getIntervals().stream().anyMatch(i -> i.contains((ReadableInstant)date.toDateTimeAtStartOfDay()));
    }

    public boolean migrateIntervals() {
        if (this.getIntervalsRaw() == null) {
            List<Interval> intervals = this.getIntervals();
            this.setIntervalsRaw(intervalsGson.toJsonTree(intervals));
            return true;
        }
        return false;
    }

    public boolean migratePeriodType() {
        if (super.getPeriodType() == null) {
            this.setPeriodType(this.getPeriodType());
            return true;
        }
        return false;
    }

    public boolean migrateDegrees() {
        if (super.getExecutionDegreesSet().isEmpty()) {
            super.getExecutionDegreesSet().addAll(this.getExecutionDegreesByOccupationPeriodReferences());
            return true;
        }
        return false;
    }

    static {
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$addDegree = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$removeDegree = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$addInterval = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$removeInterval = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_INTERVAL = (x, y) -> x.getStart().compareTo((ReadableInstant)y.getStart());
        intervalsGson = new GsonBuilder().registerTypeAdapter(Interval.class, (Object)new JsonSerializer<Interval>(){

            public JsonElement serialize(Interval src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject json = new JsonObject();
                json.addProperty("start", src.getStart().toString());
                json.addProperty("end", src.getEnd().toString());
                return json;
            }
        }).registerTypeAdapter(Interval.class, (Object)new JsonDeserializer<Interval>(){

            public Interval deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                DateTime start = new DateTime((Object)jsonObject.get("start").getAsString());
                DateTime end = new DateTime((Object)jsonObject.get("end").getAsString());
                return new Interval((ReadableInstant)start, (ReadableInstant)end);
            }
        }).create();
    }
}

