/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.evaluation;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.enrolment.EnrolmentServices;
import org.fenixedu.academic.domain.evaluation.EnrolmentEvaluationExtendedInformation;
import org.fenixedu.academic.domain.evaluation.EnrolmentEvaluationServices$callable$activate;
import org.fenixedu.academic.domain.evaluation.EnrolmentEvaluationServices$callable$annul;
import org.fenixedu.academic.domain.evaluation.EvaluationServices;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet;
import org.fenixedu.academic.util.EnrolmentEvaluationState;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EnrolmentEvaluationServices
extends org.fenixedu.academic.domain.evaluation.services.EnrolmentEvaluationServices {
    public static final Advice advice$annul = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$activate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void setRemarks(EnrolmentEvaluation enrolmentEvaluation, String remarks) {
        EnrolmentEvaluationExtendedInformation.findOrCreate(enrolmentEvaluation).setRemarks(remarks);
    }

    public static String getRemarks(EnrolmentEvaluation enrolmentEvaluation) {
        return enrolmentEvaluation.getExtendedInformation() == null ? null : enrolmentEvaluation.getExtendedInformation().getRemarks();
    }

    public static String getExamDatePresentation(EnrolmentEvaluation input) {
        String result = null;
        DateTime examDateTime = EnrolmentEvaluationServices.getExamDateTime(input);
        if (examDateTime != null) {
            result = examDateTime.toString().contains("T00:00") ? examDateTime.toString("yyyy-MM-dd") : examDateTime.toString("yyyy-MM-dd HH:mm");
        }
        return result;
    }

    public static DateTime getExamDateTime(EnrolmentEvaluation input) {
        DateTime result = null;
        if (input != null) {
            CompetenceCourseMarkSheet sheet = input.getCompetenceCourseMarkSheet();
            if (sheet != null) {
                result = sheet.getEvaluationDateTime();
            }
            if (result == null) {
                result = EvaluationServices.findEnrolmentCourseEvaluations(input.getEnrolment(), input.getEvaluationSeason(), input.getExecutionPeriod()).stream().filter(ev -> ev.getEvaluationDate() != null).map(ev -> new DateTime((Object)ev.getEvaluationDate())).max((x, y) -> x.compareTo((ReadableInstant)y)).orElse(null);
            }
            if (result == null && input.getExamDateYearMonthDay() != null) {
                result = input.getExamDateYearMonthDay().toDateTimeAtMidnight();
            }
        }
        return result;
    }

    public static void annul(EnrolmentEvaluation enrolmentEvaluation) {
        Object object = advice$annul.perform((Callable)new EnrolmentEvaluationServices$callable$annul(enrolmentEvaluation));
    }

    static /* synthetic */ void advised$annul(EnrolmentEvaluation evaluation) {
        if (!evaluation.isAnnuled()) {
            Enrolment enrolment = evaluation.getEnrolment();
            evaluation.setEnrolmentEvaluationState(EnrolmentEvaluationState.ANNULED_OBJ);
            EnrolmentEvaluationServices.onStateChange(evaluation);
            EnrolmentServices.updateState(enrolment);
        }
    }

    public static void activate(EnrolmentEvaluation enrolmentEvaluation) {
        Object object = advice$activate.perform((Callable)new EnrolmentEvaluationServices$callable$activate(enrolmentEvaluation));
    }

    static /* synthetic */ void advised$activate(EnrolmentEvaluation evaluation) {
        if (evaluation.isAnnuled()) {
            Enrolment enrolment = evaluation.getEnrolment();
            evaluation.setEnrolmentEvaluationState(EnrolmentEvaluationState.TEMPORARY_OBJ);
            EnrolmentEvaluationServices.onStateChange(evaluation);
            EnrolmentServices.updateState(enrolment);
        }
    }
}

