/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.enrolment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.OptionalEnrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curriculum.EnrolmentEvaluationContext;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.ConclusionProcessVersion;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroup;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class EnrolmentServices
extends org.fenixedu.academic.domain.student.services.EnrolmentServices {
    private static RelationListener<DegreeModule, CurriculumModule> ON_ENROLMENT_DELETION = new RelationAdapter<DegreeModule, CurriculumModule>(){

        public void beforeRemove(DegreeModule degreeModule, CurriculumModule module) {
            if (module == null || degreeModule == null) {
                return;
            }
            if (!(module instanceof Enrolment)) {
                return;
            }
            Enrolment enrolment = (Enrolment)module;
            EnrolmentServices.removeConclusionProcessVersionsExceptLast(enrolment);
            EnrolmentServices.checkForConclusionProcessVersions(enrolment);
        }
    };

    public static String getPresentationName(Enrolment enrolment) {
        String code;
        String string = code = !StringUtils.isEmpty((String)enrolment.getCurricularCourse().getCode()) ? enrolment.getCurricularCourse().getCode() + " - " : "";
        if (enrolment instanceof OptionalEnrolment) {
            OptionalEnrolment optionalEnrolment = (OptionalEnrolment)enrolment;
            return optionalEnrolment.getOptionalCurricularCourse().getNameI18N(enrolment.getExecutionPeriod()).getContent() + " (" + code + optionalEnrolment.getCurricularCourse().getNameI18N(optionalEnrolment.getExecutionPeriod()).getContent() + ")";
        }
        return code + enrolment.getName().getContent();
    }

    public static void checkForConclusionProcessVersions(Enrolment enrolment) {
        if (enrolment.isApproved() && !enrolment.getConclusionProcessVersionsSet().isEmpty()) {
            Registration registration = enrolment.getRegistration();
            throw new DomainException("error.conclusionProcess.revertion.required", new String[]{"\"" + registration.getNumber() + " - " + registration.getPerson().getPresentationName() + "\"", "\"" + EnrolmentServices.getPresentationName(enrolment) + "\"", enrolment.getConclusionProcessVersionsSet().stream().map(i -> "\"" + i.getConclusionProcess().getName().getContent() + "\"").distinct().collect(Collectors.joining("; "))});
        }
    }

    private static void removeConclusionProcessVersionsExceptLast(Enrolment enrolment) {
        Iterator iter = enrolment.getConclusionProcessVersionsSet().iterator();
        while (iter.hasNext()) {
            ConclusionProcessVersion version = (ConclusionProcessVersion)iter.next();
            if (version.getConclusionProcess().getLastVersion() == version) continue;
            iter.remove();
        }
    }

    public static Set<ExecutionCourse> getExecutionCourses(Enrolment enrolment, ExecutionSemester semester) {
        CurricularCourse curricular;
        HashSet<ExecutionCourse> result = new HashSet<ExecutionCourse>();
        if (enrolment != null && (curricular = enrolment.getCurricularCourse()) != null) {
            result.addAll(curricular.getCompetenceCourse().getExecutionCoursesByExecutionPeriod((ExecutionInterval)semester));
        }
        return result;
    }

    public static ExecutionCourse getExecutionCourseUnique(Enrolment enrolment, ExecutionSemester semester) {
        Set<ExecutionCourse> all = EnrolmentServices.getExecutionCourses(enrolment, semester);
        if (all.size() == 1) {
            return all.iterator().next();
        }
        CurricularCourse curricular = enrolment.getCurricularCourse();
        List filtered = all.stream().filter(ec -> ec.getAssociatedCurricularCoursesSet().contains(curricular)).collect(Collectors.toList());
        if (filtered.size() == 1) {
            return (ExecutionCourse)filtered.iterator().next();
        }
        return null;
    }

    public static List<Enrolment> getEnrolmentsToEnrol(StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester, EvaluationSeason evaluationSeason, Enrolment.EnrolmentPredicate predicate) {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        EnrolmentServices.getCurriculumGroupsToEnrol((CurriculumGroup)studentCurricularPlan.getRoot());
        ArrayList<Enrolment> allEnrolments = new ArrayList<Enrolment>();
        EnrolmentServices.getEnrolmentsToEnrol((CurriculumGroup)studentCurricularPlan.getRoot(), allEnrolments);
        for (Enrolment enrolment : allEnrolments) {
            if (!predicate.fill(evaluationSeason, executionSemester, EnrolmentEvaluationContext.MARK_SHEET_EVALUATION).testExceptionless(enrolment)) continue;
            result.add(enrolment);
        }
        return result;
    }

    public static Set<CurriculumGroup> getCurriculumGroupsToEnrol(CurriculumGroup curriculumGroup) {
        Set curriculumGroupsToEnrol = curriculumGroup.getCurriculumGroupsToEnrolmentProcess();
        if (!curriculumGroup.isNoCourseGroupCurriculumGroup()) {
            for (NoCourseGroupCurriculumGroup group : curriculumGroup.getNoCourseGroupCurriculumGroups()) {
                if (!group.isVisible()) continue;
                curriculumGroupsToEnrol.add(group);
            }
        }
        return curriculumGroupsToEnrol;
    }

    public static List<Enrolment> getEnrolmentsToEnrol(CurriculumGroup curriculumGroup, List<Enrolment> enrolmentList) {
        for (CurriculumModule curriculumModule : curriculumGroup.getCurriculumModulesSet()) {
            if (!curriculumModule.isEnrolment()) continue;
            Enrolment enrolment = (Enrolment)curriculumModule;
            enrolmentList.add(enrolment);
        }
        Set<CurriculumGroup> curriculumGroupsToEnrolmentProcess = EnrolmentServices.getCurriculumGroupsToEnrol(curriculumGroup);
        for (CurriculumGroup group : curriculumGroupsToEnrolmentProcess) {
            EnrolmentServices.getEnrolmentsToEnrol(group, enrolmentList);
        }
        return enrolmentList;
    }

    static {
        CurriculumModule.getRelationDegreeModuleCurriculumModule().addListener(ON_ENROLMENT_DELETION);
    }
}

